/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DetectStringLiteral
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected Pattern[] stringLiterals = null;

    public DetectStringLiteral(String ruleName, String desc, Pattern[] stringsToLookFor, boolean flagOnce) {
        this(ruleName, desc, stringsToLookFor, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false);
    }

    public DetectStringLiteral(String ruleName, String desc, Pattern[] stringsToLookFor, DetectRule.FlagOnce flagOnceType, boolean hideResult) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.stringLiterals = stringsToLookFor;
    }

    public Pattern[] getStringLiterals() {
        return this.stringLiterals;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        block23: {
            block22: {
                if (detectOnce && !this.detailResults.isEmpty()) {
                    return;
                }
                if (!detectOnce) break block22;
                Pattern[] patternArray = this.stringLiterals;
                int n = this.stringLiterals.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern thisLiteral = patternArray[n2];
                    if (store.containsStringLiteral(thisLiteral)) {
                        this.detailResults.add(new DetailResult(this.ruleName, "File name unavailable", this.ruleDescription, thisLiteral.pattern()));
                        return;
                    }
                    ++n2;
                }
                break block23;
            }
            Set<String> keys = store.getClassDataStoreKeys();
            if (keys.isEmpty()) break block23;
            for (String key : keys) {
                if (!this.shouldFlag(key)) continue;
                ClassDataStore data = store.getClassDataStore(key);
                Pattern[] patternArray = this.stringLiterals;
                int n = this.stringLiterals.length;
                int n3 = 0;
                while (n3 < n) {
                    Pattern thisLiteral = patternArray[n3];
                    Set<ClassOrPackageDetails> cpds = data.getStringLiteralDetails(thisLiteral);
                    for (ClassOrPackageDetails cd : cpds) {
                        Map<String, ClassOrPackageOccurrence> info = cd.getReferenceAndLineInfo();
                        Set<String> methodKeys = info.keySet();
                        ArrayList<String> sortedKeys = new ArrayList<String>(methodKeys);
                        Collections.sort(sortedKeys);
                        int numKeys = sortedKeys.size();
                        int i = 0;
                        while (i < numKeys) {
                            String methodKey;
                            String reference = methodKey = (String)sortedKeys.get(i);
                            if (methodKey.contains("<init>")) {
                                reference = Messages.getString("Report_Reference_Constructor");
                            } else if (methodKey.contains("<clinit>")) {
                                reference = Messages.getString("Report_Reference_Static_Initializer");
                            }
                            ClassOrPackageOccurrence copo = info.get(methodKey);
                            List<Integer> sortedLines = copo.getLineNumbers();
                            Collections.sort(sortedLines);
                            int numLines = sortedLines.size();
                            int numLineOccurrences = 0;
                            int lastLineNumber = 0;
                            boolean lastLineNumberSet = false;
                            int j = 0;
                            while (j < numLines) {
                                Integer lineNumber = sortedLines.get(j);
                                int thisLineNumber = lineNumber;
                                if (lastLineNumberSet && thisLineNumber == lastLineNumber) {
                                    ++numLineOccurrences;
                                } else if (lastLineNumberSet && this.includeInResults(cd, key)) {
                                    if (this.flag(key)) {
                                        if (this.flagOnce) {
                                            numLineOccurrences = 1;
                                        }
                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, cd.getClassOrPackageName(), numLineOccurrences, reference, lastLineNumber));
                                    }
                                    if (this.flagOnce) {
                                        return;
                                    }
                                    lastLineNumber = thisLineNumber;
                                    numLineOccurrences = 1;
                                } else {
                                    lastLineNumberSet = true;
                                    lastLineNumber = thisLineNumber;
                                    numLineOccurrences = 1;
                                }
                                ++j;
                            }
                            if (lastLineNumberSet && this.includeInResults(cd, key)) {
                                if (this.flag(key)) {
                                    if (this.flagOnce) {
                                        numLineOccurrences = 1;
                                    }
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, cd.getClassOrPackageName(), numLineOccurrences, reference, lastLineNumber));
                                }
                                if (this.flagOnce) {
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    protected boolean includeInResults(ClassOrPackageDetails cd, String filename) {
        return true;
    }
}

