/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BehaviorEJBInWebModule
extends DetectAttribute {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "BehaviorEJBInWebModule";
    protected static final String RULE_DESC = "appconversion.was2was.80.behavior.Web.EJBInWebModule";
    protected static final String[] tags = new String[]{"web-app"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml"};
    protected static final String versionAttribute = "version";
    protected static final String versionValue = "2\\.5|3\\.\\d";
    protected static final String metadataCompleteAttribute = "metadata-complete";
    protected static final String metadataCompleteValue = "(?i)true";
    protected static final String documentNamespace = "http://java\\.sun\\.com/xml/ns/javaee";
    protected static final String[] annotationNames = new String[]{"javax.ejb.Stateless", "javax.ejb.Stateful", "javax.ejb.Singleton", "javax.ejb.MessageDriven"};
    protected static final String location = "class";
    protected static final Pattern[] ejbJarFileName = new Pattern[]{Pattern.compile("(.*/)?WEB-INF/ejb-jar\\.xml$")};
    protected DetectAnnotation _ejbAnnotations = null;
    protected DetectFile _ejbJarXml = null;
    protected Set<String> webXmlWithMetadataCompleteTrue = new HashSet<String>();

    public BehaviorEJBInWebModule() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, null, versionAttribute, versionValue, null, false, null, documentNamespace);
    }

    public BehaviorEJBInWebModule(String ruleName, String desc, String[] tags, String[] fileNames, String namespace, String attributeName, String attributeValue, String attributeNamespace, boolean flagOnce, String validateNamespace, String docNamespace) {
        super(ruleName, desc, tags, fileNames, namespace, attributeName, attributeValue, attributeNamespace, flagOnce, validateNamespace, docNamespace);
        this._ejbAnnotations = new DetectAnnotation(RULE_NAME, RULE_DESC, annotationNames, null, null, null, null, null, false, location, null, null);
        this._ejbJarXml = new DetectFile(RULE_NAME, RULE_DESC, ejbJarFileName, false);
    }

    @Override
    public String[] getAnnotations() {
        return annotationNames;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._ejbAnnotations.clearResults();
        this._ejbJarXml.clearResults();
        this.webXmlWithMetadataCompleteTrue.clear();
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        boolean flag = true;
        Element ownerElement = ((Attr)node).getOwnerElement();
        if (this.containsAttribute(ownerElement.getAttributes(), metadataCompleteAttribute, metadataCompleteValue)) {
            this.webXmlWithMetadataCompleteTrue.add(fileName);
        }
        return flag;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._ejbAnnotations.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        Object nextResult;
        Iterator<DetailResult> it;
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> ejbJarAnnotations = this._ejbAnnotations.getResults(store);
        if (!parentResults.isEmpty()) {
            this._ejbJarXml.analyze(store, this.flagOnce);
            List<DetailResult> ejbJarFiles = this._ejbJarXml.getResults(store);
            it = parentResults.iterator();
            while (it.hasNext()) {
                nextResult = it.next();
                String webXmlFileName = ((DetailResult)nextResult).getFileName();
                if (this.doesEjbJarXmlExistInSameDirectory(webXmlFileName, ejbJarFiles)) continue;
                it.remove();
            }
        }
        finalResults.addAll(parentResults);
        if (!ejbJarAnnotations.isEmpty()) {
            HashSet<String> warFileNames = new HashSet<String>();
            for (String webXml : this.webXmlWithMetadataCompleteTrue) {
                int index = webXml.lastIndexOf(".war");
                if (index <= -1) continue;
                warFileNames.add(webXml.substring(0, index + 4));
            }
            it = ejbJarAnnotations.iterator();
            while (it.hasNext()) {
                nextResult = it.next();
                String classNameWithPath = ((DetailResult)nextResult).getFileName();
                if (!classNameWithPath.contains(".war/")) {
                    it.remove();
                    continue;
                }
                String warFileName = classNameWithPath.substring(0, classNameWithPath.lastIndexOf(".war") + 4);
                if (!warFileNames.contains(warFileName)) continue;
                it.remove();
            }
        }
        finalResults.addAll(ejbJarAnnotations);
        return finalResults;
    }

    protected boolean doesEjbJarXmlExistInSameDirectory(String webXmlFile, List<DetailResult> ejbJarFiles) {
        boolean flag = false;
        String compareRoot = webXmlFile.substring(0, webXmlFile.lastIndexOf("/web.xml"));
        for (DetailResult nextFileResult : ejbJarFiles) {
            String ejbJarFileName = nextFileResult.getFileName();
            String thisCompareRoot = ejbJarFileName.substring(0, ejbJarFileName.lastIndexOf("/ejb-jar.xml"));
            if (!compareRoot.equals(thisCompareRoot)) continue;
            return true;
        }
        return flag;
    }

    protected boolean containsAttribute(NamedNodeMap attributes, String attrName, String attrValue) {
        Node missingAttrNode;
        boolean flag = false;
        if (attributes != null && (missingAttrNode = XMLRuleUtil.getAttributeNode(attributes, this.attributeNamespace, attrName)) != null) {
            if (attrValue != null) {
                String value = missingAttrNode.getNodeValue();
                if (value != null && value.matches(attrValue)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return flag;
    }
}

