/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DetectDuplicateXmlType
extends DetectAnnotation {
    protected static final String RULE_NAME = "DetectDuplicateXmlType";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.was2liberty.DetectDuplicateXmlType";
    private static final String XML_TYPE_ANNOTATION = "javax.xml.bind.annotation.XmlType";
    private final Map<String, List<AnnotationOccurrence>> occurrencesMap = new HashMap<String, List<AnnotationOccurrence>>();

    public DetectDuplicateXmlType() {
        this(RULE_NAME, RULE_DESC, new String[]{XML_TYPE_ANNOTATION}, null, null, null, null, null, null, false, null, null);
    }

    public DetectDuplicateXmlType(String ruleName, String desc, String[] classNames, String fileNames, Object xmlFileType, String namespace, String attributeName, String attributeValue, String attributeNamespace, boolean flagOnce, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, classNames, null, null, null, null, null, flagOnce, null, null, null);
    }

    @Override
    public String[] getAnnotations() {
        return new String[]{XML_TYPE_ANNOTATION};
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        String effectiveName = this.getEffectiveXmlTypeName(data, ad);
        if (effectiveName != null && !effectiveName.isEmpty()) {
            String reference;
            List<AnnotationOccurrence> occList = this.occurrencesMap.get(effectiveName);
            if (occList == null) {
                occList = new ArrayList<AnnotationOccurrence>();
                this.occurrencesMap.put(effectiveName, occList);
            }
            if ((reference = ad.getReference()) == null) {
                reference = ad.getReferenceTypeDescription();
            }
            occList.add(new AnnotationOccurrence(key, data.getClassName(), reference, ad.getLineNumber()));
        }
        return true;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> results = super.getResults(store);
        Iterator<DetailResult> it = results.iterator();
        while (it.hasNext()) {
            DetailResult result = it.next();
            boolean duplicateFound = false;
            for (List<AnnotationOccurrence> occList : this.occurrencesMap.values()) {
                if (occList.size() > 1) {
                    for (AnnotationOccurrence occ : occList) {
                        if (!occ.key.equals(result.getFileName())) continue;
                        duplicateFound = true;
                        break;
                    }
                }
                if (duplicateFound) break;
            }
            if (duplicateFound) continue;
            it.remove();
        }
        return results;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.occurrencesMap.clear();
    }

    private String getEffectiveXmlTypeName(ClassDataStore data, AnnotationDetails ad) {
        for (AnnotationInfo ai : ad.getAnnotationInformation("java.lang.String")) {
            if (!"name".equals(ai.getAttributeName())) continue;
            String value = ai.getAttributeValue();
            if (value == null || value.trim().isEmpty()) {
                return this.getSimpleClassName(data.getClassName());
            }
            return value;
        }
        return this.getSimpleClassName(data.getClassName());
    }

    private String getSimpleClassName(String fullyQualifiedName) {
        int lastDot;
        if (fullyQualifiedName != null && (lastDot = fullyQualifiedName.lastIndexOf(46)) != -1 && lastDot < fullyQualifiedName.length() - 1) {
            return fullyQualifiedName.substring(lastDot + 1);
        }
        return fullyQualifiedName;
    }

    private static class AnnotationOccurrence {
        String key;
        String className;
        String reference;
        int lineNumber;

        AnnotationOccurrence(String key, String className, String reference, int lineNumber) {
            this.key = key;
            this.className = className;
            this.reference = reference;
            this.lineNumber = lineNumber;
        }

        public String toString() {
            return this.className;
        }
    }
}

