/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class DetectEntityManagerFactoryCreationStyle
extends DetectAttribute {
    protected static final String RULE_NAME = "DetectEntityManagerFactoryCreationStyle";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.entityManagerFactoryStyle";
    protected static final String XML_FILE = ".xml";
    protected static final String CLASS_ATTRIBUTE_VALUE_REG = "org\\.springframework\\.orm\\.jpa\\.(LocalEntityManagerFactoryBean|LocalContainerEntityManagerFactoryBean)";
    protected Map<String, HashSet<String>> mapOfSpringBeansToEntityManagerClassesUsed = new HashMap<String, HashSet<String>>();

    public DetectEntityManagerFactoryCreationStyle() {
        this(RULE_NAME, RULE_DESC, new String[]{"bean"}, new String[]{XML_FILE}, DetectRule.XMLFileType.SPRING, null, "class", CLASS_ATTRIBUTE_VALUE_REG, null, DetectRule.FlagOnce.NONE, null, null);
    }

    public DetectEntityManagerFactoryCreationStyle(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, String namespace, String attributeName, String attributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, tags, fileNames, xmlFileType, namespace, attributeName, attributeValue, attributeNamespace, flagOnceType, false, validateNamespace, documentNamespace);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.mapOfSpringBeansToEntityManagerClassesUsed.clear();
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        HashSet<String> classesUsed = this.mapOfSpringBeansToEntityManagerClassesUsed.get(fileName);
        if (classesUsed == null) {
            classesUsed = new HashSet();
            this.mapOfSpringBeansToEntityManagerClassesUsed.put(fileName, classesUsed);
        }
        classesUsed.add(node.getNodeValue().trim());
        return true;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> attributeResults = super.getResults(store);
        for (DetailResult result : attributeResults) {
            if (this.mapOfSpringBeansToEntityManagerClassesUsed.get(result.getFileName()).size() <= 1) continue;
            finalResults.add(result);
        }
        return finalResults;
    }
}

