/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class DetectJAXRPCPrevalidatedExtraValidationRule
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.FileRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectJAXRPCPrevalidatedExtraValidation";
    protected static final String RULE_DESC = "com.ibm.rrd.liberty.rules.impl.java.DetectJAXRPCPrevalidatedExtraValidation.rulename";
    protected static final String[] ibmWebservicesExtXmi = new String[]{"(.*/)?(META-INF|WEB-INF)/ibm-webservices-ext.xmi"};
    protected static final String[] ibmWebservicesBndXmi = new String[]{"(.*/)?(META-INF|WEB-INF)/ibm-webservices-bnd.xmi"};
    protected static final String[] ibmWebservicesClientExtXmi = new String[]{"(.*/)?(META-INF|WEB-INF)/ibm-webservicesclient-ext.xmi"};
    protected static final String[] ibmWebservicesClientBndXmi = new String[]{"(.*/)?(META-INF|WEB-INF)/ibm-webservicesclient-bnd.xmi"};
    protected static final String[] allXmiFiles = new String[]{ibmWebservicesExtXmi[0], ibmWebservicesBndXmi[0], ibmWebservicesClientExtXmi[0], ibmWebservicesClientBndXmi[0]};
    protected static final String[] ibmWebservicesExtTags = new String[]{"securityRequestReceiverServiceConfig", "securityResponseSenderServiceConfig", "securityRequestConsumerServiceConfig", "securityResponseGeneratorServiceConfig"};
    protected static final String[] ibmWebservicesBndTags = new String[]{"securityRequestReceiverBindingConfig", "securityResponseSenderBindingConfig", "securityRequestConsumerBindingConfig", "securityResponseGeneratorBindingConfig"};
    protected static final String[] ibmWebservicesClientExtTags = new String[]{"securityRequestSenderServiceConfig", "securityResponseReceiverServiceConfig", "securityRequestGeneratorServiceConfig", "securityResponseConsumerServiceConfig"};
    protected static final String[] ibmWebservicesClientBndTags = new String[]{"securityRequestSenderBindingConfig", "securityResponseReceiverBindingConfig", "securityRequestGeneratorBindingConfig", "securityResponseConsumerBindingConfig"};
    protected static final String[] invalidClassesForByteCodeModifier = new String[]{"javax.xml.rpc.Call", "javax.xml.rpc.handler.HandlerRegistry", "javax.xml.rpc.encoding.TypeMappingRegistry", "com.ibm.ws.webservices.multiprotocol.ServiceContext"};
    protected static final String[] locatorExtendClassNames = new String[]{"com.ibm.ws.webservices.multiprotocol.AgnosticService"};
    protected DetectElement _detectWebservicesExtXmiElement = null;
    protected DetectElement _detectWebservicesBndXmiElement = null;
    protected DetectElement _detectWebservicesClientExtXmiElement = null;
    protected DetectElement _detectWebservicesClientBndXmiElement = null;
    protected DetectClass stubDetectClass = null;
    protected DetectClass invalidDetectClass = null;
    protected DetectClass AgnosticServiceDetectExtendClass = null;
    protected DetectClass locatorDetectImplementClass = null;

    public DetectJAXRPCPrevalidatedExtraValidationRule() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public DetectJAXRPCPrevalidatedExtraValidationRule(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
        this._detectWebservicesExtXmiElement = new DetectElement(ruleName, desc, ibmWebservicesExtTags, ibmWebservicesExtXmi, null, null, flagOnce, null, null, null, false);
        this._detectWebservicesBndXmiElement = new DetectElement(ruleName, desc, ibmWebservicesBndTags, ibmWebservicesBndXmi, null, null, flagOnce, null, null, null, false);
        this._detectWebservicesClientExtXmiElement = new DetectElement(ruleName, desc, ibmWebservicesClientExtTags, ibmWebservicesClientExtXmi, null, null, flagOnce, null, null, null, false);
        this._detectWebservicesClientBndXmiElement = new DetectElement(ruleName, desc, ibmWebservicesClientBndTags, ibmWebservicesClientBndXmi, null, null, flagOnce, null, null, null, false);
        this.AgnosticServiceDetectExtendClass = new DetectClass(ruleName, desc, null, false, false, false, locatorExtendClassNames, null, null, null, null, null);
        this.invalidDetectClass = new DetectClass(ruleName, desc, invalidClassesForByteCodeModifier, false, false, false, null, null, null, null, null, null);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectWebservicesExtXmiElement.clearResults();
        this._detectWebservicesBndXmiElement.clearResults();
        this._detectWebservicesClientExtXmiElement.clearResults();
        this._detectWebservicesClientBndXmiElement.clearResults();
        this.AgnosticServiceDetectExtendClass.clearResults();
        this.invalidDetectClass.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectWebservicesExtXmiElement.analyze(store, detectOnce);
        this._detectWebservicesBndXmiElement.analyze(store, detectOnce);
        this._detectWebservicesClientExtXmiElement.analyze(store, detectOnce);
        this._detectWebservicesClientBndXmiElement.analyze(store, detectOnce);
        this.AgnosticServiceDetectExtendClass.analyze(store, detectOnce);
        this.invalidDetectClass.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        finalResults.addAll(this._detectWebservicesExtXmiElement.getResults(store));
        finalResults.addAll(this._detectWebservicesBndXmiElement.getResults(store));
        finalResults.addAll(this._detectWebservicesClientExtXmiElement.getResults(store));
        finalResults.addAll(this._detectWebservicesClientBndXmiElement.getResults(store));
        finalResults.addAll(this.getInvalidClassesUsedInNonServiceLocatorClasses(this.AgnosticServiceDetectExtendClass.getResults(store), this.invalidDetectClass.getResults(store)));
        return finalResults;
    }

    List<DetailResult> getInvalidClassesUsedInNonServiceLocatorClasses(List<DetailResult> AgnosticServiceClasses, List<DetailResult> invalidClasses) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        for (DetailResult invalidClass : invalidClasses) {
            if (this.isServiceLocator(invalidClass, AgnosticServiceClasses)) continue;
            finalResults.add(invalidClass);
        }
        return finalResults;
    }

    private boolean isServiceLocator(DetailResult invalidClass, List<DetailResult> AgnosticServiceClasses) {
        for (DetailResult agServ : AgnosticServiceClasses) {
            if (!invalidClass.getFileName().equals(agServ.getFileName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allXmiFiles;
    }
}

