/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.MethodDetails;
import com.ibm.ws.report.binary.asm.utilities.MethodInfo;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetectJAXRSDateCalTime
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectJAXRSDateCalTime";
    protected static final String RULE_DESC = "appconversion.javaee8.jaxrs.DetectJAXRSDateCalTimeNoQuickfix";
    public static final String DATE_CALENDAR_REGEX = ".*java\\.util\\.(Date|Calendar).*";
    public static final String LOCAL_DATE_INSTANCE_REGEX = ".*java\\.time\\.(LocalDate|Instant).*";
    protected static final String CONSUMES_ANNO = "javax.ws.rs.Consumes";
    protected static final String PRODUCES_ANNO = "javax.ws.rs.Produces";
    protected static final String[] classNames = new String[]{"javax.ws.rs.Consumes", "javax.ws.rs.Produces", "javax.ws.rs.DELETE", "javax.ws.rs.GET", "javax.ws.rs.HEAD", "javax.ws.rs.OPTIONS", "javax.ws.rs.POST", "javax.ws.rs.PUT"};
    public static final String JsonAnnoValueRegex = ".*(?i)(json|wildcard|\\*).*";
    protected static final String[] packageNamesV1 = new String[]{"org.codehaus.jackson.jaxrs"};
    protected static final String[] packageNamesV2 = new String[]{"com.fasterxml.jackson.jaxrs.json", "com.fasterxml.jackson.jaxrs.json.annotation"};
    protected DetectPackage _jacksonPackagedV1 = null;
    protected DetectPackage _jacksonPackagedV2 = null;
    Map<String, ArchiveResultDetails> flagOncePerArchive = new HashMap<String, ArchiveResultDetails>();
    protected static final String METHOD_TYPE = "Method ";
    protected static final String CLASS_TYPE = "Class ";
    public static final String JaxrsMethodAnnoRegex = "javax\\.ws\\.rs\\.(GET|POST|PUT|DELETE|OPTIONS|HEAD)";

    public DetectJAXRSDateCalTime() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, null, null, null);
    }

    public DetectJAXRSDateCalTime(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._jacksonPackagedV1 = new DetectPackage(ruleName, desc, packageNamesV1, true, true, null, null, true);
        this._jacksonPackagedV2 = new DetectPackage(ruleName, desc, packageNamesV2, true, true, null, null, true);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._jacksonPackagedV1.clearResults();
        this._jacksonPackagedV2.clearResults();
        this.flagOncePerArchive.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._jacksonPackagedV1.analyze(store, detectOnce);
        this._jacksonPackagedV2.analyze(store, detectOnce);
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"*"};
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        String name2 = ad.getName();
        if (name2.equals(CONSUMES_ANNO) || name2.equals(PRODUCES_ANNO)) {
            String topArchiveName = ReportUtility.getFirstArchiveName(key);
            ArchiveResultDetails archiveResults = null;
            if (!this.flagOncePerArchive.containsKey(topArchiveName)) {
                archiveResults = new ArchiveResultDetails();
                this.flagOncePerArchive.put(topArchiveName, archiveResults);
            } else {
                archiveResults = this.flagOncePerArchive.get(topArchiveName);
            }
            List<AnnotationInfo> ais = ad.getAnnotationInformation();
            for (AnnotationInfo ai : ais) {
                int n;
                String reference = ai.getReference();
                if (!ai.getAttributeValue().matches(JsonAnnoValueRegex)) continue;
                if (archiveResults.flagOnceResult == null) {
                    archiveResults.flagOnceResult = new DetailResult(this.ruleName, key, this.ruleDescription, name2, 1, reference, ad.getLineNumber());
                }
                if (reference.startsWith(METHOD_TYPE)) {
                    String methodSignature = ad.getMethodSignature();
                    MethodDetails md = data.getImplementedMethodDetail(methodSignature);
                    if (md == null) continue;
                    Set<MethodInfo> mis = md.getMethodInfo("*");
                    for (MethodInfo mi : mis) {
                        if (name2.equals(PRODUCES_ANNO)) {
                            String returnType = mi.getReturnType();
                            if (!returnType.matches(DATE_CALENDAR_REGEX) && !returnType.matches(LOCAL_DATE_INSTANCE_REGEX)) continue;
                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, name2, 1, methodSignature, ad.getLineNumber()));
                            ++archiveResults.resultCount;
                            continue;
                        }
                        if (!name2.equals(CONSUMES_ANNO)) continue;
                        String[] stringArray = mi.getArgumentTypes();
                        n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String param = stringArray[n2];
                            if (param.matches(DATE_CALENDAR_REGEX) || param.matches(LOCAL_DATE_INSTANCE_REGEX)) {
                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, name2, 1, methodSignature, ad.getLineNumber()));
                                ++archiveResults.resultCount;
                            }
                            ++n2;
                        }
                    }
                    continue;
                }
                if (!reference.startsWith(CLASS_TYPE)) continue;
                List<MethodDetails> mds = data.getImplementedMethodDetails();
                for (MethodDetails md : mds) {
                    if (!this.inheritsJaxrsAnno(data, md)) continue;
                    Set<MethodInfo> mis = md.getMethodInfo("*");
                    for (MethodInfo mi : mis) {
                        if (name2.equals(PRODUCES_ANNO)) {
                            String returnType = mi.getReturnType();
                            if (!returnType.matches(DATE_CALENDAR_REGEX) && !returnType.matches(LOCAL_DATE_INSTANCE_REGEX)) continue;
                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, name2, 1, md.getSignature(), ad.getLineNumber()));
                            ++archiveResults.resultCount;
                            continue;
                        }
                        if (!name2.equals(CONSUMES_ANNO)) continue;
                        String[] stringArray = mi.getArgumentTypes();
                        int n3 = stringArray.length;
                        n = 0;
                        while (n < n3) {
                            String param = stringArray[n];
                            if (param.matches(DATE_CALENDAR_REGEX) || param.matches(LOCAL_DATE_INSTANCE_REGEX)) {
                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, name2, 1, md.getSignature(), ad.getLineNumber()));
                                ++archiveResults.resultCount;
                            }
                            ++n;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean inheritsJaxrsAnno(ClassDataStore data, MethodDetails md) {
        boolean hasJaxrsMethodAnno = false;
        boolean hasConsumesOrProducesAnno = false;
        String signature = md.getSignature();
        List<AnnotationDetails> ads = data.getAnnotationDetailsByMethodSignature(signature);
        for (AnnotationDetails ad : ads) {
            String name2 = ad.getName();
            if (name2.equals(CONSUMES_ANNO) || name2.equals(PRODUCES_ANNO)) {
                hasConsumesOrProducesAnno = true;
                continue;
            }
            if (!name2.matches(JaxrsMethodAnnoRegex)) continue;
            hasJaxrsMethodAnno = true;
        }
        return hasJaxrsMethodAnno && !hasConsumesOrProducesAnno;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> finalResults = new ArrayList<DetailResult>();
        if (this._jacksonPackagedV1.getResults(store).isEmpty() && this._jacksonPackagedV2.getResults(store).isEmpty()) {
            finalResults = super.getResults(store);
            for (Map.Entry<String, ArchiveResultDetails> entry : this.flagOncePerArchive.entrySet()) {
                ArchiveResultDetails archiveResults = entry.getValue();
                if (archiveResults.resultCount != 0 || archiveResults.flagOnceResult == null) continue;
                finalResults.add(archiveResults.flagOnceResult);
            }
        }
        return finalResults;
    }

    public class ArchiveResultDetails {
        int resultCount = 0;
        DetailResult flagOnceResult = null;
    }
}

