/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectTLD
extends DetectElement {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectTLD";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.tld.validation.checkSetters";
    protected static final String[] tldFiles = new String[]{".*\\.tld"};
    protected static final String[] tagTag = new String[]{"tag"};
    protected static final String[] attributeTag = new String[]{"attribute"};
    protected static final String NAME = "name";
    protected static final String TAG_CLASS = "tag-class";
    protected static final String TAGCLASS = "tagclass";
    protected static final String namespace = "*";
    private Map<String, List<TLDAttribute>> tldFileToAttributes = new HashMap<String, List<TLDAttribute>>();
    private Map<String, List<String>> classesToSettersGetters = new HashMap<String, List<String>>();

    public DetectTLD() {
        this(RULE_NAME, RULE_DESC, attributeTag, tldFiles, null, namespace, DetectRule.FlagOnce.NONE, null, null, null, false, null, null, null, false, tagTag, false);
    }

    public DetectTLD(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnceType, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.tldFileToAttributes.clear();
        this.classesToSettersGetters.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        Set<String> keys = store.getClassDataStoreKeys();
        for (String key : keys) {
            ClassDataStore data = store.getClassDataStore(key);
            ArrayList<String> classSettersGetters = new ArrayList<String>();
            classSettersGetters.addAll(data.getImplementedSetterMethods());
            classSettersGetters.addAll(data.getImplementedGetterMethods());
            this.classesToSettersGetters.put(data.getClassName(), classSettersGetters);
        }
    }

    @Override
    protected boolean includeInResults(Node result, String key, XMLResource xmlResource) {
        Element attributeNameElement = XMLRuleUtil.getFirstChildElement((Element)result, namespace, NAME);
        if (attributeNameElement != null) {
            String attributeName = XMLRuleUtil.getTextWithoutWhitespace(attributeNameElement);
            int attributeNameLine = xmlResource.getNodeLineNumber(attributeNameElement);
            Element parent = (Element)result.getParentNode();
            String tagClass = XMLRuleUtil.getFirstChildElementValue(parent, namespace, TAG_CLASS);
            if (tagClass == null) {
                tagClass = XMLRuleUtil.getFirstChildElementValue(parent, namespace, TAGCLASS);
            }
            TLDAttribute attribute = new TLDAttribute(attributeName, attributeNameLine, tagClass);
            this.addTLDAttribute(key, attribute);
        }
        return false;
    }

    private void addTLDAttribute(String tldFileName, TLDAttribute tldAttribute) {
        List<TLDAttribute> existingAttributes = this.tldFileToAttributes.get(tldFileName);
        if (existingAttributes == null) {
            existingAttributes = new ArrayList<TLDAttribute>();
            this.tldFileToAttributes.put(tldFileName, existingAttributes);
        }
        existingAttributes.add(tldAttribute);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        for (Map.Entry<String, List<TLDAttribute>> tldFileEntry : this.tldFileToAttributes.entrySet()) {
            String tldFileName = tldFileEntry.getKey();
            List<TLDAttribute> tldAttrs = tldFileEntry.getValue();
            ArrayList<String> listOfMissingTagClassValues = new ArrayList<String>();
            for (TLDAttribute attribute : tldAttrs) {
                String attrTagClass = attribute.getTagClass();
                if (attrTagClass != null && this.classesToSettersGetters.containsKey(attrTagClass)) {
                    String methodError = this.getGetterSetterError(this.classesToSettersGetters.get(attrTagClass), attribute.getName());
                    if (methodError == null) continue;
                    this.detailResults.add(new DetailResult(this.ruleName, tldFileName, this.ruleDescription, methodError, 1, null, attribute.getLineNumber()));
                    continue;
                }
                if (listOfMissingTagClassValues.contains(attrTagClass)) continue;
                listOfMissingTagClassValues.add(attrTagClass);
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("Report_Tagclass_Not_Found"), this.getRuleDescription(), attrTagClass, tldFileName));
            }
        }
        return this.detailResults;
    }

    private String getGetterSetterError(List<String> allMethodDeclarations, String attrName) {
        String getter = null;
        String getterMisMatch = null;
        String setter = null;
        for (String method : allMethodDeclarations) {
            String expectedName;
            if (getter != null && setter != null) break;
            if (method.startsWith("get")) {
                if (getter != null || method.length() <= 3) continue;
                expectedName = method.substring(3);
                if ((expectedName = Introspector.decapitalize(expectedName)).equals(attrName)) {
                    getter = method;
                    continue;
                }
                if (!expectedName.equalsIgnoreCase(attrName)) continue;
                getterMisMatch = method;
                continue;
            }
            if (!method.startsWith("set") || setter != null || method.length() <= 3) continue;
            expectedName = method.substring(3);
            if (!(expectedName = Introspector.decapitalize(expectedName)).equals(attrName)) continue;
            setter = method;
        }
        if (setter == null) {
            return Messages.getFormattedMessage(Messages.getString("Report_Tagclass_Missing_Setter"), "set" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1), attrName);
        }
        if (getterMisMatch != null && getter == null) {
            return Messages.getFormattedMessage(Messages.getString("Report_Tagclass_Bad_Getter"), getterMisMatch, "get" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1), attrName);
        }
        return null;
    }

    private class TLDAttribute {
        private int lineNumber;
        private String name;
        private String tagClass;

        public TLDAttribute(String name2, int lineNumber, String tagClass) {
            this.lineNumber = lineNumber;
            this.name = name2;
            this.tagClass = tagClass;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getName() {
            return this.name;
        }

        public String getTagClass() {
            return this.tagClass;
        }
    }
}

