/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DetectTomcatMissingSecurityRole
extends DetectElement {
    protected static final String RULE_NAME = "DetectTomcatMissingSecurityRole";
    protected static final String RULE_DESC = "appconversion.tomcat.rule.xml.missing.security.role";
    protected static final String ROLE_NAME_ELEMENT = "role-name";
    protected static final String AUTH_CONSTRAINT_ELEMENT = "auth-constraint";
    protected static final String WEB_APP_ELEMENT = "web-app";
    protected static final String SECURITY_ROLE_ELEMENT = "security-role";
    protected static final String[] _fileNames = new String[]{"WEB-INF/web.xml"};

    public DetectTomcatMissingSecurityRole() {
        super(RULE_NAME, Messages.getRuleDescription(RULE_DESC), new String[]{ROLE_NAME_ELEMENT}, _fileNames, null, null, false, null, null, null, false, null, null, null, false, new String[]{AUTH_CONSTRAINT_ELEMENT}, false);
    }

    @Override
    protected boolean includeInResults(Node node, String key, XMLResource resource) {
        Node webAppNode = this.getWebAppNode(node);
        return !this.isRoleDefined(webAppNode, XMLRuleUtil.getTextWithoutWhitespace(node));
    }

    private Node getWebAppNode(Node node) {
        Node parentNode = node;
        while (parentNode != null) {
            if (WEB_APP_ELEMENT.equals(parentNode.getLocalName())) break;
            parentNode = parentNode.getParentNode();
        }
        return parentNode;
    }

    private boolean isRoleDefined(Node webAppNode, String roleName) {
        if (webAppNode == null || roleName == null) {
            return false;
        }
        NodeList children = webAppNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node webAppChild = children.item(i);
            if (SECURITY_ROLE_ELEMENT.equals(webAppChild.getLocalName())) {
                NodeList securityRoleChildren = webAppChild.getChildNodes();
                int j = 0;
                while (j < securityRoleChildren.getLength()) {
                    Node securityRoleChild = securityRoleChildren.item(j);
                    if (ROLE_NAME_ELEMENT.equals(securityRoleChild.getLocalName()) && roleName.equals(XMLRuleUtil.getTextWithoutWhitespace(securityRoleChild))) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

