/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectManifestAttribute;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class DetectWAB
extends DetectManifestAttribute {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.ManifestRule, RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectWAB";
    protected static final String RULE_DESC = "com.ibm.rrd.liberty.rules.impl.DetectWAB.rulename";
    protected static final String WEB_CONTEXTPATH = "Web-ContextPath";
    protected static final String[] packages = new String[]{"javax.servlet*"};
    protected static final String[] tags = new String[]{"web-app"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml"};
    protected DetectPackage _servletPackages = null;
    protected DetectElement _webApp = null;

    public DetectWAB() {
        this(RULE_NAME, RULE_DESC, WEB_CONTEXTPATH, ".*", DetectRule.FlagOnce.NONE);
    }

    public DetectWAB(String ruleName, String desc, String name2, String value, DetectRule.FlagOnce flagOnceType) {
        super(ruleName, desc, name2, value, flagOnceType);
        this._servletPackages = new DetectPackage(ruleName, desc, packages, false, false, null, null, this.flagOnce);
        this._webApp = new DetectElement(RULE_NAME, RULE_DESC, tags, fileNames, null, null, false, null, null, null, false, null, null, null, false, null, false);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._servletPackages.clearResults();
        this._webApp.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._servletPackages.analyze(store, detectOnce);
        this._webApp.analyze(store, detectOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResultsList = new ArrayList<DetailResult>();
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> javaServletResults = this._servletPackages.getResults(store);
        List<DetailResult> xmlServletResults = this._webApp.getResults(store);
        if (!(parentResults.isEmpty() || javaServletResults.isEmpty() && xmlServletResults.isEmpty())) {
            finalResultsList.addAll(parentResults);
        }
        return finalResultsList;
    }
}

