/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.technology.DetailResult;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DetectWeblogicJAXRPCWebservices
extends DetectFile {
    protected static final String RULE_NAME = "DetectWeblogicJAXRPCWebservices";
    protected static final String RULE_DESC = "appconversion.weblogic.xml.descriptors.jaxrpc";
    protected static final String WEBSERVICESXML = "webservices.xml";
    protected static final Pattern[] webServicesXml = new Pattern[]{Pattern.compile(".*/webservices\\.xml")};
    protected static final Pattern[] web_ServicesXml = new Pattern[]{Pattern.compile(".*/web-services\\.xml")};
    protected static final String webLogicWebServicesXml = "weblogic-webservices\\.xml";
    protected DetectFile _web_ServicesRule = new DetectFile("DetectWeblogicJAXRPCWebservices", "appconversion.weblogic.xml.descriptors.jaxrpc", web_ServicesXml, false);

    public DetectWeblogicJAXRPCWebservices() {
        this(RULE_NAME, RULE_DESC, webServicesXml, false);
    }

    public DetectWeblogicJAXRPCWebservices(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._web_ServicesRule.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Pattern pattern = this.files[0];
        Set<String> matches = null;
        matches = store.getMatchingFileNames(pattern);
        for (String key : matches) {
            String webLogicWebServicesKey = String.valueOf(key.substring(0, key.length() - WEBSERVICESXML.length())) + webLogicWebServicesXml;
            Pattern webLogicWebServicesPattern = Pattern.compile(webLogicWebServicesKey);
            Set<String> webLogicMatches = store.getMatchingFileNames(webLogicWebServicesPattern);
            if (webLogicMatches.isEmpty()) continue;
            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(pattern.pattern()) + ", " + webLogicWebServicesXml));
        }
        this._web_ServicesRule.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> finalResults = super.getResults(store);
        finalResults.addAll(this._web_ServicesRule.getResults(store));
        return finalResults;
    }
}

