/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InterfaceBothLocalAndRemote
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "InterfaceBothLocalAndRemote";
    protected static final String RULE_DESC = "appconversion.competitive.rule.InterfaceBothLocalAndRemote.rulename";
    protected static final String ANNOTATION_LOCAL = "javax.ejb.Local";
    protected static final String ANNOTATION_REMOTE = "javax.ejb.Remote";
    protected static final String BUSINESS_LOCAL = "business-local";
    protected static final String BUSINESS_REMOTE = "business-remote";
    protected static final String ANNOTATION_DETAILS_STRING_TYPE = "java.lang.String";
    protected static final String[] annotationRemote = new String[]{"javax.ejb.Remote"};
    protected static final String[] elementRemote = new String[]{"business-remote"};
    protected static final String[] ejbJarFileName = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml"};
    protected DetectAnnotation _ejbAnnotation = new DetectAnnotation("InterfaceBothLocalAndRemote", "appconversion.competitive.rule.InterfaceBothLocalAndRemote.rulename", annotationRemote, null, null, null, null, null, false, "class", null, null){

        @Override
        protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
            Set<String> annotations = data.getClassAnnotations();
            if (annotations.contains(InterfaceBothLocalAndRemote.ANNOTATION_LOCAL)) {
                List<AnnotationDetails> annotationDetailsLocal = data.getAnnotationDetails(InterfaceBothLocalAndRemote.ANNOTATION_LOCAL);
                Set<AnnotationInfo> aiList = ad.getAnnotationInformation(InterfaceBothLocalAndRemote.ANNOTATION_DETAILS_STRING_TYPE);
                for (AnnotationDetails adslocal : annotationDetailsLocal) {
                    for (AnnotationInfo ai : aiList) {
                        if (!ai.getAttributeName().equals("value") || !adslocal.containsAttributeValue("value", ai.getAttributeValue())) continue;
                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, adslocal.getName(), 1, adslocal.getReference(), adslocal.getLineNumber()));
                        return true;
                    }
                }
            }
            return false;
        }
    };
    protected DetectElement _ejbJarXmlElement = new DetectElement("InterfaceBothLocalAndRemote", "appconversion.competitive.rule.InterfaceBothLocalAndRemote.rulename", elementRemote, ejbJarFileName, null, null, false, null, null, null, false){

        @Override
        protected boolean includeInResults(Node result, String key, XMLResource resource) {
            Element cfr_ignored_0 = (Element)result.getParentNode();
            List<Element> elList = XMLRuleUtil.getChildElements((Element)result.getParentNode(), result.getNamespaceURI(), InterfaceBothLocalAndRemote.BUSINESS_LOCAL);
            String resValue = XMLRuleUtil.getTextWithoutWhitespace(result);
            for (Element localEl : elList) {
                String localValue = XMLRuleUtil.getTextWithoutWhitespace(localEl);
                if (resValue == null || localValue == null || !resValue.equals(localValue)) continue;
                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, localEl.getLocalName(), 1, null, resource.getNodeLineNumber(localEl)));
                return true;
            }
            return false;
        }
    };

    public InterfaceBothLocalAndRemote() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public InterfaceBothLocalAndRemote(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
    }

    @Override
    public String[] getFileNames() {
        return ejbJarFileName;
    }

    @Override
    public String[] getAnnotations() {
        return new String[]{ANNOTATION_LOCAL, ANNOTATION_REMOTE};
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._ejbJarXmlElement.clearResults();
        this._ejbAnnotation.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._ejbJarXmlElement.analyze(store, detectOnce);
        this._ejbAnnotation.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this.detailResults.addAll(this._ejbJarXmlElement.getResults(store));
        this.detailResults.addAll(this._ejbAnnotation.getResults(store));
        return this.detailResults;
    }
}

