/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JpaCacheProperties
extends DetectElement {
    protected static final String RULE_NAME = "JpaCacheProperties";
    protected static final String RULE_DESC = "appconversion.javaee7.jpa.JpaCacheBehavior";
    protected static final String[] tags = new String[]{"persistence-unit"};
    protected static final String[] fileNames = new String[]{"META-INF/persistence.xml"};
    protected static final String SHARED_CACHE_MODE_ELEMENT = "shared-cache-mode";
    protected static final String SHARED_CACHE_MODE_VALUE_UNSPECIFIED = "UNSPECIFIED";

    public JpaCacheProperties() {
        super(RULE_NAME, RULE_DESC, tags, fileNames, null, null, false, null, null, null, false);
        this.setRecipes(new String[]{"org.openrewrite.java.migrate.JpaCacheProperties"});
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getDocumentKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                XMLResource resource = store.getDocument(key);
                Document doc = resource.getDocument();
                List<Node> results = XMLRuleUtil.getTagDeclarations(doc, key, this.xmlFiles, this.namespace, tags);
                if (results.isEmpty()) continue;
                for (Node node : results) {
                    SharedDataHolder sdh = this.extractData((Element)node);
                    if (!sdh.shouldFlag()) continue;
                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, node.getLocalName(), 1, null, resource.getNodeLineNumber(node)));
                }
            }
        }
    }

    private SharedDataHolder extractData(Element puNode) {
        SharedDataHolder sdh = new SharedDataHolder();
        sdh.sharedCacheModeElement = this.getSharedCacheModeNode(puNode);
        this.getDataCacheProps(puNode, sdh);
        sdh.sharedCacheModeElementUnspecified = this.isSharedCacheModeElementUnspecified(sdh.sharedCacheModeElement);
        sdh.sharedCacheModePropertyUnspecified = this.isSharedCacheModePropertyUnspecified(sdh.sharedCacheModeProperty);
        return sdh;
    }

    private Element getSharedCacheModeNode(Node puNode) {
        return XMLRuleUtil.getFirstChildElement((Element)puNode, "*", SHARED_CACHE_MODE_ELEMENT);
    }

    private boolean isSharedCacheModeElementUnspecified(Node puNode) {
        if (puNode != null) {
            String sharedCacheModeValue = XMLRuleUtil.getTextWithoutWhitespace(puNode);
            return SHARED_CACHE_MODE_VALUE_UNSPECIFIED.equals(sharedCacheModeValue);
        }
        return false;
    }

    private boolean isSharedCacheModePropertyUnspecified(Element prop) {
        if (prop != null) {
            String value = prop.getAttribute("value");
            return SHARED_CACHE_MODE_VALUE_UNSPECIFIED.equals(value);
        }
        return false;
    }

    private void getDataCacheProps(Element puNode, SharedDataHolder sdh) {
        List<Element> properties = XMLRuleUtil.getChildElements(puNode, "*", "property");
        for (Element prop : properties) {
            String name2 = prop.getAttribute("name");
            if (name2 == null) continue;
            if ("openjpa.DataCache".equals(name2)) {
                sdh.openJPACacheProperty = prop;
                continue;
            }
            if ("javax.persistence.sharedCache.mode".equals(name2)) {
                sdh.sharedCacheModeProperty = prop;
                continue;
            }
            if (!"eclipselink.cache.shared.default".equals(name2)) continue;
            sdh.eclipselinkCacheProperty = prop;
        }
    }

    private class SharedDataHolder {
        boolean sharedCacheModePropertyUnspecified;
        boolean sharedCacheModeElementUnspecified;
        Element sharedCacheModeElement;
        Element sharedCacheModeProperty;
        Element openJPACacheProperty;
        Element eclipselinkCacheProperty;

        private SharedDataHolder() {
        }

        public boolean shouldFlag() {
            return this.openJPACacheProperty != null || this.sharedCacheModeElement != null && this.sharedCacheModeElementUnspecified || this.sharedCacheModeProperty != null && this.sharedCacheModePropertyUnspecified || this.sharedCacheModeElement != null && this.sharedCacheModeProperty != null || this.openJPACacheProperty == null && this.sharedCacheModeElement == null && this.sharedCacheModeProperty == null && this.eclipselinkCacheProperty == null;
        }
    }
}

