/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProxyNonPublic
extends DetectMethod {
    protected static final String RULE_NAME = "ProxyNonPublic";
    protected static final String RULE_DESC = "appconversion.jre.180.ProxyNonPublic";
    protected static final String[] _allMethodNames = new String[]{"newInstance", "setAccessible", "getProxyClass"};
    protected static final String[] _methodNameConstructor = new String[]{_allMethodNames[0]};
    protected static final String[] _ownerConstructor = new String[]{"java.lang.reflect.Constructor"};
    protected static final String _argConstructor = "java.lang.Object...";
    protected static List<ArgumentDetail> argDetailConstructor = new ArrayList<ArgumentDetail>();
    protected static final String[] _methodNameSetAccessible = new String[]{_allMethodNames[1]};
    protected static final String[] _ownerSetAccessible = new String[]{"java.lang.reflect.Constructor"};
    protected static final String _argSetAccessible = "boolean";
    protected static List<ArgumentDetail> argDetailSetAccessible = new ArrayList<ArgumentDetail>();
    protected static final String[] _methodNameGetProxyClass = new String[]{_allMethodNames[2]};
    protected static final String[] _ownerGetProxyClass = new String[]{"java.lang.reflect.Proxy"};
    protected static final String _argGetProxyClass = "java.lang.ClassLoader, java.lang.Class...";
    protected static List<ArgumentDetail> argDetailGetProxyClass = new ArrayList<ArgumentDetail>();
    protected DetectMethod _setAccessibleRule = new DetectMethod("ProxyNonPublic", Messages.getRuleDescription("appconversion.jre.180.ProxyNonPublic"), _methodNameSetAccessible, _ownerSetAccessible, null, "boolean", null, false, argDetailSetAccessible, null, null);
    protected DetectMethod _getProxyClassRule = new DetectMethod("ProxyNonPublic", Messages.getRuleDescription("appconversion.jre.180.ProxyNonPublic"), _methodNameGetProxyClass, _ownerGetProxyClass, null, "java.lang.ClassLoader, java.lang.Class...", null, false, argDetailGetProxyClass, null, null);

    static {
        argDetailConstructor.add(new ArgumentDetail(0, true, false, null, null, "java.lang.reflect.InvocationHandler"));
        argDetailSetAccessible.add(new ArgumentDetail(0, true, false, "1", "1", null));
        argDetailGetProxyClass.add(new ArgumentDetail(1, false, true, null, null, null));
    }

    public ProxyNonPublic() {
        this(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNameConstructor, _ownerConstructor, null, _argConstructor, null, false, argDetailConstructor, null, null);
    }

    public ProxyNonPublic(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, boolean flagOnce, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions) {
        super(ruleName, desc, methodNames, owners, returnType, args, excludePackageNames, flagOnce, argDetails, flagCatchExceptions, flagUnhandledExceptions);
    }

    @Override
    public String[] getMethodNames() {
        return _allMethodNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._setAccessibleRule.clearResults();
        this._getProxyClassRule.clearResults();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResults = super.getResults(store);
        if (!parentResults.isEmpty()) {
            List<DetailResult> getProxyClassResults;
            List<DetailResult> setAccessibleResults = this._setAccessibleRule.getResults(store);
            if (!setAccessibleResults.isEmpty()) {
                Iterator<DetailResult> it = parentResults.iterator();
                while (it.hasNext()) {
                    DetailResult nextResult = it.next();
                    if (!this.doesCallToMethodExist(nextResult, setAccessibleResults)) continue;
                    it.remove();
                }
            }
            if (!(getProxyClassResults = this._getProxyClassRule.getResults(store)).isEmpty()) {
                Iterator<DetailResult> it = parentResults.iterator();
                while (it.hasNext()) {
                    DetailResult nextResult = it.next();
                    if (!this.doesCallToMethodExist(nextResult, getProxyClassResults)) continue;
                    it.remove();
                }
            }
        }
        return parentResults;
    }

    protected boolean doesCallToMethodExist(DetailResult methodResult, List<DetailResult> setAccessibleResults) {
        boolean flag = false;
        for (DetailResult compareResult : setAccessibleResults) {
            if (!compareResult.matches(methodResult) || methodResult.getLineNumber() < compareResult.getLineNumber()) continue;
            return true;
        }
        return flag;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._setAccessibleRule.analyze(store, detectOnce);
        this._getProxyClassRule.analyze(store, detectOnce);
    }
}

