/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class URLPatternMapping
extends DetectElement {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "URLPatternClash";
    protected static final String RULE_DESC = "appconversion.javaee7.servlet.URLPatternMapping";
    protected static final String[] tags = new String[]{"servlet-mapping"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml", "META-INF/web-fragment.xml"};
    protected static final String namespace = "*";
    protected static final String value = ".+";
    protected static final String[] annoClassNames = new String[]{"javax.servlet.annotation.WebServlet"};
    protected static final String attrType = "java.lang.String";
    protected static final String attrName = "name|value|urlPatterns";
    protected static final String[] attrValues = new String[]{".+"};
    Map<String, List<ServletURLInfo>> projectToServletInfo = new HashMap<String, List<ServletURLInfo>>();
    protected DetectAnnotation _detectWebServlet = new DetectAnnotation("URLPatternClash", "appconversion.javaee7.servlet.URLPatternMapping", annoClassNames, "name|value|urlPatterns", null, null, null, null, false, "class", null, null){

        @Override
        protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
            int index = key.lastIndexOf(".war");
            if (index > -1) {
                String warFileName = key.substring(0, index + 4);
                List<Object> servletInfos = null;
                if (URLPatternMapping.this.projectToServletInfo.containsKey(warFileName)) {
                    servletInfos = URLPatternMapping.this.projectToServletInfo.get(warFileName);
                } else {
                    servletInfos = new ArrayList();
                    URLPatternMapping.this.projectToServletInfo.put(warFileName, servletInfos);
                }
                Set<AnnotationInfo> ais = ad.getAnnotationInformation(URLPatternMapping.attrType);
                if (ais.size() > 0) {
                    String servletName = data.getClassName();
                    ArrayList<String> urlPatterns = new ArrayList<String>();
                    for (AnnotationInfo ai : ais) {
                        if (!ai.matches(URLPatternMapping.attrName, URLPatternMapping.attrType, attrValues)) continue;
                        String name2 = ai.getAttributeName();
                        if (ai.getAttributeName().equals("name")) {
                            servletName = ai.getAttributeValue();
                            continue;
                        }
                        if (name2.equals("value")) {
                            urlPatterns.add(ai.getAttributeValue());
                            continue;
                        }
                        if (!name2.equals("urlPatterns")) continue;
                        urlPatterns.add(ai.getAttributeValue());
                    }
                    ServletURLInfo info = new ServletURLInfo(key, servletName, urlPatterns);
                    servletInfos.add(info);
                }
            }
            return false;
        }
    };

    public URLPatternMapping() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, null, namespace, false, null, null, null, false);
    }

    public URLPatternMapping(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getAnnotations() {
        return annoClassNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectWebServlet.clearResults();
        this.projectToServletInfo.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectWebServlet.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        Set<String> keys = this.projectToServletInfo.keySet();
        for (String key : keys) {
            HashMap<String, List<ServletURLInfo>> servletNameToAllURLInfo = new HashMap<String, List<ServletURLInfo>>();
            List<ServletURLInfo> info = this.projectToServletInfo.get(key);
            HashMap<String, Set<String>> urlPatternToServletName = new HashMap<String, Set<String>>();
            HashSet<String> flagUrlPatterns = new HashSet<String>();
            this.processInfo(info, servletNameToAllURLInfo, urlPatternToServletName, flagUrlPatterns);
            for (String urlPattern : flagUrlPatterns) {
                Set servletNames = (Set)urlPatternToServletName.get(urlPattern);
                for (String servletName : servletNames) {
                    List thisServletInfos = (List)servletNameToAllURLInfo.get(servletName);
                    for (ServletURLInfo nextInfo : thisServletInfos) {
                        nextInfo.flagURLPattern(urlPattern, finalResults);
                    }
                }
            }
        }
        return finalResults;
    }

    protected void processInfo(List<ServletURLInfo> info, Map<String, List<ServletURLInfo>> servletNameToAllURLInfo, Map<String, Set<String>> urlPatternToServletName, Set<String> flagUrlPatterns) {
        for (ServletURLInfo thisInfo : info) {
            List<Object> urlInfos;
            String servletName = thisInfo.servletName;
            if (servletNameToAllURLInfo.containsKey(servletName)) {
                urlInfos = servletNameToAllURLInfo.get(servletName);
                urlInfos.add(thisInfo);
            } else {
                urlInfos = new ArrayList();
                urlInfos.add(thisInfo);
                servletNameToAllURLInfo.put(servletName, urlInfos);
            }
            for (String urlPattern : thisInfo.urlPatterns) {
                Set<Object> servletNamesForUrlPattern;
                if (urlPatternToServletName.containsKey(urlPattern)) {
                    servletNamesForUrlPattern = urlPatternToServletName.get(urlPattern);
                    if (servletNamesForUrlPattern.contains(servletName)) continue;
                    servletNamesForUrlPattern.add(servletName);
                    flagUrlPatterns.add(urlPattern);
                    continue;
                }
                servletNamesForUrlPattern = new HashSet();
                servletNamesForUrlPattern.add(servletName);
                urlPatternToServletName.put(urlPattern, servletNamesForUrlPattern);
            }
        }
    }

    protected String getWarFileName(String fileName) {
        String warFileName = null;
        int index = fileName.lastIndexOf(".war");
        if (index > -1) {
            warFileName = fileName.substring(0, index + 4);
        }
        return warFileName;
    }

    @Override
    protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
        String warFileName = this.getWarFileName(fileName);
        if (warFileName != null) {
            List<Element> children;
            List<Object> servletInfos = null;
            if (this.projectToServletInfo.containsKey(warFileName)) {
                servletInfos = this.projectToServletInfo.get(warFileName);
            } else {
                servletInfos = new ArrayList();
                this.projectToServletInfo.put(warFileName, servletInfos);
            }
            String servletName = XMLRuleUtil.getFirstChildElementValue((Element)node, namespace, "servlet-name");
            if (servletName != null && (children = XMLRuleUtil.getChildElements((Element)node, namespace, "url-pattern")) != null && children.size() > 0) {
                ServletURLInfo info = new ServletURLInfo(fileName, servletName);
                for (Element el : children) {
                    String value = XMLRuleUtil.getTextWithoutWhitespace(el);
                    if (value == null) continue;
                    int lineNumber = resource.getNodeLineNumber(el);
                    info.addURLPattern(value, lineNumber);
                }
                servletInfos.add(info);
            }
        }
        return false;
    }

    private class ServletURLInfo {
        public String resourceFileName;
        public String servletName;
        public List<Integer> urlPatternNodeLineNumbers;
        public List<String> urlPatterns;

        public ServletURLInfo(String fileName, String name2) {
            this.resourceFileName = fileName;
            this.servletName = name2;
        }

        public ServletURLInfo(String fileName, String name2, List<String> patterns) {
            this.resourceFileName = fileName;
            this.servletName = name2;
            this.urlPatterns = patterns;
        }

        public void addURLPattern(String urlPattern, int lineNumber) {
            if (this.urlPatterns == null) {
                this.urlPatternNodeLineNumbers = new ArrayList<Integer>();
                this.urlPatterns = new ArrayList<String>();
            }
            this.urlPatternNodeLineNumbers.add(new Integer(lineNumber));
            this.urlPatterns.add(urlPattern);
        }

        public void flagURLPattern(String urlPattern, List<DetailResult> results) {
            int index;
            if (this.urlPatterns != null && (index = this.urlPatterns.indexOf(urlPattern)) > -1) {
                int lineNumber = 0;
                String criteria = null;
                String reference = null;
                if (this.urlPatternNodeLineNumbers != null) {
                    Integer lineToFlag = this.urlPatternNodeLineNumbers.get(index);
                    lineNumber = lineToFlag;
                    criteria = "url-pattern=" + urlPattern;
                } else {
                    criteria = "urlPatterns=" + urlPattern;
                    reference = Messages.getString("Report_Reference_Class_Annotation");
                }
                results.add(new DetailResult(URLPatternMapping.this.ruleName, this.resourceFileName, URLPatternMapping.this.ruleDescription, criteria, 1, reference, lineNumber));
            }
        }
    }
}

