/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CountBeans
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.Beans";
    protected static final String JPA_ENTITY = "javax.persistence.Entity";
    protected static final String STATEFUL = "javax.ejb.Stateful";
    protected static final String STATELESS = "javax.ejb.Stateless";
    protected static final String SINGLETON = "javax.ejb.Singleton";
    protected static final String MESSAGE_DRIVEN = "javax.ejb.MessageDriven";
    protected static final String JAKARTA_JPA_ENTITY = "jakarta.persistence.Entity";
    protected static final String JAKARTA_STATEFUL = "jakarta.ejb.Stateful";
    protected static final String JAKARTA_STATELESS = "jakarta.ejb.Stateless";
    protected static final String JAKARTA_SINGLETON = "jakarta.ejb.Singleton";
    protected static final String JAKARTA_MESSAGE_DRIVEN = "jakarta.ejb.MessageDriven";
    protected static final String[] classNames = new String[]{"javax.persistence.Entity", "javax.ejb.Stateful", "javax.ejb.Stateless", "javax.ejb.Singleton", "javax.ejb.MessageDriven", "jakarta.persistence.Entity", "jakarta.ejb.Stateful", "jakarta.ejb.Stateless", "jakarta.ejb.Singleton", "jakarta.ejb.MessageDriven"};
    protected static Map<String, String> annoToRuleName = new HashMap<String, String>();
    protected static final String[] tags = new String[]{"ejb-class"};
    protected static final String[] persistenceTypeTags = new String[]{"persistence-type"};
    protected static final String[] entityTags = new String[]{"entity"};
    protected static final String[] entityMappingsTags = new String[]{"entity-mappings"};
    protected static final String[] allXmlFileName = new String[]{"(.*/)?.+\\.xml"};
    protected static final String[] ejbJarFileName = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml"};
    protected static final String metainfEjbJar = "META-INF/ejb-jar.xml";
    protected static final String webinfEjbJar = "WEB-INF/ejb-jar.xml";
    protected static final String classAttribute = "class";
    protected static final String messageDrivenElement = "message-driven";
    protected static final String sessionElement = "session";
    protected static final String sessionTypeElement = "session-type";
    protected static final String sessionTypeValueStateless = "Stateless";
    protected static final String sessionTypeValueStateful = "Stateful";
    protected static final String sessionTypeValueSingleton = "Singleton";
    protected static final String persistenceTypeValueBean = "Bean";
    protected static final String persistenceTypeValueContainer = "Container";
    protected DetectElement _ejbClassElements;
    protected DetectElement _persistenceTypeElements;
    protected DetectElement _entityElements;
    protected Map<String, Map<String, Set<String>>> xmlClassToAnnotationClassNames;
    protected List<DetailResult> xmlDefinedBeanResults;
    protected Map<String, String> _fileNameToClassName;

    public CountBeans() {
        this("CountStatelessSessionBeans", RULE_DESC, classNames, null, null, null, null, null, false, classAttribute, null, null);
        this.xmlClassToAnnotationClassNames.put(JPA_ENTITY, new HashMap());
        this.xmlClassToAnnotationClassNames.put(STATEFUL, new HashMap());
        this.xmlClassToAnnotationClassNames.put(STATELESS, new HashMap());
        this.xmlClassToAnnotationClassNames.put(SINGLETON, new HashMap());
        this.xmlClassToAnnotationClassNames.put(MESSAGE_DRIVEN, new HashMap());
        this.xmlClassToAnnotationClassNames.put(JAKARTA_JPA_ENTITY, new HashMap());
        this.xmlClassToAnnotationClassNames.put(JAKARTA_STATEFUL, new HashMap());
        this.xmlClassToAnnotationClassNames.put(JAKARTA_STATELESS, new HashMap());
        this.xmlClassToAnnotationClassNames.put(JAKARTA_SINGLETON, new HashMap());
        this.xmlClassToAnnotationClassNames.put(JAKARTA_MESSAGE_DRIVEN, new HashMap());
    }

    public CountBeans(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        annoToRuleName.put(JPA_ENTITY, "CountJPAEntityBeans");
        annoToRuleName.put(STATEFUL, "CountStatefulSessionBeans");
        annoToRuleName.put(STATELESS, "CountStatelessSessionBeans");
        annoToRuleName.put(SINGLETON, "CountSingletonSessionBeans");
        annoToRuleName.put(MESSAGE_DRIVEN, "CountMessageDrivenBeans");
        annoToRuleName.put(JAKARTA_JPA_ENTITY, "CountJPAEntityBeans");
        annoToRuleName.put(JAKARTA_STATEFUL, "CountStatefulSessionBeans");
        annoToRuleName.put(JAKARTA_STATELESS, "CountStatelessSessionBeans");
        annoToRuleName.put(JAKARTA_SINGLETON, "CountSingletonSessionBeans");
        annoToRuleName.put(JAKARTA_MESSAGE_DRIVEN, "CountMessageDrivenBeans");
        this._ejbClassElements = null;
        this._persistenceTypeElements = null;
        this._entityElements = null;
        this.xmlClassToAnnotationClassNames = new HashMap<String, Map<String, Set<String>>>();
        this.xmlDefinedBeanResults = new ArrayList<DetailResult>();
        this._fileNameToClassName = new HashMap<String, String>();
        this._ejbClassElements = new DetectElement("CountStatelessSessionBeans", RULE_DESC, tags, ejbJarFileName, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String className = XMLRuleUtil.getTextWithoutWhitespace(node);
                if (className != null && !className.isEmpty()) {
                    Node parentNode = node.getParentNode();
                    String nodeName = parentNode.getLocalName();
                    if (nodeName.equals(CountBeans.sessionElement)) {
                        String sessionType = XMLRuleUtil.getFirstChildElementValue((Element)parentNode, "*", CountBeans.sessionTypeElement);
                        if (sessionType != null && !sessionType.isEmpty()) {
                            if (sessionType.equals(CountBeans.sessionTypeValueSingleton)) {
                                CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.SINGLETON));
                                CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.JAKARTA_SINGLETON));
                                CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountSingletonSessionBeans", fileName, this.ruleDescription, String.valueOf(this.tags[0]) + "=" + className, 1, null, resource.getNodeLineNumber(node)));
                            } else if (sessionType.equals(CountBeans.sessionTypeValueStateful)) {
                                CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.STATEFUL));
                                CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.JAKARTA_STATEFUL));
                                CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountStatefulSessionBeans", fileName, this.ruleDescription, String.valueOf(this.tags[0]) + "=" + className, 1, null, resource.getNodeLineNumber(node)));
                            } else if (sessionType.equals(CountBeans.sessionTypeValueStateless)) {
                                CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.STATELESS));
                                CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.JAKARTA_STATELESS));
                                CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountStatelessSessionBeans", fileName, this.ruleDescription, String.valueOf(this.tags[0]) + "=" + className, 1, null, resource.getNodeLineNumber(node)));
                            }
                        }
                    } else if (nodeName.equals(CountBeans.messageDrivenElement)) {
                        CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.MESSAGE_DRIVEN));
                        CountBeans.this.addClassToCollection(fileName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.JAKARTA_MESSAGE_DRIVEN));
                        CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountMessageDrivenBeans", fileName, this.ruleDescription, String.valueOf(this.tags[0]) + "=" + className, 1, null, resource.getNodeLineNumber(node)));
                    }
                }
                return false;
            }
        };
        this._persistenceTypeElements = new DetectElement("CountStatelessSessionBeans", RULE_DESC, persistenceTypeTags, ejbJarFileName, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String value = XMLRuleUtil.getTextWithoutWhitespace(node);
                if (value != null && !value.isEmpty()) {
                    if (value.equals(CountBeans.persistenceTypeValueBean)) {
                        CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountBMPEntityBeans", fileName, this.ruleDescription, persistenceTypeTags + "=" + value, 1, null, resource.getNodeLineNumber(node)));
                    } else if (value.equals(CountBeans.persistenceTypeValueContainer)) {
                        CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountCMPEntityBeans", fileName, this.ruleDescription, persistenceTypeTags + "=" + value, 1, null, resource.getNodeLineNumber(node)));
                    }
                }
                return false;
            }
        };
        this._entityElements = new DetectElement("CountStatelessSessionBeans", RULE_DESC, entityTags, allXmlFileName, null, null, false, null, null, null, false, null, null, null, false, entityMappingsTags, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String className;
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null && (className = XMLRuleUtil.getAttributeValue(attrs, "*", CountBeans.classAttribute)) != null && !className.isEmpty()) {
                    String archiveName = ReportUtility.getLastArchiveFileName(fileName);
                    CountBeans.this.addClassToCollection(archiveName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.JPA_ENTITY));
                    CountBeans.this.addClassToCollection(archiveName, className, CountBeans.this.xmlClassToAnnotationClassNames.get(CountBeans.JAKARTA_JPA_ENTITY));
                    CountBeans.this.xmlDefinedBeanResults.add(new DetailResult("CountJPAEntityBeans", fileName, this.ruleDescription, entityTags + ":" + CountBeans.classAttribute + "=" + className, 1, null, resource.getNodeLineNumber(node)));
                }
                return false;
            }
        };
    }

    protected void addClassToCollection(String fileName, String className, Map<String, Set<String>> xmlToClassNames) {
        if (xmlToClassNames.containsKey(fileName)) {
            Set<String> classNames = xmlToClassNames.get(fileName);
            classNames.add(className);
        } else {
            HashSet<String> classNames = new HashSet<String>();
            classNames.add(className);
            xmlToClassNames.put(fileName, classNames);
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allXmlFileName;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._ejbClassElements.clearResults();
        this._persistenceTypeElements.clearResults();
        this._entityElements.clearResults();
        this._fileNameToClassName.clear();
        Set<String> keys = this.xmlClassToAnnotationClassNames.keySet();
        for (String key : keys) {
            this.xmlClassToAnnotationClassNames.get(key).clear();
        }
        this.xmlDefinedBeanResults = new ArrayList<DetailResult>();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._ejbClassElements.analyze(store, detectOnce);
        this._persistenceTypeElements.analyze(store, detectOnce);
        this._entityElements.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> annoResults = super.getResults(store);
        Iterator<DetailResult> it = annoResults.iterator();
        while (it.hasNext()) {
            Set<String> classNames;
            String xmlPath;
            DetailResult nextAnnoResult = it.next();
            String fileName = nextAnnoResult.getFileName();
            String anno = nextAnnoResult.getCriteria();
            String annoClassName = this._fileNameToClassName.get(fileName);
            boolean flagToRemove = false;
            if (fileName.contains(".war")) {
                xmlPath = fileName.substring(0, fileName.lastIndexOf(".war") + 4);
                if (!anno.equals(JPA_ENTITY) && !anno.equals(JAKARTA_JPA_ENTITY)) {
                    xmlPath = String.valueOf(xmlPath) + "/" + webinfEjbJar;
                }
                if ((classNames = this.xmlClassToAnnotationClassNames.get(anno).get(xmlPath)) != null && classNames.contains(annoClassName)) {
                    flagToRemove = true;
                }
            }
            if (!flagToRemove && fileName.contains(".jar")) {
                xmlPath = fileName.substring(0, fileName.lastIndexOf(".jar") + 4);
                if (!anno.equals(JPA_ENTITY) && !anno.equals(JAKARTA_JPA_ENTITY)) {
                    xmlPath = String.valueOf(fileName.substring(0, fileName.lastIndexOf(".jar") + 5)) + metainfEjbJar;
                }
                if ((classNames = this.xmlClassToAnnotationClassNames.get(anno).get(xmlPath)) != null && classNames.contains(annoClassName)) {
                    flagToRemove = true;
                }
            }
            if (flagToRemove) {
                it.remove();
                continue;
            }
            nextAnnoResult.setRuleName(annoToRuleName.get(anno));
        }
        annoResults.addAll(this.xmlDefinedBeanResults);
        return annoResults;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
        if (!shouldScan) {
            return false;
        }
        this._fileNameToClassName.put(key, data.getClassName());
        return true;
    }
}

