/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class SharedLibDependencies
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.SharedLibDependencies";
    protected static final String MATCH_NON_FULLY_QUALIFIED_PATH_REG = "^(?![A-Z]:\\/|\\/).*";
    protected static final Pattern[] classFile = new Pattern[]{Constants.CLASS_FILE_REG};
    protected Map<String, SortedSet<String>> referencedClasses = new HashMap<String, SortedSet<String>>();

    public SharedLibDependencies() {
        this("SharedLibDependencies", RULE_DESC, classFile, false);
    }

    public SharedLibDependencies(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        HashSet<String> applicationClasses = new HashSet<String>();
        HashSet<String> sharedLibraryFiles = new HashSet<String>();
        HashSet<String> applicationChecksums = new HashSet<String>();
        HashSet<String> sharedLibraryChecksums = new HashSet<String>();
        Set<String> matches = store.getMatchingFileNames(classFile[0], false, true);
        for (String fileName : matches) {
            if (fileName.matches(MATCH_NON_FULLY_QUALIFIED_PATH_REG)) {
                String qualifiedClassName = ReportUtility.getQualifiedClassName(fileName);
                applicationClasses.add(qualifiedClassName);
                String archivePath = ReportUtility.getLastArchiveFileName(fileName);
                applicationChecksums.add(store.getChecksum(archivePath));
                continue;
            }
            fileName = fileName.replace(".class", "");
            sharedLibraryFiles.add(fileName);
            String archivePath = ReportUtility.getLastArchiveFileName(fileName);
            sharedLibraryChecksums.add(store.getChecksum(archivePath));
        }
        Map<String, Set<String>> mapOfClassNamesReferencedByArchive = store.getMapOfReferencedClassNames();
        for (String qualifiedClassName : sharedLibraryFiles) {
            boolean isSameLibrary;
            String archiveName = ReportUtility.getLastArchiveFileName(qualifiedClassName);
            String libraryChecksum = store.getChecksum(archiveName);
            Set<String> classes = mapOfClassNamesReferencedByArchive.get(archiveName);
            boolean bl = isSameLibrary = libraryChecksum != null && applicationChecksums.contains(libraryChecksum);
            if (classes == null || isSameLibrary) continue;
            for (String qualRefName : classes) {
                if (!applicationClasses.contains(qualRefName)) continue;
                SortedSet<Object> refClasses = null;
                if (this.referencedClasses.containsKey(archiveName)) {
                    refClasses = this.referencedClasses.get(archiveName);
                } else {
                    refClasses = new TreeSet();
                    this.referencedClasses.put(archiveName, refClasses);
                }
                refClasses.add(qualRefName);
            }
        }
        for (String key : this.referencedClasses.keySet()) {
            SortedSet<String> refClasses = this.referencedClasses.get(key);
            String ref = null;
            if (refClasses != null && !refClasses.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String nextRef : refClasses) {
                    sb.append(nextRef);
                    sb.append("<br>");
                }
                ref = sb.substring(0, sb.length() - 4);
            }
            this.detailResults.add(new DetailResult(this.ruleName, null, this.ruleDescription, ref, 1, key, 0));
        }
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.referencedClasses.clear();
    }
}

