/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities.eetechnologies;

import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.binary.utilities.eetechnologies.Technology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JPATechnology
extends Technology {
    public static final String PERSISTENCE_3_1 = "persistence-3.1";

    public JPATechnology(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaEEVersion sourceJavaEEVersion, ReportInputData.JavaEEVersion targetJavaEEVersion) {
        super(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion);
    }

    @Override
    public List<String> getRules() {
        ArrayList<String> rules = new ArrayList<String>();
        if (this.targetJavaEEVersion == ReportInputData.JavaEEVersion.EE6 && this.isWasToLiberty()) {
            rules.add("/rules/liberty/Was2LibertyJPA20List.xml");
        } else {
            if (this.includeEE7() || this.isWasToLiberty() && this.targetJavaEEVersion == ReportInputData.JavaEEVersion.EE7) {
                if (this.sourceJavaEEVersion == ReportInputData.JavaEEVersion.EE7 && this.isWasToLiberty()) {
                    rules.add("/rules/liberty/Was2LibertyJPA20List.xml");
                }
                if (this.targetJavaEEVersion == ReportInputData.JavaEEVersion.EE7) {
                    rules.add("/rules/java/JavaEE6JPAList.xml");
                }
                if (this.targetAppServer != ReportInputData.AppServer.WAS90) {
                    rules.add("/rules/java/JavaEE7JPAList.xml");
                }
            }
            if (this.includeEE8() && this.sourceJavaEEVersion == ReportInputData.JavaEEVersion.EE7) {
                rules.add("/rules/java/JavaEE8JPAList.xml");
            }
            if (this.includeEE10()) {
                rules.add("/rules/java/JakartaEE10PersistenceList.xml");
            }
        }
        return rules;
    }

    @Override
    public List<String> getRules(Set<String> features, ConfigFeatureVersionInfo cfvi, Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures) {
        ArrayList<String> rules = new ArrayList<String>();
        if (this.targetAppServer == ReportInputData.AppServer.WAS90) {
            rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE6JPAList.xml"));
        } else {
            int sourceEENumber;
            if (features.contains("jpa-2.0") && this.reportToRuleIds.containsKey("/rules/liberty/Was2LibertyJPA20List.xml") && this.isWasToLiberty()) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/liberty/Was2LibertyJPA20List.xml"));
            }
            int n = sourceEENumber = this.sourceJavaEEVersion == null ? ReportInputData.JavaEEVersion.EE6.getVersionNumber() : this.sourceJavaEEVersion.getVersionNumber();
            if (this.containsFeatureOrLater(features, "jpa-2.1") && this.reportToRuleIds.containsKey("/rules/java/JavaEE7JPAList.xml") && (sourceEENumber < ReportInputData.JavaEEVersion.EE7.getVersionNumber() || sourceEENumber == ReportInputData.JavaEEVersion.EE7.getVersionNumber() && cfvi.getLowestJpaVersion().equals("jpa-2.0"))) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE7JPAList.xml"));
            }
            if (this.isSourceBefore(ReportInputData.JavaEEVersion.EE10) && this.reportToRuleIds.containsKey("/rules/java/JakartaEE10PersistenceList.xml") && this.containsFeatureOrLater(features, PERSISTENCE_3_1)) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JakartaEE10PersistenceList.xml"));
            }
        }
        return rules;
    }

    @Override
    public List<String> getAllRules() {
        ArrayList<String> rules = new ArrayList<String>();
        rules.add("/rules/liberty/Was2LibertyJPA20List.xml");
        rules.add("/rules/java/JavaEE6JPAList.xml");
        rules.add("/rules/java/JavaEE7JPAList.xml");
        rules.add("/rules/java/JavaEE8JPAList.xml");
        rules.add("/rules/java/JakartaEE10PersistenceList.xml");
        return rules;
    }
}

