/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.technology;

import java.util.Map;
import java.util.TreeMap;

public class DetailResult
implements Comparable<DetailResult> {
    private String _fileName = null;
    private String _ruleName = null;
    private String _ruleDesc = null;
    private int _numOccurrences = 0;
    private String _criteria = null;
    private int _lineNumber = 0;
    private String _reference = null;
    private int _referenceNumber = -1;
    private Map<String, Integer> hitsPerReference = null;

    public DetailResult(String thisRuleName, String thisFileName, String desc, String criteria) {
        this(thisRuleName, thisFileName, desc, criteria, 1, null, 0, -1);
    }

    public DetailResult(String thisRuleName, String thisFileName, String desc, String criteria, int numOccurrences) {
        this(thisRuleName, thisFileName, desc, criteria, numOccurrences, null, 0, -1);
    }

    public DetailResult(String thisRuleName, String thisFileName, String desc, String criteria, int numOccurrences, String reference, int lineNumber) {
        this(thisRuleName, thisFileName, desc, criteria, numOccurrences, reference, lineNumber, -1);
    }

    public DetailResult(String thisRuleName, String thisFileName, String desc, String criteria, int numOccurrences, String reference, int lineNumber, int referenceNumber) {
        this._ruleName = thisRuleName;
        this._fileName = thisFileName;
        this._ruleDesc = desc;
        this._criteria = criteria;
        this._numOccurrences = numOccurrences;
        this._reference = reference;
        this._lineNumber = lineNumber;
        this._referenceNumber = referenceNumber;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getRuleName() {
        return this._ruleName;
    }

    public void setRuleName(String ruleName) {
        this._ruleName = ruleName;
    }

    public String getRuleDesc() {
        return this._ruleDesc;
    }

    public String getCriteria() {
        return this._criteria;
    }

    public void setCriteria(String criteria) {
        this._criteria = criteria;
    }

    public int getNumberOfOccurrences() {
        return 1;
    }

    public void setNumberOfOccurrences(int occurrences) {
        this._numOccurrences = occurrences;
    }

    public String getReference() {
        return this._reference;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getReferenceNumber() {
        return this._referenceNumber;
    }

    public void setReferencedClasses(TreeMap<String, Integer> hitsPerReference) {
        this.hitsPerReference = hitsPerReference;
    }

    public Map<String, Integer> getReferencedClasses() {
        return this.hitsPerReference;
    }

    public boolean matches(DetailResult compare) {
        boolean flag = false;
        if (this._fileName.equals(compare.getFileName()) && (this._reference != null && compare.getReference() != null && this._reference.equals(compare.getReference()) || this._reference == null && compare.getReference() == null) && this._referenceNumber == compare.getReferenceNumber()) {
            return true;
        }
        return flag;
    }

    @Override
    public int compareTo(DetailResult o) {
        String otherRef = o.getReference();
        int compare = 0;
        if (this._reference != null && otherRef != null) {
            compare = this._reference.compareTo(otherRef);
        } else if (this._reference == null && otherRef != null) {
            compare = -1;
        } else if (otherRef == null && this._reference != null) {
            compare = 1;
        }
        return compare == 0 ? this.doSecondaryOrderSort(o) : compare;
    }

    public String toString() {
        return "DetailResult [_fileName=" + this._fileName + ", _ruleName=" + this._ruleName + ", _ruleDesc=" + this._ruleDesc + ", _numOccurrences=" + this._numOccurrences + ", _criteria=" + this._criteria + ", _lineNumber=" + this._lineNumber + ", _reference=" + this._reference + ", _referenceNumber=" + this._referenceNumber + ", hitsPerReference=" + this.hitsPerReference + "]";
    }

    private int doSecondaryOrderSort(DetailResult o) {
        return this._lineNumber < o.getLineNumber() ? -1 : (this._lineNumber > o.getLineNumber() ? 1 : 0);
    }
}

