/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.was2liberty.technology;

import com.ibm.ws.report.technology.AbstractTechnology;
import com.ibm.ws.report.technology.AbstractTechnologyFactory;
import com.ibm.ws.report.technology.ReportHeader;
import com.ibm.ws.report.technology.ReportRow;
import com.ibm.ws.report.was2liberty.technologies.Messages;
import com.ibm.ws.report.was2liberty.technology.LineBreak;
import com.ibm.ws.report.was2liberty.technology.Was2LibertyTechnology;
import java.util.ArrayList;
import java.util.List;

public class Was2LibertyTechnologyFactory
implements AbstractTechnologyFactory {
    List<AbstractTechnology> _techs = new ArrayList<AbstractTechnology>();

    @Override
    public AbstractTechnology getConcreteTechnology(String techName) {
        for (AbstractTechnology item : this._techs) {
            if (!techName.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    public AbstractTechnology getConcreteTechnologyByID(String techID) {
        for (AbstractTechnology item : this._techs) {
            if (!techID.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    public static boolean triggerOnAny(String[] rulesToTrigger, List<String> rulesFound) {
        if (rulesToTrigger == null) {
            return false;
        }
        boolean hasAny = false;
        String[] stringArray = rulesToTrigger;
        int n = rulesToTrigger.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            if (rulesFound != null && rulesFound.contains(rule)) {
                hasAny = true;
            }
            ++n2;
        }
        return hasAny;
    }

    public static boolean triggerOnAll(String[] rulesToTrigger, List<String> rulesFound) {
        if (rulesToTrigger == null) {
            return false;
        }
        boolean hasAny = true;
        boolean emptyList = true;
        String[] stringArray = rulesToTrigger;
        int n = rulesToTrigger.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            emptyList = false;
            if (hasAny && (rulesFound == null || !rulesFound.contains(rule))) {
                hasAny = false;
            }
            ++n2;
        }
        return hasAny && !emptyList;
    }

    @Override
    public List<AbstractTechnology> getListOfTechnologies() {
        return this._techs;
    }

    @Override
    public List<AbstractTechnology> calculateListOfTechnologies(List<ReportHeader> headers) {
        this._techs.clear();
        int numHeaders = headers.size();
        int i = 0;
        while (i < numHeaders) {
            ReportHeader nextHeader = headers.get(i);
            String id = nextHeader.getId();
            this._techs.add(new LineBreak(Messages.getString(id)));
            List<ReportRow> rows = nextHeader.getRows();
            int numRows = rows.size();
            int j = 0;
            while (j < numRows) {
                ReportRow nextRow = rows.get(j);
                this.addTechnology(nextRow);
                ++j;
            }
            ++i;
        }
        return this._techs;
    }

    protected void addTechnology(ReportRow row) {
        String id = row.getId();
        String referredToAs = row.getReferredToAs();
        String reference = referredToAs != null ? Messages.getString(referredToAs) : null;
        Was2LibertyTechnology nextTechnology = new Was2LibertyTechnology(Messages.getString(id), id, row.getSupport(), reference);
        nextTechnology.addTriggerOnAnyRules(row.getAnyRules());
        nextTechnology.addTriggerOnAllRules(row.getAllRules());
        nextTechnology.addTriggerOnNoneRules(row.getNoneRules());
        this._techs.add(nextTechnology);
    }
}

