/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer;

import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.writer.ModuleHierarchy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ModuleData {
    public static final Pattern ARCHIVE_EXTENSION_REGEX = Pattern.compile(".*\\.(cba|ear|eba|jar|rar|war)");
    Map<String, ModuleHierarchy> allModules = new HashMap<String, ModuleHierarchy>();
    List<String> ruleDescriptions = null;
    int numberOfRules = 0;

    public ModuleData(List<String> ruleDescs) {
        this.ruleDescriptions = ruleDescs;
        this.numberOfRules = ruleDescs.size();
    }

    public List<String> getSortedModuleNames() {
        Set<String> keys = this.allModules.keySet();
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    public ModuleHierarchy getModuleHierarchy(String key) {
        return this.allModules.get(key);
    }

    public void addModulesForResults(List<DetailResult> results, int ruleIndex) {
        for (DetailResult nextResult : results) {
            this.addModulesForResult(nextResult, ruleIndex);
        }
    }

    public void addModulesForResult(DetailResult result, int ruleIndex) {
        this.addModulesForFileNameWithOccurrences(result.getFileName(), result.getNumberOfOccurrences(), ruleIndex);
    }

    public void addModulesForFileNameWithOccurrences(String fileName, int numOccurrences, int ruleIndex) {
        List<String> modules = this.getModules(fileName);
        if (!modules.isEmpty()) {
            String moduleName = modules.get(0);
            if (this.allModules.containsKey(moduleName)) {
                ModuleHierarchy md = this.allModules.get(moduleName);
                md.addModules(modules, numOccurrences, ruleIndex);
            } else {
                ModuleHierarchy mh = new ModuleHierarchy(modules, numOccurrences, ruleIndex, this.numberOfRules);
                this.allModules.put(moduleName, mh);
            }
        }
    }

    private List<String> getModules(String fileName) {
        ArrayList<String> modulesList = new ArrayList<String>();
        String path = fileName;
        int index = fileName.lastIndexOf(47);
        while (index > -1) {
            if (ARCHIVE_EXTENSION_REGEX.matcher(path = path.substring(0, index)).matches()) {
                modulesList.add(0, path);
            }
            index = path.lastIndexOf(47);
        }
        if (modulesList.isEmpty()) {
            modulesList.add(fileName);
        }
        return modulesList;
    }
}

