/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisRule;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RewriteUtility;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RewriteMavenConfigWriter {
    private static final String PLUGIN_ELEMENT = "plugin";
    private static final String GROUP_ID_ELEMENT = "groupId";
    private static final String ARTIFACT_ID_ELEMENT = "artifactId";
    private static final String VERSION_ELEMENT = "version";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String ACTIVE_RECIPE_ELEMENT = "activeRecipes";
    private static final String DEPENDENCIES_ELEMENT = "dependencies";
    private static final String DEPENDENCY_ELEMENT = "dependency";
    private static final String RECIPE_ELEMENT = "recipe";

    public static String buildRewriteConfig(LinkedHashMap<String, LinkedHashSet<String>> rulesToRecipes, SortedMap<String, AnalysisRule> mapOfIdToAnalysisRules, boolean showAllHelp) {
        String configString = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element pluginEl = doc.createElement(PLUGIN_ELEMENT);
            Element pluginGroupIdEl = doc.createElement(GROUP_ID_ELEMENT);
            pluginGroupIdEl.setTextContent("org.openrewrite.maven");
            Element pluginArtifactIdEl = doc.createElement(ARTIFACT_ID_ELEMENT);
            pluginArtifactIdEl.setTextContent("rewrite-maven-plugin");
            Element pluginVersionEl = doc.createElement(VERSION_ELEMENT);
            pluginVersionEl.setTextContent(RewriteUtility.getRepoVersion("rewrite-maven-plugin"));
            pluginEl.appendChild(pluginGroupIdEl);
            pluginEl.appendChild(pluginArtifactIdEl);
            pluginEl.appendChild(pluginVersionEl);
            Element configurationEl = doc.createElement(CONFIGURATION_ELEMENT);
            Element activeRecipesEl = doc.createElement(ACTIVE_RECIPE_ELEMENT);
            Element dependenciesEl = doc.createElement(DEPENDENCIES_ELEMENT);
            TreeSet<RewriteUtility.RewriteDependency> rewriteDependencies = new TreeSet<RewriteUtility.RewriteDependency>(new RewriteUtility.RewriteDependencyComparator());
            for (Map.Entry<String, LinkedHashSet<String>> entry : rulesToRecipes.entrySet()) {
                String ruleId = entry.getKey();
                LinkedHashSet<String> recipes = entry.getValue();
                AnalysisRule rule = (AnalysisRule)mapOfIdToAnalysisRules.get(ruleId);
                if (rule == null || !showAllHelp && rule.getResults().isEmpty()) continue;
                String defaultRecipe = (String)recipes.iterator().next();
                LinkedHashSet<Object> subRecipes = new LinkedHashSet();
                if (RewriteUtility.recipesToSplit.contains(defaultRecipe)) {
                    subRecipes = RewriteUtility.getSubRecipes(defaultRecipe);
                } else {
                    subRecipes = new LinkedHashSet();
                    subRecipes.add(defaultRecipe);
                }
                Comment missingDependencyComment = null;
                RewriteUtility.RewriteDependency recipeDependency = RewriteUtility.RewriteDependency.resolveRecipeDependency(defaultRecipe);
                if (recipeDependency != null) {
                    rewriteDependencies.add(recipeDependency);
                } else {
                    missingDependencyComment = doc.createComment(Messages.getString("RewriteConfigWriter_Dependecy_Maybe_Required"));
                }
                for (String string : subRecipes) {
                    Comment comment = doc.createComment(rule.getRuleName());
                    Element recipeEl = doc.createElement(RECIPE_ELEMENT);
                    recipeEl.setTextContent(string);
                    activeRecipesEl.appendChild(comment);
                    if (missingDependencyComment != null) {
                        activeRecipesEl.appendChild(missingDependencyComment);
                    }
                    activeRecipesEl.appendChild(recipeEl);
                }
            }
            configurationEl.appendChild(activeRecipesEl);
            for (RewriteUtility.RewriteDependency recipeDependency : rewriteDependencies) {
                Element dependencyEl = doc.createElement(DEPENDENCY_ELEMENT);
                Element dependencyGroupIdEl = doc.createElement(GROUP_ID_ELEMENT);
                dependencyGroupIdEl.setTextContent(recipeDependency.getGroupId());
                dependencyEl.appendChild(dependencyGroupIdEl);
                Element dependencyArtifactIdEl = doc.createElement(ARTIFACT_ID_ELEMENT);
                dependencyArtifactIdEl.setTextContent(recipeDependency.getArtifactId());
                dependencyEl.appendChild(dependencyArtifactIdEl);
                Element dependencyVersionEl = doc.createElement(VERSION_ELEMENT);
                dependencyVersionEl.setTextContent(recipeDependency.getVersion());
                dependencyEl.appendChild(dependencyVersionEl);
                dependenciesEl.appendChild(dependencyEl);
            }
            pluginEl.appendChild(configurationEl);
            pluginEl.appendChild(dependenciesEl);
            doc.appendChild(pluginEl);
            configString = FileHelper.getStringFromDocument(doc, false);
        }
        catch (Exception e) {
            if (ReportUtility.isDebug()) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("RewriteConfigWriter_Generation_Error_Log"), e);
            }
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("RewriteConfigWriter_Generation_Error"), e.getMessage()));
        }
        return configString;
    }
}

