/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.ta.ProductInf;
import com.ibm.ws.report.ta.WebsphereProfile;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;

public class EnvironmentJsonWriter {
    private final List<ProductInf> productInfs;
    private final List<WebsphereProfile> profiles;
    private final Locale locale;
    private final boolean hasConfig;
    private final List<String> appsToScanUser;
    private final List<String> appsToSkipUser;
    private final boolean stopOnMissingBinary;
    private final boolean stopOnMissingSharedLibrary;

    public EnvironmentJsonWriter(List<ProductInf> productInfs, List<WebsphereProfile> profiles, boolean hasConfig, List<String> includeApplications, List<String> excludeApplications, boolean stopOnMissingBinary, boolean stopOnMissingSharedLibrary) {
        this.productInfs = productInfs;
        this.profiles = profiles;
        this.hasConfig = hasConfig;
        this.appsToScanUser = includeApplications;
        this.appsToSkipUser = excludeApplications;
        this.stopOnMissingBinary = stopOnMissingBinary;
        this.stopOnMissingSharedLibrary = stopOnMissingSharedLibrary;
        this.locale = ReportUtility.getLocale();
    }

    public OrderedJSONObject toJSONObject() {
        OrderedJSONObject json = new OrderedJSONObject();
        JSONArray productInfJsonArray = new JSONArray();
        Collections.sort(this.productInfs, new ProductInfComp());
        for (ProductInf productInf : this.productInfs) {
            productInfJsonArray.add(productInf.toJSONObject());
        }
        json.put("productInf", productInfJsonArray);
        Collections.sort(this.profiles, new WebsphereProfileComp());
        JSONArray profileJsonArray = new JSONArray();
        for (WebsphereProfile profile : this.profiles) {
            profileJsonArray.add(profile.toJSONObject());
        }
        json.put("profiles", profileJsonArray);
        JSONArray appsToScanUserJson = new JSONArray();
        JSONArray appsToSkipUserJson = new JSONArray();
        if (this.appsToScanUser != null) {
            appsToScanUserJson.addAll(this.appsToScanUser);
        }
        if (this.appsToSkipUser != null) {
            appsToSkipUserJson.addAll(this.appsToSkipUser);
        }
        json.put("appsToScan_user", appsToScanUserJson);
        json.put("appsToSkip_user", appsToSkipUserJson);
        json.put("scanNodeFlag", (Object)false);
        json.put("ignoreMissingSharedLibrary", (Object)(!this.stopOnMissingSharedLibrary ? 1 : 0));
        json.put("ignoreMissingBinary", (Object)(!this.stopOnMissingBinary ? 1 : 0));
        json.put("scanBinaryLocation", (Object)(!this.hasConfig ? 1 : 0));
        json.put("locale", this.locale.getLanguage());
        json.put("createdDate", (Object)ReportUtility.getCreatedDateEpoch());
        return json;
    }

    public void writeToJsonFile(String outputDir) {
        String fileName = "environment.json";
        File outputFile = new File(outputDir != null && !outputDir.isEmpty() ? String.valueOf(outputDir) + File.separator + fileName : fileName);
        ReportUtility.logger.get().log(Level.FINE, "Write the environment.json file in " + outputFile);
        OrderedJSONObject environmentJson = this.toJSONObject();
        try {
            ReportUtility.writeOutStream(outputFile, environmentJson.serialize(true).replace("\\/", "/"));
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("ReportBuilder_File_Generate_Fail"), fileName), e);
        }
    }

    class ProductInfComp
    implements Comparator<ProductInf> {
        ProductInfComp() {
        }

        @Override
        public int compare(ProductInf e1, ProductInf e2) {
            return e1.getName().compareTo(e2.getName());
        }
    }

    class WebsphereProfileComp
    implements Comparator<WebsphereProfile> {
        WebsphereProfileComp() {
        }

        @Override
        public int compare(WebsphereProfile e1, WebsphereProfile e2) {
            return e1.getName().compareTo(e2.getName());
        }
    }
}

