/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ScanResult {
    List<String> collectionFileNames;
    int returnCode;

    public ScanResult(List<String> collectionFileNames) {
        this.collectionFileNames = collectionFileNames;
    }

    public OrderedJSONObject toJSONObject() {
        OrderedJSONObject json = new OrderedJSONObject();
        json.put("return_code", (Object)this.returnCode);
        JSONArray collectionFileNamesJsonArray = new JSONArray();
        if (this.collectionFileNames != null) {
            collectionFileNamesJsonArray.addAll(this.collectionFileNames);
        }
        json.put("collection_files", collectionFileNamesJsonArray);
        return json;
    }

    public void writeToJsonFile(String outputDir) {
        String fileName = "scan_results.json";
        File outputFile = new File(outputDir != null && !outputDir.isEmpty() ? String.valueOf(outputDir) + File.separator + fileName : fileName);
        ReportUtility.logger.get().log(Level.FINE, "Write the scan_result.json file in " + outputFile);
        OrderedJSONObject scanResultJson = this.toJSONObject();
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.equalsIgnoreCase("z/OS")) {
                ReportUtility.writeOutStream(outputFile, scanResultJson.serialize(true).replace("\\/", "/"), Level.FINE, true, "IBM-1047");
            } else {
                ReportUtility.writeOutStream(outputFile, scanResultJson.serialize(true).replace("\\/", "/"), Level.FINE);
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("ReportBuilder_File_Generate_Fail"), fileName), e);
        }
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void addCollectionFileName(String name2) {
        if (this.collectionFileNames == null) {
            this.collectionFileNames = new ArrayList<String>();
        }
        this.collectionFileNames.add(name2);
    }
}

