/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiList;
import de.vandermeer.asciilist.AbstractAsciiListItem;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.AsciiList_Enumerate;
import de.vandermeer.asciilist.styles.ListStyle;
import de.vandermeer.asciilist.styles.ListStyle_EnumerateNested;
import de.vandermeer.asciilist.styles.NestedEnumerateStyles;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class EnumerateList
extends AbstractAsciiList
implements AsciiList_Enumerate {
    protected ListStyle_EnumerateNested style;
    protected int[] parents;
    protected boolean isPrepared = false;
    protected int realPosition = 0;
    protected String labelSeparator;
    protected boolean useLabelSeparatorAfterLastItem;

    public EnumerateList() {
        this(true);
    }

    public EnumerateList(boolean isContinued) {
        super(isContinued);
        this.style = NestedEnumerateStyles.aLL_arabic_ascii;
        this.labelSeparator = ".";
        this.useLabelSeparatorAfterLastItem = false;
    }

    public EnumerateList(EnumerateList list) {
        super(list);
        this.style = list.style;
        this.realPosition = list.realPosition;
        this.useLabelSeparatorAfterLastItem = list.useLabelSeparatorAfterLastItem;
        this.labelSeparator = list.labelSeparator;
        this.parents = ArrayUtils.clone(list.parents);
    }

    @Override
    public AsciiList_Enumerate addItem(AsciiList list) {
        Validate.notEmpty(list.getItems());
        AsciiList add = list.copy();
        this.items.add(add);
        return this;
    }

    @Override
    public void prepareRender() {
        super.prepareRender();
        for (Object obj : this.items) {
            if (!(obj instanceof AsciiList_Enumerate) || !((AsciiList_Enumerate)obj).isContinuedList() || ((AsciiList_Enumerate)obj).isPrepared()) continue;
            ++this.realPosition;
            ((AsciiList_Enumerate)obj).setListStyle(this.style);
            if (this.parents == null) {
                ((AsciiList_Enumerate)obj).setParents(new int[]{this.items.size() - this.realPosition});
            } else {
                ((AsciiList_Enumerate)obj).setParents(ArrayUtils.add(this.parents, this.items.size() - this.realPosition));
            }
            ((AsciiList_Enumerate)obj).setPrepared();
        }
    }

    protected String calculateItemLabel(int position) {
        String label = this.style.getStyle(this.level).getLabel(position);
        if (this.parents != null) {
            label = "";
            for (int i = 0; i < this.parents.length; ++i) {
                label = label + this.style.getStyle(i + 1).getLabel(this.parents[i]) + this.labelSeparator;
            }
            label = label + this.style.getStyle(this.level).getLabel(position);
        }
        if (this.useLabelSeparatorAfterLastItem) {
            label = label + this.labelSeparator;
        }
        return label;
    }

    @Override
    public String renderItem(AsciiListItem item, int position) {
        return item.render(this.preLabelIndent, this.preLabelStr, this.calculateItemLabel(position), this.postLabelStr, this.postLabelIndent);
    }

    @Override
    public AsciiList_Enumerate setParents(int[] parents) {
        this.parents = parents;
        return this;
    }

    @Override
    public int[] getParents() {
        return this.parents;
    }

    @Override
    public AsciiList_Enumerate setListStyle(ListStyle style) {
        if (style instanceof ListStyle_EnumerateNested) {
            this.style = (ListStyle_EnumerateNested)style;
        }
        return this;
    }

    @Override
    public AsciiList copy() {
        return new EnumerateList(this);
    }

    @Override
    public AsciiList_Enumerate setLabelSeparator(String separator) {
        this.labelSeparator = separator;
        return this;
    }

    @Override
    public String getLabelSeparator() {
        return this.labelSeparator;
    }

    @Override
    public AsciiList_Enumerate useLabelSeparatorAfterLastItem(boolean flag) {
        this.useLabelSeparatorAfterLastItem = flag;
        return this;
    }

    @Override
    public int calculateMaxIndentation(AsciiListItem item, int position) {
        return this.preLabelIndent + this.preLabelStr.length() + this.calculateItemLabel(position).length() + this.postLabelStr.length() + this.postLabelIndent;
    }

    @Override
    public AsciiList_Enumerate addItem(String item) {
        if (!StringUtils.isBlank(item)) {
            this.items.add(new AbstractAsciiListItem(item));
        }
        return this;
    }

    @Override
    public AsciiList_Enumerate addAllItems(Collection<String> items) {
        if (items != null) {
            for (String s : items) {
                this.addItem(s);
            }
        }
        return this;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void setPrepared() {
        this.isPrepared = true;
    }
}

