/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.commons;

import org.apache.commons.lang3.NotImplementedException;

public abstract class ArabicLiteralUtils {
    public static final String toAscii(int number) {
        return Integer.toString(number);
    }

    public static final String toCircledDigit(int number) {
        if (number < 1 || number > 20) {
            throw new NotImplementedException("Arabic literals - UTF Circled Digit/Number - supported 0<number<21 - number was: " + number);
        }
        return new String(Character.toChars(number + 9311));
    }

    public static final String toDoubleCircledDigit(int number) {
        if (number < 1 || number > 20) {
            throw new NotImplementedException("Arabic literals - UTF Double Circled Digit/Number - supported 0<number<10 - number was: " + number);
        }
        return new String(Character.toChars(number + 9460));
    }

    public static final String toDingbatNegativeCircledDigit(int number) {
        if (number < 1 || number > 10) {
            throw new NotImplementedException("Arabic literals - UTF Dingbat Negative Circled - supported 0<number<11 - number was: " + number);
        }
        return new String(Character.toChars(number + 10101));
    }

    public static final String toDingbatNegativeSanserifCircledDigit(int number) {
        if (number < 1 || number > 10) {
            throw new NotImplementedException("Arabic literals - UTF Dingbat Negative Sanserif Circled - supported 0<number<11 - number was: " + number);
        }
        return new String(Character.toChars(number + 10121));
    }

    public static final String toDingbatSanserifCircledDigit(int number) {
        if (number < 1 || number > 10) {
            throw new NotImplementedException("Arabic literals - UTF Dingbat Sanserif Circled Digit - supported 0<number<11 - number was: " + number);
        }
        return new String(Character.toChars(number + 10111));
    }

    public static final String toSuperscript(int number) {
        if (number < 1 || number > 9) {
            throw new NotImplementedException("Arabic literals - UTF Superscript Latin Small Letter - supported 0<number<10 - number was: " + number);
        }
        if (number == 1 || number > 3) {
            return new String(Character.toChars(number + 8304));
        }
        return new String(Character.toChars(number + 176));
    }

    public static final String toSubscript(int number) {
        if (number < 1 || number > 9) {
            throw new NotImplementedException("Arabic literals - UTF Subscript - supported 0<number<10 - number was: " + number);
        }
        return new String(Character.toChars(number + 8320));
    }

    public static final String toFullStop(int number) {
        if (number < 1 || number > 20) {
            throw new NotImplementedException("Arabic literals - UTF Full Stop - supported 0<number<21 - number was: " + number);
        }
        return new String(Character.toChars(number + 9351));
    }

    public static final String toParenthesized(int number) {
        if (number < 1 || number > 20) {
            throw new NotImplementedException("Arabic literals - UTF Parenthesized Digit/Number - supported 0<number<21 - number was: " + number);
        }
        return new String(Character.toChars(number + 9331));
    }

    public static final String toFullwidth(int number) {
        if (number < 1 || number > 9) {
            throw new NotImplementedException("Arabic literals - UTF Fullwidth - supported 0<number<10 - number was: " + number);
        }
        return new String(Character.toChars(number + 65296));
    }
}

