/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.security.Permission;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

public class InternalUtils {
    public static List<Capability> asListCapability(List<? extends Capability> l) {
        return l;
    }

    public static List<Requirement> asListRequirement(List<? extends Requirement> l) {
        return l;
    }

    public static List<BundleCapability> asListBundleCapability(List<? extends BundleCapability> l) {
        return l;
    }

    public static List<BundleRequirement> asListBundleRequirement(List<? extends BundleRequirement> l) {
        return l;
    }

    public static List<BundleWire> asListBundleWire(List<? extends BundleWire> l) {
        return l;
    }

    public static List<Wire> asListWire(List<? extends Wire> l) {
        return l;
    }

    public static List<BundleRevision> asListBundleRevision(List<? extends BundleRevision> l) {
        return l;
    }

    public static Collection<Resource> asCollectionResource(Collection<? extends Resource> c) {
        return c;
    }

    public static void filterCapabilityPermissions(Collection<? extends BundleCapability> capabilities) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Iterator<? extends BundleCapability> iCapabilities = capabilities.iterator();
        while (iCapabilities.hasNext()) {
            BundleCapability capability = iCapabilities.next();
            Permission permission = InternalUtils.getProvidePermission(capability);
            Bundle provider = capability.getRevision().getBundle();
            if (provider == null || provider.hasPermission(permission)) continue;
            iCapabilities.remove();
        }
    }

    public static Permission getRequirePermission(BundleCapability candidate) {
        String name2 = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name2)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), candidate.getRevision().getBundle(), "import");
        }
        if ("osgi.wiring.host".equals(name2)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "fragment");
        }
        if ("osgi.wiring.bundle".equals(name2)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "require");
        }
        return new CapabilityPermission(name2, candidate.getAttributes(), candidate.getRevision().getBundle(), "require");
    }

    public static Permission getProvidePermission(BundleCapability candidate) {
        String name2 = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name2)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), "exportonly");
        }
        if ("osgi.wiring.host".equals(name2)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "host");
        }
        if ("osgi.wiring.bundle".equals(name2)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "provide");
        }
        return new CapabilityPermission(name2, "provide");
    }

    private static String getPermisionName(BundleCapability candidate) {
        Object name2 = candidate.getAttributes().get(candidate.getNamespace());
        if (name2 instanceof String) {
            return (String)name2;
        }
        if (name2 instanceof Collection) {
            Collection names = (Collection)name2;
            return names.isEmpty() ? "unknown" : names.iterator().next().toString();
        }
        return "unknown";
    }
}

