/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static URL toURL(String filename) throws MalformedURLException {
        URL url;
        try {
            url = new URL(filename);
        }
        catch (MalformedURLException e) {
            url = new File(filename).toURI().toURL();
        }
        return url;
    }

    public static URI toNormalizedURI(String filename) {
        return UrlUtil.toNormalizedURI(new File(filename));
    }

    public static URI toNormalizedURI(File file) {
        return file.toURI().normalize();
    }

    public static String toAbsoluteURI(URI uri) {
        return uri.toString();
    }

    public static InputStream openStream(URL url) throws IOException {
        return url.openStream();
    }

    public static String getFileUriString(String filename) throws MalformedURLException {
        return new File(filename).toURI().toURL().toExternalForm();
    }

    public static String getNormalizedFileUriString(String filename) {
        return "file://" + UrlUtil.toNormalizedURI(filename).getPath();
    }

    public static InputStream getInputStreamOfFinalConnection(URL initialUrl) throws IOException {
        URLConnection finalConnection = UrlUtil.getFinalConnection(initialUrl);
        return finalConnection.getInputStream();
    }

    static URLConnection getFinalConnection(URL initialUrl) throws IOException {
        URL nextUrl = initialUrl;
        URLConnection connection = null;
        while (nextUrl != null) {
            connection = nextUrl.openConnection();
            String location = connection.getHeaderField("location");
            if ((nextUrl = location == null ? null : new URL(location)) == null) continue;
            connection.getInputStream().close();
        }
        return connection;
    }
}

