/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.joyent.manta.serialization.AbstractManualSerializer;
import com.joyent.manta.serialization.MantaClientSerializationException;
import com.joyent.manta.serialization.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class PKCS11Serializer
extends AbstractManualSerializer<PKCS11> {
    private static final Field MODULE_PATH_FIELD = ReflectionUtils.getField(PKCS11.class, "pkcs11ModulePath");

    public PKCS11Serializer() {
        super(PKCS11.class, false, true);
    }

    public void write(Kryo kryo, Output output, PKCS11 object) {
        Object modulePath = ReflectionUtils.readField(MODULE_PATH_FIELD, object);
        output.writeString(modulePath.toString());
    }

    public PKCS11 read(Kryo kryo, Input input, Class<PKCS11> type) {
        String modulePath = input.readString();
        try {
            return PKCS11.getInstance(modulePath, "C_GetFunctionList", null, false);
        }
        catch (IOException | PKCS11Exception e) {
            throw new MantaClientSerializationException("Unable to instantiate PKC11 class", e);
        }
    }
}

