/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Serializer;
import com.joyent.manta.serialization.ReflectionUtils;
import java.lang.reflect.Field;

public abstract class AbstractManualSerializer<T>
extends Serializer<T> {
    private Class<T> classReference;

    public AbstractManualSerializer(Class<T> classReference) {
        super(false, true);
        this.classReference = classReference;
    }

    public AbstractManualSerializer(Class<T> classReference, boolean acceptsNull) {
        super(acceptsNull, true);
        this.classReference = classReference;
    }

    public AbstractManualSerializer(Class<T> classReference, boolean acceptsNull, boolean immutable) {
        super(acceptsNull, immutable);
        this.classReference = classReference;
    }

    protected Field captureField(String fieldName) {
        Field field = ReflectionUtils.getField(this.classReference, fieldName);
        if (field == null) {
            String msg = String.format("No field [%s] found on object [%s]", this.classReference, fieldName);
            throw new UnsupportedOperationException(msg);
        }
        return field;
    }

    protected T newInstance(Object ... params) {
        return ReflectionUtils.newInstance(this.classReference, params);
    }
}

