/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.joyent.manta.client.crypto.AesCbcCipherDetails;
import com.joyent.manta.client.crypto.AesCtrCipherDetails;
import com.joyent.manta.client.crypto.AesGcmCipherDetails;
import com.joyent.manta.client.crypto.EncryptingEntityHelper;
import com.joyent.manta.client.crypto.EncryptionContext;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.client.multipart.EncryptionState;
import com.joyent.manta.client.multipart.MultipartOutputStream;
import com.joyent.manta.serialization.AbstractManualSerializer;
import com.joyent.manta.serialization.CipherSerializer;
import com.joyent.manta.serialization.HmacSerializer;
import com.joyent.manta.serialization.ReflectionUtils;
import com.joyent.manta.serialization.SupportedCipherDetailsSerializer;
import com.joyent.manta.util.HmacOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.sun.MagicInstantiator;

public class EncryptionStateSerializer
extends AbstractManualSerializer<EncryptionState> {
    private Field encryptionContextField = this.captureField("encryptionContext");
    private Field lastPartNumberField = this.captureField("lastPartNumber");
    private Field multipartStreamField = this.captureField("multipartStream");
    private Field cipherStreamField = this.captureField("cipherStream");
    private Field lastPartAuthWrittenField = this.captureField("lastPartAuthWritten");
    private final SecretKey secretKey;

    public EncryptionStateSerializer(Kryo kryo, SecretKey secretKey) {
        super(EncryptionState.class, false);
        this.secretKey = secretKey;
        this.registerClasses(kryo);
    }

    private void registerClasses(Kryo kryo) {
        kryo.register(EncryptionContext.class).setInstantiator((ObjectInstantiator)new MagicInstantiator(EncryptionContext.class));
        kryo.register(SupportedCipherDetails.class, (Serializer)new SupportedCipherDetailsSerializer());
        kryo.register(AesCtrCipherDetails.class, (Serializer)new SupportedCipherDetailsSerializer());
        kryo.register(AesCbcCipherDetails.class, (Serializer)new SupportedCipherDetailsSerializer());
        kryo.register(AesGcmCipherDetails.class, (Serializer)new SupportedCipherDetailsSerializer());
        kryo.register(Cipher.class, (Serializer)new CipherSerializer(kryo));
        kryo.register(HMac.class, (Serializer)new HmacSerializer(kryo));
        Class<?> closeShieldStreamClass = this.findCloseShieldStreamClass();
        Objects.requireNonNull(closeShieldStreamClass, "CloseShieldOutputStream reference must not be null");
        kryo.register(closeShieldStreamClass).setInstantiator((ObjectInstantiator)new MagicInstantiator(closeShieldStreamClass));
        kryo.register(CipherOutputStream.class).setInstantiator((ObjectInstantiator)new MagicInstantiator(CipherOutputStream.class));
    }

    private Class<?> findCloseShieldStreamClass() {
        Class<?> unshadedCloseShieldStream = ReflectionUtils.findClassOrNull("org.apache.commons.io.output.CloseShieldOutputStream");
        if (unshadedCloseShieldStream != null) {
            return unshadedCloseShieldStream;
        }
        return ReflectionUtils.findClassOrNull("com.joyent.manta.org.apache.commons.io.output.CloseShieldOutputStream");
    }

    public void write(Kryo kryo, Output output, EncryptionState object) {
        HMac hmac;
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.encryptionContextField, object));
        int lastPartNumber = (Integer)ReflectionUtils.readField(this.lastPartNumberField, object);
        output.writeInt(lastPartNumber, true);
        boolean lastPartAuthWritten = (Boolean)ReflectionUtils.readField(this.lastPartAuthWrittenField, object);
        output.writeBoolean(lastPartAuthWritten);
        MultipartOutputStream multipartStream = (MultipartOutputStream)ReflectionUtils.readField(this.multipartStreamField, object);
        ByteArrayOutputStream multipartStreamBuf = multipartStream == null ? null : multipartStream.getBuf();
        kryo.writeClassAndObject(output, (Object)multipartStreamBuf);
        Object cipherStream = ReflectionUtils.readField(this.cipherStreamField, object);
        Objects.requireNonNull(cipherStream, "Cipher stream must not be null");
        if (cipherStream.getClass().equals(HmacOutputStream.class)) {
            HmacOutputStream hmacStream = (HmacOutputStream)cipherStream;
            hmac = hmacStream.getHmac();
        } else {
            hmac = null;
        }
        kryo.writeObjectOrNull(output, (Object)hmac, HMac.class);
        output.flush();
    }

    public EncryptionState read(Kryo kryo, Input input, Class<EncryptionState> type) {
        EncryptionContext encryptionContext = (EncryptionContext)kryo.readClassAndObject(input);
        int lastPartNumber = input.readVarInt(true);
        boolean lastPartAuthWritten = input.readBoolean();
        encryptionContext.setKey(this.secretKey);
        EncryptionState encryptionState = (EncryptionState)this.newInstance(new Object[0]);
        ReflectionUtils.writeField(this.encryptionContextField, encryptionState, encryptionContext);
        ReflectionUtils.writeField(this.lastPartNumberField, encryptionState, lastPartNumber);
        ReflectionUtils.writeField(this.lastPartAuthWrittenField, encryptionState, lastPartAuthWritten);
        int blockSize = encryptionContext.getCipherDetails().getBlockSizeInBytes();
        Object bufferObject = kryo.readClassAndObject(input);
        ByteArrayOutputStream multipartStreamBuffer = bufferObject == null ? new ByteArrayOutputStream(blockSize) : (ByteArrayOutputStream)bufferObject;
        MultipartOutputStream multipartStream = new MultipartOutputStream(blockSize, multipartStreamBuffer);
        ReflectionUtils.writeField(this.multipartStreamField, encryptionState, multipartStream);
        HMac hmac = (HMac)kryo.readObjectOrNull(input, HMac.class);
        OutputStream cipherStream = EncryptingEntityHelper.makeCipherOutputForStream((OutputStream)multipartStream, (SupportedCipherDetails)encryptionContext.getCipherDetails(), (Cipher)encryptionContext.getCipher(), (HMac)hmac);
        ReflectionUtils.writeField(this.cipherStreamField, encryptionState, cipherStream);
        return encryptionState;
    }
}

