/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.joyent.manta.serialization.AbstractManualSerializer;
import com.joyent.manta.serialization.BaseBlockCipherSerializer;
import com.joyent.manta.serialization.MantaClientSerializationException;
import com.joyent.manta.serialization.PKCS11Serializer;
import com.joyent.manta.serialization.ProviderSerializer;
import com.joyent.manta.serialization.ReflectionUtils;
import com.joyent.manta.serialization.SessionRefSerializer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.IdentityHashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.provider.symmetric.AES;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.sun.UnsafeFactoryInstantiator;

public class CipherSerializer
extends AbstractManualSerializer<Cipher> {
    private final Class<?> cryptoAllPermissionClass;
    private Field cryptoPermField = this.captureField("cryptoPerm");
    private Field exmechField = this.captureField("exmech");
    private Field firstServiceField = this.captureField("firstService");
    private Field firstSpiField = this.captureField("firstSpi");
    private Field initializedField = this.captureField("initialized");
    private Field lockField = this.captureField("lock");
    private Field providerField = this.captureField("provider");
    private Field opmodeField = this.captureField("opmode");
    private Field serviceIteratorField = this.captureField("serviceIterator");
    private Field spiField = this.captureField("spi");
    private Field transformationField = this.captureField("transformation");
    private Field transformsField = this.captureField("transforms");

    public CipherSerializer(Kryo kryo) {
        super(Cipher.class, false);
        this.cryptoAllPermissionClass = ReflectionUtils.findClass("javax.crypto.CryptoAllPermission");
        this.registerClasses(kryo);
    }

    private void registerClasses(Kryo kryo) {
        Class<?> pkcs11Class;
        kryo.register(this.cryptoAllPermissionClass, (Serializer)new JavaSerializer());
        kryo.register(AES.ECB.class, new BaseBlockCipherSerializer<AES.ECB>(kryo, AES.ECB.class));
        kryo.register(AES.CBC.class, new BaseBlockCipherSerializer<AES.CBC>(kryo, AES.CBC.class));
        kryo.register(AES.GCM.class, new BaseBlockCipherSerializer<AES.GCM>(kryo, AES.GCM.class));
        ProviderSerializer providerSerializer = new ProviderSerializer();
        kryo.register(Provider.class, (Serializer)providerSerializer);
        for (Provider p : Security.getProviders()) {
            kryo.register(p.getClass(), (Serializer)providerSerializer);
        }
        kryo.register(IdentityHashMap.class, (Serializer)new JavaSerializer());
        kryo.register(WeakReference.class).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(WeakReference.class));
        kryo.register(AlgorithmParameters.class).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(AlgorithmParameters.class));
        kryo.register(SecretKeySpec.class, (Serializer)new JavaSerializer());
        this.registerWithMagicInstantiator(kryo, "sun.security.pkcs11.P11RSAKeyFactory");
        this.registerWithCompatSerializerMagicInstantiator(kryo, "sun.security.pkcs11.P11Cipher");
        this.registerWithMagicInstantiator(kryo, "sun.security.pkcs11.P11ECKeyFactory");
        this.registerWithMagicInstantiator(kryo, "sun.security.pkcs11.P11Key$P11SecretKey");
        this.registerWithMagicInstantiator(kryo, "sun.security.pkcs11.SessionKeyRef");
        this.registerWithMagicInstantiator(kryo, "sun.security.pkcs11.Session");
        this.registerWithJavaSerializer(kryo, "sun.security.pkcs11.Token");
        this.registerWithJavaSerializer(kryo, "sun.security.pkcs11.P11SecureRandom");
        Class<?> sessionRefClass = ReflectionUtils.findClass("sun.security.pkcs11.SessionRef");
        if (sessionRefClass != null) {
            kryo.register(sessionRefClass, (Serializer)new SessionRefSerializer(kryo));
        }
        if ((pkcs11Class = ReflectionUtils.findClass("sun.security.pkcs11.wrapper.PKCS11")) != null) {
            kryo.register(pkcs11Class, (Serializer)new PKCS11Serializer());
        }
    }

    private void registerWithCompatSerializerMagicInstantiator(Kryo kryo, String className) {
        Class<?> clazz = ReflectionUtils.findClass(className);
        if (clazz != null) {
            kryo.register(clazz, (Serializer)new CompatibleFieldSerializer(kryo, clazz)).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(clazz));
        }
    }

    private void registerWithJavaSerializer(Kryo kryo, String className) {
        Class<?> clazz = ReflectionUtils.findClass(className);
        if (clazz != null) {
            kryo.register(clazz, (Serializer)new JavaSerializer());
        }
    }

    private void registerWithMagicInstantiator(Kryo kryo, String className) {
        Class<?> clazz = ReflectionUtils.findClass(className);
        if (clazz != null) {
            kryo.register(clazz).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(clazz));
        }
    }

    public void write(Kryo kryo, Output output, Cipher object) {
        Object cryptoPerm = ReflectionUtils.readField(this.cryptoPermField, object);
        kryo.writeObjectOrNull(output, cryptoPerm, this.cryptoAllPermissionClass);
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.exmechField, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.firstServiceField, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.firstSpiField, object));
        output.writeBoolean(((Boolean)ReflectionUtils.readField(this.initializedField, object)).booleanValue());
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.lockField, object));
        int opmode = (Integer)ReflectionUtils.readField(this.opmodeField, object);
        output.writeInt(opmode, true);
        Provider provider = (Provider)ReflectionUtils.readField(this.providerField, object);
        output.writeString(provider.getName());
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.serviceIteratorField, object));
        Object spi = ReflectionUtils.readField(this.spiField, object);
        kryo.writeClassAndObject(output, spi);
        output.writeString((String)ReflectionUtils.readField(this.transformationField, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.transformsField, object));
        output.flush();
    }

    public Cipher read(Kryo kryo, Input input, Class<Cipher> type) {
        Cipher cipher;
        Object cryptoPerm = kryo.readObjectOrNull(input, this.cryptoAllPermissionClass);
        Object exmech = kryo.readClassAndObject(input);
        Object firstService = kryo.readClassAndObject(input);
        Object firstSpi = kryo.readClassAndObject(input);
        boolean initialized = input.readBoolean();
        Object lock = kryo.readClassAndObject(input);
        int opmode = input.readVarInt(true);
        String providerName = input.readString();
        Provider provider = providerName != null ? Security.getProvider(providerName) : null;
        Object serviceIterator = kryo.readClassAndObject(input);
        Object spi = kryo.readClassAndObject(input);
        String transformation = input.readString();
        Object transforms = kryo.readClassAndObject(input);
        try {
            cipher = Cipher.getInstance(transformation);
        }
        catch (GeneralSecurityException e) {
            String msg = "Unable to instantiate Cipher";
            MantaClientSerializationException mcse = new MantaClientSerializationException(msg, e);
            mcse.setContextValue("algorithmName", transformation);
            throw mcse;
        }
        ReflectionUtils.writeField(this.cryptoPermField, cipher, cryptoPerm);
        ReflectionUtils.writeField(this.exmechField, cipher, exmech);
        ReflectionUtils.writeField(this.firstServiceField, cipher, firstService);
        ReflectionUtils.writeField(this.firstSpiField, cipher, firstSpi);
        ReflectionUtils.writeField(this.initializedField, cipher, initialized);
        ReflectionUtils.writeField(this.lockField, cipher, lock);
        ReflectionUtils.writeField(this.opmodeField, cipher, opmode);
        ReflectionUtils.writeField(this.providerField, cipher, provider);
        ReflectionUtils.writeField(this.serviceIteratorField, cipher, serviceIterator);
        ReflectionUtils.writeField(this.spiField, cipher, spi);
        ReflectionUtils.writeField(this.transformationField, cipher, transformation);
        ReflectionUtils.writeField(this.transformsField, cipher, transforms);
        return cipher;
    }
}

