/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.client.crypto.SupportedHmacsLookupMap;
import com.joyent.manta.client.multipart.AbstractMultipartUpload;
import com.joyent.manta.client.multipart.EncryptedMultipartUpload;
import com.joyent.manta.exception.MantaClientEncryptionCiphertextAuthenticationException;
import com.joyent.manta.exception.MantaClientEncryptionException;
import com.joyent.manta.serialization.EncryptedMultipartSerializer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedMultipartUploaSerializationHelper<WRAPPED extends AbstractMultipartUpload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedMultipartUploaSerializationHelper.class);
    private static final int CIPHER_ID_SIZE_BYTES = 16;
    private static final int ENCRYPTED_MULTIPART_UPLOAD_SERIALIZATION_VERSION = 1;
    private final Kryo kryo;
    private final SecretKey secretKey;
    private final SupportedCipherDetails cipherDetails;
    private final Class<WRAPPED> wrappedMultipartClass;

    public EncryptedMultipartUploaSerializationHelper(Kryo kryo, SecretKey secretKey, SupportedCipherDetails cipherDetails, Class<WRAPPED> wrappedMultipartClass) {
        this.kryo = kryo;
        this.secretKey = secretKey;
        this.wrappedMultipartClass = wrappedMultipartClass;
        this.cipherDetails = cipherDetails;
        this.registerClasses();
    }

    private void registerClasses() {
        this.kryo.register(EncryptedMultipartUpload.class, new EncryptedMultipartSerializer<WRAPPED>(this.kryo, EncryptedMultipartUpload.class, this.wrappedMultipartClass, this.secretKey));
    }

    public byte[] serialize(EncryptedMultipartUpload<WRAPPED> upload) {
        byte[] cipherText;
        byte[] serializedData;
        Cipher cipher = this.cipherDetails.getCipher();
        byte[] iv = this.cipherDetails.generateIv();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Writing IV: {}", (Object)Hex.toHexString((byte[])iv));
        }
        try {
            cipher.init(1, (Key)this.secretKey, this.cipherDetails.getEncryptionParameterSpec(iv));
        }
        catch (GeneralSecurityException e) {
            String msg = String.format("Unable to initialize cipher [%s]", this.cipherDetails.getCipherId());
            throw new MantaClientEncryptionException(msg, (Throwable)e);
        }
        int outputBufferSize = 8192;
        int maxBufferSize = 16384;
        try (ByteBufferOutput output = new ByteBufferOutput(8192, 16384);){
            output.writeVarInt(1, true);
            this.kryo.writeClassAndObject((Output)output, upload);
            output.flush();
            serializedData = output.toBytes();
        }
        try {
            cipherText = cipher.doFinal(serializedData);
        }
        catch (GeneralSecurityException e) {
            String msg = "Error encrypting serialized data";
            throw new MantaClientEncryptionException(msg, (Throwable)e);
        }
        if (!this.cipherDetails.isAEADCipher()) {
            HMac hmac = this.cipherDetails.getAuthenticationHmac();
            hmac.update(iv, 0, iv.length);
            hmac.update(cipherText, 0, cipherText.length);
            byte[] checksum = new byte[hmac.getMacSize()];
            hmac.doFinal(checksum, 0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Writing HMAC: {}", (Object)Hex.toHexString((byte[])checksum));
            }
            byte[] hmacId = new byte[16];
            String hmacIdString = SupportedHmacsLookupMap.hmacNameFromInstance((HMac)hmac);
            byte[] hmacIdStringBytes = hmacIdString.getBytes(StandardCharsets.US_ASCII);
            System.arraycopy(hmacIdStringBytes, 0, hmacId, 0, hmacIdStringBytes.length);
            return EncryptedMultipartUploaSerializationHelper.addAll(iv, cipherText, checksum, hmacId);
        }
        return EncryptedMultipartUploaSerializationHelper.addAll(iv, cipherText);
    }

    public EncryptedMultipartUpload<WRAPPED> deserialize(byte[] serializedData) {
        EncryptedMultipartUpload upload;
        byte[] plaintext;
        byte[] cipherText;
        byte[] iv = Arrays.copyOf((byte[])serializedData, (int)this.cipherDetails.getIVLengthInBytes());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reading IV: {}", (Object)Hex.toHexString((byte[])iv));
        }
        Cipher cipher = this.cipherDetails.getCipher();
        try {
            cipher.init(2, (Key)this.secretKey, this.cipherDetails.getEncryptionParameterSpec(iv));
        }
        catch (GeneralSecurityException e) {
            String msg = String.format("Unable to initialize cipher [%s]", this.cipherDetails.getCipherId());
            throw new MantaClientEncryptionException(msg, (Throwable)e);
        }
        if (this.cipherDetails.isAEADCipher()) {
            cipherText = this.extractCipherText(serializedData, iv.length, null);
        } else {
            Supplier hmacSupplier;
            byte[] hmacIdBytes = Arrays.copyOfRange((byte[])serializedData, (int)(serializedData.length - 16), (int)serializedData.length);
            String hmacId = new String(hmacIdBytes, StandardCharsets.US_ASCII).trim();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Verifying checksum with [{}]", (Object)hmacId);
            }
            if ((hmacSupplier = (Supplier)SupportedHmacsLookupMap.INSTANCE.get((Object)hmacId)) == null) {
                String msg = String.format("Unknown HMAC: [%s]", hmacId);
                throw new MantaClientEncryptionException(msg);
            }
            HMac hmac = (HMac)hmacSupplier.get();
            int hmacLength = hmac.getMacSize();
            cipherText = this.extractCipherText(serializedData, iv.length, hmacLength);
            hmac.update(iv, 0, iv.length);
            hmac.update(cipherText, 0, cipherText.length);
            byte[] calculated = new byte[hmacLength];
            hmac.doFinal(calculated, 0);
            byte[] expected = Arrays.copyOfRange((byte[])serializedData, (int)(serializedData.length - hmacLength - 16), (int)(serializedData.length - 16));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Expected HMAC:   {}", (Object)Hex.toHexString((byte[])expected));
                LOGGER.debug("Calculated HMAC: {}", (Object)Hex.toHexString((byte[])calculated));
            }
            if (!Arrays.areEqual((byte[])calculated, (byte[])expected)) {
                String msg = "Serialization data ciphertext failed cryptographic authentication";
                MantaClientEncryptionCiphertextAuthenticationException e = new MantaClientEncryptionCiphertextAuthenticationException(msg);
                e.setContextValue("expected", (Object)Hex.toHexString((byte[])expected));
                e.setContextValue("calculated", (Object)Hex.toHexString((byte[])calculated));
                throw e;
            }
        }
        try {
            plaintext = cipher.doFinal(cipherText);
        }
        catch (GeneralSecurityException e) {
            String msg = "Error decrypting serialized object data";
            throw new MantaClientEncryptionException(msg, (Throwable)e);
        }
        try (Input input = new Input(plaintext);){
            int serializationVersion = input.readVarInt(true);
            if (serializationVersion != 1) {
                LOGGER.warn("Deserialized version [%d] is different than serialization version [%d", (Object)serializationVersion, (Object)1);
            }
            upload = (EncryptedMultipartUpload)this.kryo.readClassAndObject(input);
        }
        return upload;
    }

    private byte[] extractCipherText(byte[] serializedData, int ivLength, Integer hmacLength) {
        if (hmacLength == null) {
            return Arrays.copyOfRange((byte[])serializedData, (int)ivLength, (int)serializedData.length);
        }
        return Arrays.copyOfRange((byte[])serializedData, (int)ivLength, (int)(serializedData.length - hmacLength - 16));
    }

    static byte[] addAll(byte[] ... byteArrays) {
        int joinedArraySize = 0;
        for (byte[] array : byteArrays) {
            if (array == null) continue;
            joinedArraySize += array.length;
        }
        byte[] joinedArray = new byte[joinedArraySize];
        int position = 0;
        for (byte[] array : byteArrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, joinedArray, position, array.length);
            position += array.length;
        }
        return joinedArray;
    }
}

