/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.joyent.manta.serialization.AbstractManualSerializer;
import com.joyent.manta.serialization.ReflectionUtils;
import com.twmacinta.util.FastMD5Digest;
import com.twmacinta.util.MD5;
import java.lang.reflect.Field;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.EncodableDigest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;

public class HmacSerializer
extends AbstractManualSerializer<HMac> {
    private final Field ipadStateField = this.captureField("ipadState");
    private final Field opadStateField = this.captureField("opadState");

    public HmacSerializer(Kryo kryo) {
        super(HMac.class, false);
        this.registerClasses(kryo);
    }

    private void registerClasses(Kryo kryo) {
        kryo.register(HMac.class);
        kryo.register(FastMD5Digest.class);
        kryo.register(MD5.class);
        Class<?> md5StateClass = ReflectionUtils.findClass("com.twmacinta.util.MD5State");
        kryo.register(md5StateClass, (Serializer)new CompatibleFieldSerializer(kryo, md5StateClass));
        kryo.register(MD5Digest.class);
        kryo.register(SHA1Digest.class);
        kryo.register(SHA256Digest.class);
        kryo.register(SHA384Digest.class);
        kryo.register(SHA512Digest.class);
    }

    public void write(Kryo kryo, Output output, HMac object) {
        EncodableDigest ipadState = (EncodableDigest)ReflectionUtils.readField(this.ipadStateField, object);
        EncodableDigest opadState = (EncodableDigest)ReflectionUtils.readField(this.opadStateField, object);
        EncodableDigest digest = (EncodableDigest)object.getUnderlyingDigest();
        kryo.writeObject(output, digest.getClass());
        output.writeInt(digest.getEncodedState().length);
        output.write(digest.getEncodedState());
        output.writeInt(ipadState.getEncodedState().length);
        output.write(ipadState.getEncodedState());
        output.writeInt(opadState.getEncodedState().length);
        output.write(opadState.getEncodedState());
        output.flush();
    }

    public HMac read(Kryo kryo, Input input, Class<HMac> type) {
        Class digestClass = (Class)kryo.readObject(input, Class.class);
        byte[] digestStateBytes = input.readBytes(input.readInt());
        Digest digest = (Digest)ReflectionUtils.newInstance(digestClass, new Object[]{digestStateBytes});
        byte[] ipadStateBytes = input.readBytes(input.readInt());
        Digest ipadState = (Digest)ReflectionUtils.newInstance(digestClass, new Object[]{ipadStateBytes});
        byte[] opadStateBytes = input.readBytes(input.readInt());
        Digest opadState = (Digest)ReflectionUtils.newInstance(digestClass, new Object[]{opadStateBytes});
        HMac hmac = new HMac(digest);
        ReflectionUtils.writeField(this.ipadStateField, hmac, ipadState);
        ReflectionUtils.writeField(this.opadStateField, hmac, opadState);
        return hmac;
    }
}

