/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.joyent.manta.serialization.MantaClientSerializationException;
import com.joyent.manta.util.MantaUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Class<?> findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class not found in class path";
            MantaClientSerializationException mcse = new MantaClientSerializationException(msg, e);
            mcse.setContextValue("className", className);
            throw mcse;
        }
    }

    static Class<?> findClassOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static Field getField(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(name, "Field name must not be null");
        for (Class<?> acls = clazz; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(name);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        Field field = null;
        for (Class<?> c : clazz.getInterfaces()) {
            try {
                Field potentialField = c.getField(name);
                if (field != null) {
                    String msg = String.format("Field name [%s] on class [%s] matches field name on two or more interfaces", name, clazz);
                    throw new IllegalStateException(msg);
                }
                field = potentialField;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    static Object readField(Field field, Object object) {
        Objects.requireNonNull(field, "Field must not be null");
        Objects.requireNonNull(object, "Object must not be null");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Error reading private field from [%s] class", object.getClass().getName());
            MantaClientSerializationException mcse = new MantaClientSerializationException(msg);
            mcse.setContextValue("field", field.getName());
            mcse.setContextValue("objectClass", object.getClass());
            throw mcse;
        }
    }

    static void writeField(Field field, Object target, Object value) {
        Objects.requireNonNull(field, "Field must not be null");
        Objects.requireNonNull(target, "Target must not be null");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Unable to write value [%s] to field [%s]", value, field);
            MantaClientSerializationException mcse = new MantaClientSerializationException(msg);
            mcse.setContextValue("field", field.getName());
            mcse.setContextValue("targetClass", target.getClass());
            if (value == null) {
                mcse.setContextValue("valueClass", "null");
            } else {
                mcse.setContextValue("valueClass", value.getClass());
            }
            throw mcse;
        }
    }

    static Class<?>[] classesForObjects(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return new Class[0];
        }
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    static <R> R newInstance(Class<R> instanceClass, Object ... params) {
        Object[] actualParams = params == null ? new Object[]{} : params;
        Class<?>[] types = ReflectionUtils.classesForObjects(actualParams);
        try {
            Constructor<R> constructor = instanceClass.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return constructor.newInstance(actualParams);
        }
        catch (ReflectiveOperationException e) {
            String msg = "Error instantiating class";
            MantaClientSerializationException mcse = new MantaClientSerializationException(msg, e);
            mcse.setContextValue("instanceClass", instanceClass.getCanonicalName());
            mcse.setContextValue("params", MantaUtils.asString(types));
            throw mcse;
        }
    }
}

