/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.joyent.manta.serialization.AbstractManualSerializer;
import com.joyent.manta.serialization.MantaClientSerializationException;
import com.joyent.manta.serialization.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class SessionRefSerializer
extends AbstractManualSerializer<Object> {
    private static final Class<Object> SESSION_REF_CLASS = ReflectionUtils.findClass("sun.security.pkcs11.SessionRef");
    private static final Field ID_FIELD = ReflectionUtils.getField(SESSION_REF_CLASS, "id");
    private static final Field TOKEN_FIELD = ReflectionUtils.getField(SESSION_REF_CLASS, "token");
    private static final Field REFERENT_FIELD = ReflectionUtils.getField(SESSION_REF_CLASS, "referent");
    private static final Field QUEUE_FIELD = ReflectionUtils.getField(SESSION_REF_CLASS, "queue");
    private static final Field NEXT_FIELD = ReflectionUtils.getField(SESSION_REF_CLASS, "next");
    private static final Field DISCOVERED_FIELD = ReflectionUtils.getField(SESSION_REF_CLASS, "discovered");

    public SessionRefSerializer(Kryo kryo) {
        super(SESSION_REF_CLASS);
        this.registerClasses(kryo);
    }

    private void registerClasses(Kryo kryo) {
    }

    public void write(Kryo kryo, Output output, Object object) {
        long id = (Long)ReflectionUtils.readField(ID_FIELD, object);
        output.writeVarLong(id, true);
        kryo.writeClassAndObject(output, ReflectionUtils.readField(TOKEN_FIELD, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(REFERENT_FIELD, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(QUEUE_FIELD, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(NEXT_FIELD, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(DISCOVERED_FIELD, object));
    }

    public Object read(Kryo kryo, Input input, Class<Object> type) {
        long id = input.readVarLong(true);
        Object token = kryo.readClassAndObject(input);
        Object referent = kryo.readClassAndObject(input);
        Object queue = kryo.readClassAndObject(input);
        Object next = kryo.readClassAndObject(input);
        Object discovered = kryo.readClassAndObject(input);
        try {
            Constructor<?> constructor = SESSION_REF_CLASS.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(referent, id, token);
            ReflectionUtils.writeField(QUEUE_FIELD, instance, queue);
            ReflectionUtils.writeField(NEXT_FIELD, instance, next);
            ReflectionUtils.writeField(DISCOVERED_FIELD, instance, discovered);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            String msg = "Error instantiating class";
            MantaClientSerializationException mcse = new MantaClientSerializationException(msg, e);
            mcse.setContextValue("instanceClass", SESSION_REF_CLASS.getCanonicalName());
            throw mcse;
        }
    }
}

