/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.joyent.manta.serialization.AbstractManualSerializer;
import com.joyent.manta.serialization.ReflectionUtils;
import java.lang.reflect.Field;
import java.security.AlgorithmParameters;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.provider.symmetric.AES;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.jcajce.util.BCJcaJceHelper;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.sun.UnsafeFactoryInstantiator;

public class BaseBlockCipherSerializer<T extends BaseBlockCipher>
extends AbstractManualSerializer<T> {
    private final Field aeadParamsField;
    private final Field availableSpecsField;
    private final Field baseEngineField;
    private final Field cipherField;
    private final Field digestField;
    private final Field engineParamsField;
    private final Field engineProviderField;
    private final Field fixedIvField;
    private final Field helperField;
    private final Field ivField;
    private final Field ivLengthField;
    private final Field ivParamField;
    private final Field ivSizeField;
    private final Field keySizeInBitsField;
    private final Field modeNameField;
    private final Field baseWrapCipherAvailableSpecsField;
    private final Field paddedField;
    private final Field pbeAlgorithmField;
    private final Field pbeHashField;
    private final Field pbeIvSizeField;
    private final Field pbeKeySizeField;
    private final Field pbeSpecField;
    private final Field pbeTypeField;
    private final Field schemeField;
    private final Field wrapEngineField;
    private final Class<T> serializeClass;

    public BaseBlockCipherSerializer(Kryo kryo, Class<T> serializeClass) {
        super(serializeClass, false);
        this.registerClasses(kryo);
        this.serializeClass = serializeClass;
        this.aeadParamsField = this.captureField("aeadParams");
        this.availableSpecsField = this.captureField("availableSpecs");
        this.baseEngineField = this.captureField("baseEngine");
        this.cipherField = this.captureField("cipher");
        this.digestField = this.captureField("digest");
        this.engineParamsField = this.captureField("engineParams");
        this.engineProviderField = ReflectionUtils.getField(BaseBlockCipher.class, "engineProvider");
        this.fixedIvField = this.captureField("fixedIv");
        this.helperField = this.captureField("helper");
        this.ivField = this.captureField("iv");
        this.ivLengthField = this.captureField("ivLength");
        this.ivParamField = this.captureField("ivParam");
        this.ivSizeField = this.captureField("ivSize");
        this.keySizeInBitsField = this.captureField("keySizeInBits");
        this.modeNameField = this.captureField("modeName");
        this.baseWrapCipherAvailableSpecsField = ReflectionUtils.getField(BaseWrapCipher.class, "availableSpecs");
        this.paddedField = this.captureField("padded");
        this.pbeAlgorithmField = this.captureField("pbeAlgorithm");
        this.pbeHashField = this.captureField("pbeHash");
        this.pbeIvSizeField = this.captureField("pbeIvSize");
        this.pbeKeySizeField = this.captureField("pbeKeySize");
        this.pbeSpecField = this.captureField("pbeSpec");
        this.pbeTypeField = this.captureField("pbeType");
        this.schemeField = this.captureField("scheme");
        this.wrapEngineField = this.captureField("wrapEngine");
    }

    private void registerClasses(Kryo kryo) {
        Class<?> bufferedGenericBlockCipherClass = ReflectionUtils.findClass("org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher$BufferedGenericBlockCipher");
        Class<?> paddedBufferedBlockCipherClass = ReflectionUtils.findClass("org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher");
        Class<?> aeadGenericBlockCipherClass = ReflectionUtils.findClass("org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher$AEADGenericBlockCipher");
        kryo.register(AESFastEngine.class, (Serializer)new CompatibleFieldSerializer(kryo, AESFastEngine.class));
        kryo.register(AESEngine.class, (Serializer)new CompatibleFieldSerializer(kryo, AESEngine.class));
        kryo.register(BufferedBlockCipher.class);
        kryo.register(bufferedGenericBlockCipherClass, (Serializer)new CompatibleFieldSerializer(kryo, bufferedGenericBlockCipherClass)).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(bufferedGenericBlockCipherClass));
        kryo.register(SICBlockCipher.class).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(SICBlockCipher.class));
        kryo.register(AlgorithmParameters.class);
        kryo.register(BCJcaJceHelper.class);
        kryo.register(ParametersWithIV.class).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(ParametersWithIV.class));
        kryo.register(KeyParameter.class).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(KeyParameter.class));
        kryo.register(paddedBufferedBlockCipherClass).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(paddedBufferedBlockCipherClass));
        kryo.register(CBCBlockCipher.class).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(CBCBlockCipher.class));
        kryo.register(AEADParameters.class, (Serializer)new CompatibleFieldSerializer(kryo, AEADParameters.class)).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(AEADParameters.class));
        kryo.register(aeadGenericBlockCipherClass, (Serializer)new CompatibleFieldSerializer(kryo, aeadGenericBlockCipherClass)).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(aeadGenericBlockCipherClass));
        kryo.register(GCMBlockCipher.class, (Serializer)new CompatibleFieldSerializer(kryo, GCMBlockCipher.class)).setInstantiator((ObjectInstantiator)new UnsafeFactoryInstantiator(GCMBlockCipher.class));
        kryo.register(RC2ParameterSpec.class);
        kryo.register(RC5ParameterSpec.class);
        kryo.register(GCMParameterSpec.class);
        kryo.register(IvParameterSpec.class);
        kryo.register(PBEParameterSpec.class);
        kryo.register(GOST28147ParameterSpec.class);
    }

    public void write(Kryo kryo, Output output, T object) {
        kryo.writeObjectOrNull(output, ReflectionUtils.readField(this.aeadParamsField, object), AEADParameters.class);
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.availableSpecsField, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.baseEngineField, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.cipherField, object));
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.digestField, object)).intValue(), true);
        if (ReflectionUtils.readField(this.engineParamsField, object) != null) {
            throw new UnsupportedOperationException("We don't support serializing the engineParams field");
        }
        output.writeBoolean(((Boolean)ReflectionUtils.readField(this.fixedIvField, object)).booleanValue());
        byte[] iv = (byte[])ReflectionUtils.readField(this.ivField, object);
        kryo.writeObjectOrNull(output, (Object)iv, byte[].class);
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.ivLengthField, object)).intValue(), true);
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.ivParamField, object));
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.ivSizeField, object)).intValue(), true);
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.keySizeInBitsField, object)).intValue(), true);
        output.writeString((String)ReflectionUtils.readField(this.modeNameField, object));
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.baseWrapCipherAvailableSpecsField, object));
        output.writeBoolean(((Boolean)ReflectionUtils.readField(this.paddedField, object)).booleanValue());
        output.writeString((String)ReflectionUtils.readField(this.pbeAlgorithmField, object));
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.pbeHashField, object)).intValue(), true);
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.pbeIvSizeField, object)).intValue(), true);
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.pbeKeySizeField, object)).intValue(), true);
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.pbeSpecField, object));
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.pbeTypeField, object)).intValue(), true);
        output.writeVarInt(((Integer)ReflectionUtils.readField(this.schemeField, object)).intValue(), false);
        kryo.writeClassAndObject(output, ReflectionUtils.readField(this.wrapEngineField, object));
        output.flush();
    }

    public T read(Kryo kryo, Input input, Class<T> type) {
        AEADParameters aeadParams = (AEADParameters)kryo.readObjectOrNull(input, AEADParameters.class);
        Object availableSpecs = kryo.readClassAndObject(input);
        Object baseEngine = kryo.readClassAndObject(input);
        Object cipher = kryo.readClassAndObject(input);
        int digest = input.readVarInt(true);
        BlockCipherProvider engineProvider = this.buildEngineProvider();
        boolean fixedIv = input.readBoolean();
        BCJcaJceHelper helper = new BCJcaJceHelper();
        byte[] iv = (byte[])kryo.readObjectOrNull(input, byte[].class);
        int ivLength = input.readVarInt(true);
        Object ivParam = kryo.readClassAndObject(input);
        int ivSize = input.readVarInt(true);
        int keySizeInBits = input.readVarInt(true);
        String modeName = input.readString();
        Object baseWrapCipherAvailableSpecs = kryo.readClassAndObject(input);
        boolean padded = input.readBoolean();
        String pbeAlgorithm = input.readString();
        int pbeHash = input.readVarInt(true);
        int pbeIvSize = input.readVarInt(true);
        int pbeKeySize = input.readVarInt(true);
        Object pbeSpec = kryo.readClassAndObject(input);
        int pbeType = input.readVarInt(true);
        int scheme = input.readVarInt(false);
        Object wrapEngine = kryo.readClassAndObject(input);
        BaseBlockCipher instance = (BaseBlockCipher)this.newInstance(new Object[0]);
        ReflectionUtils.writeField(this.aeadParamsField, instance, aeadParams);
        ReflectionUtils.writeField(this.availableSpecsField, instance, availableSpecs);
        ReflectionUtils.writeField(this.baseEngineField, instance, baseEngine);
        ReflectionUtils.writeField(this.cipherField, instance, cipher);
        ReflectionUtils.writeField(this.digestField, instance, digest);
        ReflectionUtils.writeField(this.engineProviderField, instance, engineProvider);
        ReflectionUtils.writeField(this.fixedIvField, instance, fixedIv);
        ReflectionUtils.writeField(this.helperField, instance, helper);
        ReflectionUtils.writeField(this.ivField, instance, iv);
        ReflectionUtils.writeField(this.ivLengthField, instance, ivLength);
        ReflectionUtils.writeField(this.ivParamField, instance, ivParam);
        ReflectionUtils.writeField(this.ivSizeField, instance, ivSize);
        ReflectionUtils.writeField(this.keySizeInBitsField, instance, keySizeInBits);
        ReflectionUtils.writeField(this.modeNameField, instance, modeName);
        ReflectionUtils.writeField(this.baseWrapCipherAvailableSpecsField, instance, baseWrapCipherAvailableSpecs);
        ReflectionUtils.writeField(this.paddedField, instance, padded);
        ReflectionUtils.writeField(this.pbeAlgorithmField, instance, pbeAlgorithm);
        ReflectionUtils.writeField(this.pbeHashField, instance, pbeHash);
        ReflectionUtils.writeField(this.pbeIvSizeField, instance, pbeIvSize);
        ReflectionUtils.writeField(this.pbeKeySizeField, instance, pbeKeySize);
        ReflectionUtils.writeField(this.pbeSpecField, instance, pbeSpec);
        ReflectionUtils.writeField(this.pbeTypeField, instance, pbeType);
        ReflectionUtils.writeField(this.schemeField, instance, scheme);
        ReflectionUtils.writeField(this.wrapEngineField, instance, wrapEngine);
        return (T)instance;
    }

    private BlockCipherProvider buildEngineProvider() {
        AES.ECB baseBlockCipher;
        String name;
        switch (name = this.serializeClass.getSimpleName()) {
            case "ECB": {
                baseBlockCipher = new AES.ECB();
                break;
            }
            case "CBC": {
                baseBlockCipher = new AES.CBC();
                break;
            }
            case "CFB": {
                baseBlockCipher = new AES.CFB();
                break;
            }
            case "OFB": {
                baseBlockCipher = new AES.OFB();
                break;
            }
            case "GCM": {
                baseBlockCipher = new AES.GCM();
                break;
            }
            case "CCM": {
                baseBlockCipher = new AES.CCM();
                break;
            }
            default: {
                String msg = String.format("Can't generate engine provider because BaseBlockCipher is an unknown implementation: %s", this.serializeClass.getName());
                throw new UnsupportedOperationException(msg);
            }
        }
        return (BlockCipherProvider)ReflectionUtils.readField(this.engineProviderField, baseBlockCipher);
    }
}

