/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountRegenerateKeyParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ErrorResponseException;
import com.microsoft.azure.management.cosmosdb.FailoverPolicies;
import com.microsoft.azure.management.cosmosdb.FailoverPolicy;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.RegionForOnlineOffline;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.UsageInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseAccountsInner
implements InnerSupportsGet<DatabaseAccountGetResultsInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DatabaseAccountGetResultsInner> {
    private DatabaseAccountsService service;
    private CosmosDBImpl client;

    public DatabaseAccountsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (DatabaseAccountsService)retrofit.create(DatabaseAccountsService.class);
        this.client = client;
    }

    public DatabaseAccountGetResultsInner getByResourceGroup(String resourceGroupName, String accountName) {
        return (DatabaseAccountGetResultsInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountGetResultsInner> getByResourceGroupAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountGetResultsInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountGetResultsInner>, DatabaseAccountGetResultsInner>(){

            public DatabaseAccountGetResultsInner call(ServiceResponse<DatabaseAccountGetResultsInner> response) {
                return (DatabaseAccountGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountGetResultsInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountGetResultsInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountGetResultsInner update(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters) {
        return (DatabaseAccountGetResultsInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountGetResultsInner> updateAsync(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters, ServiceCallback<DatabaseAccountGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountGetResultsInner> updateAsync(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountGetResultsInner>, DatabaseAccountGetResultsInner>(){

            public DatabaseAccountGetResultsInner call(ServiceResponse<DatabaseAccountGetResultsInner> response) {
                return (DatabaseAccountGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate((Object)updateParameters);
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", updateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountGetResultsInner>(){}.getType());
    }

    public DatabaseAccountGetResultsInner beginUpdate(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters) {
        return (DatabaseAccountGetResultsInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountGetResultsInner> beginUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters, ServiceCallback<DatabaseAccountGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, updateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountGetResultsInner> beginUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, updateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountGetResultsInner>, DatabaseAccountGetResultsInner>(){

            public DatabaseAccountGetResultsInner call(ServiceResponse<DatabaseAccountGetResultsInner> response) {
                return (DatabaseAccountGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountUpdateParameters updateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (updateParameters == null) {
            throw new IllegalArgumentException("Parameter updateParameters is required and cannot be null.");
        }
        Validator.validate((Object)updateParameters);
        String apiVersion = "2019-08-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", updateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountGetResultsInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountGetResultsInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountGetResultsInner createOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return (DatabaseAccountGetResultsInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<DatabaseAccountGetResultsInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters, ServiceCallback<DatabaseAccountGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountGetResultsInner> createOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountGetResultsInner>, DatabaseAccountGetResultsInner>(){

            public DatabaseAccountGetResultsInner call(ServiceResponse<DatabaseAccountGetResultsInner> response) {
                return (DatabaseAccountGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DatabaseAccountGetResultsInner>(){}.getType());
    }

    public DatabaseAccountGetResultsInner beginCreateOrUpdate(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return (DatabaseAccountGetResultsInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseAccountGetResultsInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters, ServiceCallback<DatabaseAccountGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters), serviceCallback);
    }

    public Observable<DatabaseAccountGetResultsInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, createUpdateParameters).map((Func1)new Func1<ServiceResponse<DatabaseAccountGetResultsInner>, DatabaseAccountGetResultsInner>(){

            public DatabaseAccountGetResultsInner call(ServiceResponse<DatabaseAccountGetResultsInner> response) {
                return (DatabaseAccountGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, DatabaseAccountCreateUpdateParameters createUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (createUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", createUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountGetResultsInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountGetResultsInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        ((ServiceResponse)this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> failoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        return this.failoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        String apiVersion = "2019-08-01";
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        Observable<Response<ResponseBody>> observable = this.service.failoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), failoverParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginFailoverPriorityChange(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        ((ServiceResponse)this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies), serviceCallback);
    }

    public Observable<Void> beginFailoverPriorityChangeAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        return this.beginFailoverPriorityChangeWithServiceResponseAsync(resourceGroupName, accountName, failoverPolicies).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverPriorityChangeWithServiceResponseAsync(String resourceGroupName, String accountName, List<FailoverPolicy> failoverPolicies) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (failoverPolicies == null) {
            throw new IllegalArgumentException("Parameter failoverPolicies is required and cannot be null.");
        }
        Validator.validate(failoverPolicies);
        String apiVersion = "2019-08-01";
        FailoverPolicies failoverParameters = new FailoverPolicies();
        failoverParameters.withFailoverPolicies(failoverPolicies);
        return this.service.beginFailoverPriorityChange(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), failoverParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginFailoverPriorityChangeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverPriorityChangeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountGetResultsInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountGetResultsInner>(page){

            public Page<DatabaseAccountGetResultsInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountGetResultsInner>> listAsync(ServiceCallback<List<DatabaseAccountGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<DatabaseAccountGetResultsInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<DatabaseAccountGetResultsInner>>, Page<DatabaseAccountGetResultsInner>>(){

            public Page<DatabaseAccountGetResultsInner> call(ServiceResponse<List<DatabaseAccountGetResultsInner>> response) {
                PageImpl<DatabaseAccountGetResultsInner> page = new PageImpl<DatabaseAccountGetResultsInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountGetResultsInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.list(this.client.subscriptionId(), "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountGetResultsInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DatabaseAccountGetResultsInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<DatabaseAccountGetResultsInner>(page){

            public Page<DatabaseAccountGetResultsInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<DatabaseAccountGetResultsInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<DatabaseAccountGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<DatabaseAccountGetResultsInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<DatabaseAccountGetResultsInner>>, Page<DatabaseAccountGetResultsInner>>(){

            public Page<DatabaseAccountGetResultsInner> call(ServiceResponse<List<DatabaseAccountGetResultsInner>> response) {
                PageImpl<DatabaseAccountGetResultsInner> page = new PageImpl<DatabaseAccountGetResultsInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<DatabaseAccountGetResultsInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DatabaseAccountGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<DatabaseAccountGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DatabaseAccountGetResultsInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DatabaseAccountGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListKeysResultInner listKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListKeysResultInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListKeysResultInner>, DatabaseAccountListKeysResultInner>(){

            public DatabaseAccountListKeysResultInner call(ServiceResponse<DatabaseAccountListKeysResultInner> response) {
                return (DatabaseAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listKeys(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListKeysResultInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListConnectionStringsResultInner listConnectionStrings(String resourceGroupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResultInner)((ServiceResponse)this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListConnectionStringsResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsAsync(String resourceGroupName, String accountName) {
        return this.listConnectionStringsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>, DatabaseAccountListConnectionStringsResultInner>(){

            public DatabaseAccountListConnectionStringsResultInner call(ServiceResponse<DatabaseAccountListConnectionStringsResultInner> response) {
                return (DatabaseAccountListConnectionStringsResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> listConnectionStringsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listConnectionStrings(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListConnectionStringsResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listConnectionStringsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListConnectionStringsResultInner> listConnectionStringsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListConnectionStringsResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void offlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last()).body();
    }

    public ServiceFuture<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> offlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.offlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> offlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        Observable<Response<ResponseBody>> observable = this.service.offlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginOfflineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> beginOfflineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.beginOfflineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginOfflineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        RegionForOnlineOffline regionParameterForOffline = new RegionForOnlineOffline();
        regionParameterForOffline.withRegion(region);
        return this.service.beginOfflineRegion(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), regionParameterForOffline, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginOfflineRegionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginOfflineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void onlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().last()).body();
    }

    public ServiceFuture<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> onlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.onlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> onlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        Observable<Response<ResponseBody>> observable = this.service.onlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginOnlineRegion(String resourceGroupName, String accountName, String region) {
        ((ServiceResponse)this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region), serviceCallback);
    }

    public Observable<Void> beginOnlineRegionAsync(String resourceGroupName, String accountName, String region) {
        return this.beginOnlineRegionWithServiceResponseAsync(resourceGroupName, accountName, region).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginOnlineRegionWithServiceResponseAsync(String resourceGroupName, String accountName, String region) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        RegionForOnlineOffline regionParameterForOnline = new RegionForOnlineOffline();
        regionParameterForOnline.withRegion(region);
        return this.service.beginOnlineRegion(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), regionParameterForOnline, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginOnlineRegionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginOnlineRegionDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner getReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.getReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> getReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.getReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> getReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseAccountListReadOnlyKeysResultInner listReadOnlyKeys(String resourceGroupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResultInner)((ServiceResponse)this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName, ServiceCallback<DatabaseAccountListReadOnlyKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysAsync(String resourceGroupName, String accountName) {
        return this.listReadOnlyKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>, DatabaseAccountListReadOnlyKeysResultInner>(){

            public DatabaseAccountListReadOnlyKeysResultInner call(ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> response) {
                return (DatabaseAccountListReadOnlyKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> listReadOnlyKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listReadOnlyKeys(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>>>(){

            public Observable<ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.listReadOnlyKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseAccountListReadOnlyKeysResultInner> listReadOnlyKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseAccountListReadOnlyKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void regenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().last()).body();
    }

    public ServiceFuture<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> regenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        Observable<Response<ResponseBody>> observable = this.service.regenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRegenerateKey(String resourceGroupName, String accountName, KeyKind keyKind) {
        ((ServiceResponse)this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind), serviceCallback);
    }

    public Observable<Void> beginRegenerateKeyAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        return this.beginRegenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyKind).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRegenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, KeyKind keyKind) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        DatabaseAccountRegenerateKeyParameters keyToRegenerate = new DatabaseAccountRegenerateKeyParameters();
        keyToRegenerate.withKeyKind(keyKind);
        return this.service.beginRegenerateKey(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), keyToRegenerate, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.beginRegenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRegenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public boolean checkNameExists(String accountName) {
        return (Boolean)((ServiceResponse)this.checkNameExistsWithServiceResponseAsync(accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkNameExistsAsync(String accountName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameExistsWithServiceResponseAsync(accountName), serviceCallback);
    }

    public Observable<Boolean> checkNameExistsAsync(String accountName) {
        return this.checkNameExistsWithServiceResponseAsync(accountName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkNameExistsWithServiceResponseAsync(String accountName) {
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.checkNameExists(accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = DatabaseAccountsInner.this.checkNameExistsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkNameExistsDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public List<MetricInner> listMetrics(String resourceGroupName, String accountName, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter, ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, filter).map((Func1)new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>(){

            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>(){

            public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        String filter = null;
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName, String filter) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String filter) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, filter).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName) {
        return this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMetricDefinitions(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseAccountsInner.this.listMetricDefinitionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Body DatabaseAccountCreateUpdateParameters var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts failoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> failoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginFailoverPriorityChange"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange")
        public Observable<Response<ResponseBody>> beginFailoverPriorityChange(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body FailoverPolicies var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listConnectionStrings"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listConnectionStrings")
        public Observable<Response<ResponseBody>> listConnectionStrings(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts offlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        public Observable<Response<ResponseBody>> offlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOfflineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion")
        public Observable<Response<ResponseBody>> beginOfflineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts onlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        public Observable<Response<ResponseBody>> onlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginOnlineRegion"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion")
        public Observable<Response<ResponseBody>> beginOnlineRegion(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegionForOnlineOffline var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts getReadOnlyKeys"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> getReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listReadOnlyKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys")
        public Observable<Response<ResponseBody>> listReadOnlyKeys(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts beginRegenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> beginRegenerateKey(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body DatabaseAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts checkNameExists"})
        @HEAD(value="providers/Microsoft.DocumentDB/databaseAccountNames/{accountName}")
        public Observable<Response<Void>> checkNameExists(@Path(value="accountName") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listUsages"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/usages")
        public Observable<Response<ResponseBody>> listUsages(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="$filter") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.DatabaseAccounts listMetricDefinitions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metricDefinitions")
        public Observable<Response<ResponseBody>> listMetricDefinitions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

