/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.migration;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.subscription.alignment.MigrationPlanAligner;
import com.ning.billing.subscription.alignment.TimedMigration;
import com.ning.billing.subscription.api.SubscriptionApiBase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.migration.AccountMigrationData;
import com.ning.billing.subscription.api.migration.SubscriptionBaseMigrationApi;
import com.ning.billing.subscription.api.migration.SubscriptionBaseMigrationApiException;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEventData;
import com.ning.billing.subscription.events.user.ApiEvent;
import com.ning.billing.subscription.events.user.ApiEventBuilder;
import com.ning.billing.subscription.events.user.ApiEventCancel;
import com.ning.billing.subscription.events.user.ApiEventChange;
import com.ning.billing.subscription.events.user.ApiEventMigrateBilling;
import com.ning.billing.subscription.events.user.ApiEventMigrateSubscription;
import com.ning.billing.subscription.events.user.ApiEventType;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.InternalCallContextFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionBaseMigrationApi
extends SubscriptionApiBase
implements SubscriptionBaseMigrationApi {
    private final MigrationPlanAligner migrationAligner;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public DefaultSubscriptionBaseMigrationApi(MigrationPlanAligner migrationAligner, SubscriptionBaseApiService apiService, CatalogService catalogService, SubscriptionDao dao, Clock clock, InternalCallContextFactory internalCallContextFactory) {
        super(dao, apiService, clock, catalogService);
        this.migrationAligner = migrationAligner;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public void migrate(SubscriptionBaseMigrationApi.AccountMigration toBeMigrated, CallContext context) throws SubscriptionBaseMigrationApiException {
        AccountMigrationData accountMigrationData = this.createAccountMigrationData(toBeMigrated, context);
        this.dao.migrate(toBeMigrated.getAccountKey(), accountMigrationData, this.internalCallContextFactory.createInternalCallContext(toBeMigrated.getAccountKey(), context));
    }

    private AccountMigrationData createAccountMigrationData(SubscriptionBaseMigrationApi.AccountMigration toBeMigrated, CallContext context) throws SubscriptionBaseMigrationApiException {
        UUID accountId = toBeMigrated.getAccountKey();
        DateTime now = this.clock.getUTCNow();
        LinkedList<AccountMigrationData.BundleMigrationData> accountBundleData = new LinkedList<AccountMigrationData.BundleMigrationData>();
        for (SubscriptionBaseMigrationApi.BundleMigration curBundle : toBeMigrated.getBundles()) {
            DefaultSubscriptionBaseBundle bundleData = new DefaultSubscriptionBaseBundle(curBundle.getBundleKey(), accountId, this.clock.getUTCNow());
            LinkedList<AccountMigrationData.SubscriptionMigrationData> bundleSubscriptionData = new LinkedList<AccountMigrationData.SubscriptionMigrationData>();
            ArrayList sortedSubscriptions = Lists.newArrayList((Object[])curBundle.getSubscriptions());
            Collections.sort(sortedSubscriptions, new Comparator<SubscriptionBaseMigrationApi.SubscriptionMigration>(){

                @Override
                public int compare(SubscriptionBaseMigrationApi.SubscriptionMigration o1, SubscriptionBaseMigrationApi.SubscriptionMigration o2) {
                    if (o1.getCategory().equals((Object)o2.getCategory())) {
                        return o1.getSubscriptionCases()[0].getEffectiveDate().compareTo((ReadableInstant)o2.getSubscriptionCases()[0].getEffectiveDate());
                    }
                    if (!o1.getCategory().name().equalsIgnoreCase("ADD_ON")) {
                        return -1;
                    }
                    if (o1.getCategory().name().equalsIgnoreCase("ADD_ON")) {
                        return 1;
                    }
                    return 0;
                }
            });
            DateTime bundleStartDate = null;
            for (SubscriptionBaseMigrationApi.SubscriptionMigration curSub : sortedSubscriptions) {
                AccountMigrationData.SubscriptionMigrationData data = null;
                if (bundleStartDate == null) {
                    data = this.createInitialSubscription(bundleData.getId(), curSub.getCategory(), curSub.getSubscriptionCases(), now, curSub.getChargedThroughDate(), context);
                    bundleStartDate = data.getInitialEvents().get(0).getEffectiveDate();
                } else {
                    data = this.createSubscriptionMigrationDataWithBundleDate(bundleData.getId(), curSub.getCategory(), curSub.getSubscriptionCases(), now, bundleStartDate, curSub.getChargedThroughDate(), context);
                }
                if (data == null) continue;
                bundleSubscriptionData.add(data);
            }
            AccountMigrationData.BundleMigrationData bundleMigrationData = new AccountMigrationData.BundleMigrationData(bundleData, bundleSubscriptionData);
            accountBundleData.add(bundleMigrationData);
        }
        return new AccountMigrationData(accountBundleData);
    }

    private AccountMigrationData.SubscriptionMigrationData createInitialSubscription(UUID bundleId, ProductCategory productCategory, SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input, DateTime now, DateTime ctd, CallContext context) throws SubscriptionBaseMigrationApiException {
        TimedMigration[] events = this.migrationAligner.getEventsMigration(input, now);
        DateTime migrationStartDate = events[0].getEventTime();
        List<SubscriptionBaseEvent> emptyEvents = Collections.emptyList();
        DefaultSubscriptionBase defaultSubscriptionBase = this.createSubscriptionForApiUse(new SubscriptionBuilder().setId(UUID.randomUUID()).setBundleId(bundleId).setCategory(productCategory).setBundleStartDate(migrationStartDate).setAlignStartDate(migrationStartDate), emptyEvents);
        return new AccountMigrationData.SubscriptionMigrationData(defaultSubscriptionBase, this.toEvents(defaultSubscriptionBase, now, ctd, events, context), ctd);
    }

    private AccountMigrationData.SubscriptionMigrationData createSubscriptionMigrationDataWithBundleDate(UUID bundleId, ProductCategory productCategory, SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input, DateTime now, DateTime bundleStartDate, DateTime ctd, CallContext context) throws SubscriptionBaseMigrationApiException {
        TimedMigration[] events = this.migrationAligner.getEventsMigration(input, now);
        DateTime migrationStartDate = events[0].getEventTime();
        List<SubscriptionBaseEvent> emptyEvents = Collections.emptyList();
        DefaultSubscriptionBase defaultSubscriptionBase = this.createSubscriptionForApiUse(new SubscriptionBuilder().setId(UUID.randomUUID()).setBundleId(bundleId).setCategory(productCategory).setBundleStartDate(bundleStartDate).setAlignStartDate(migrationStartDate), emptyEvents);
        return new AccountMigrationData.SubscriptionMigrationData(defaultSubscriptionBase, this.toEvents(defaultSubscriptionBase, now, ctd, events, context), ctd);
    }

    private List<SubscriptionBaseEvent> toEvents(DefaultSubscriptionBase defaultSubscriptionBase, DateTime now, DateTime ctd, TimedMigration[] migrationEvents, CallContext context) {
        if (ctd == null) {
            throw new SubscriptionBaseError(String.format("Could not create migration billing event ctd = %s", ctd));
        }
        ArrayList<SubscriptionBaseEvent> events = new ArrayList<SubscriptionBaseEvent>(migrationEvents.length);
        ApiEventMigrateBilling apiEventMigrateBilling = null;
        DateTime nextEventDate = null;
        boolean isCancelledSubscriptionPriorOrAtCTD = false;
        for (TimedMigration cur : migrationEvents) {
            ApiEventBuilder builder = ((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(defaultSubscriptionBase.getId())).setEventPlan(cur.getPlan() != null ? cur.getPlan().getName() : null).setEventPlanPhase(cur.getPhase() != null ? cur.getPhase().getName() : null).setEventPriceList(cur.getPriceList()).setActiveVersion(defaultSubscriptionBase.getActiveVersion())).setEffectiveDate(cur.getEventTime())).setProcessedDate(now)).setRequestedDate(now)).setFromDisk(true);
            if (cur.getEventType() == SubscriptionBaseEvent.EventType.PHASE) {
                nextEventDate = nextEventDate != null && nextEventDate.compareTo((ReadableInstant)cur.getEventTime()) < 0 ? nextEventDate : cur.getEventTime();
                PhaseEvent nextPhaseEvent = PhaseEventData.createNextPhaseEvent(cur.getPhase().getName(), defaultSubscriptionBase, now, cur.getEventTime());
                events.add(nextPhaseEvent);
            } else if (cur.getEventType() == SubscriptionBaseEvent.EventType.API_USER) {
                switch (cur.getApiEventType()) {
                    case MIGRATE_ENTITLEMENT: {
                        ApiEventMigrateSubscription creationEvent = new ApiEventMigrateSubscription(builder);
                        events.add(creationEvent);
                        break;
                    }
                    case CHANGE: {
                        nextEventDate = nextEventDate != null && nextEventDate.compareTo((ReadableInstant)cur.getEventTime()) < 0 ? nextEventDate : cur.getEventTime();
                        events.add(new ApiEventChange(builder));
                        break;
                    }
                    case CANCEL: {
                        isCancelledSubscriptionPriorOrAtCTD = !cur.getEventTime().isAfter((ReadableInstant)ctd);
                        nextEventDate = nextEventDate != null && nextEventDate.compareTo((ReadableInstant)cur.getEventTime()) < 0 ? nextEventDate : cur.getEventTime();
                        events.add(new ApiEventCancel(builder));
                        break;
                    }
                    default: {
                        throw new SubscriptionBaseError(String.format("Unexpected type of api migration event %s", new Object[]{cur.getApiEventType()}));
                    }
                }
            } else {
                throw new SubscriptionBaseError(String.format("Unexpected type of migration event %s", new Object[]{cur.getEventType()}));
            }
            if (cur.getEventTime().isAfter((ReadableInstant)ctd)) continue;
            builder.setEffectiveDate(ctd);
            builder.setUuid(UUID.randomUUID());
            apiEventMigrateBilling = new ApiEventMigrateBilling(builder);
        }
        if (apiEventMigrateBilling != null && !isCancelledSubscriptionPriorOrAtCTD) {
            events.add(apiEventMigrateBilling);
        }
        Collections.sort(events, new Comparator<SubscriptionBaseEvent>(){

            int compForApiType(SubscriptionBaseEvent o1, SubscriptionBaseEvent o2, ApiEventType type) {
                ApiEventType apiO1 = null;
                if (o1.getType() == SubscriptionBaseEvent.EventType.API_USER) {
                    apiO1 = ((ApiEvent)o1).getEventType();
                }
                ApiEventType apiO2 = null;
                if (o2.getType() == SubscriptionBaseEvent.EventType.API_USER) {
                    apiO2 = ((ApiEvent)o2).getEventType();
                }
                if (apiO1 != null && apiO1.equals((Object)type)) {
                    return -1;
                }
                if (apiO2 != null && apiO2.equals((Object)type)) {
                    return 1;
                }
                return 0;
            }

            @Override
            public int compare(SubscriptionBaseEvent o1, SubscriptionBaseEvent o2) {
                int comp = o1.getEffectiveDate().compareTo((ReadableInstant)o2.getEffectiveDate());
                if (comp == 0) {
                    comp = this.compForApiType(o1, o2, ApiEventType.MIGRATE_ENTITLEMENT);
                }
                if (comp == 0) {
                    comp = this.compForApiType(o1, o2, ApiEventType.MIGRATE_BILLING);
                }
                return comp;
            }
        });
        return events;
    }
}

