/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.timeline;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.ning.billing.ErrorCode;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.subscription.api.SubscriptionApiBase;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.timeline.BundleBaseTimeline;
import com.ning.billing.subscription.api.timeline.DefaultNewEvent;
import com.ning.billing.subscription.api.timeline.DefaultSubscriptionBaseTimeline;
import com.ning.billing.subscription.api.timeline.RepairSubscriptionLifecycleDao;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseRepairException;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseTimeline;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseTimelineApi;
import com.ning.billing.subscription.api.timeline.SubscriptionDataRepair;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.InternalCallContextFactory;
import com.ning.billing.util.callcontext.InternalTenantContext;
import com.ning.billing.util.callcontext.TenantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionBaseTimelineApi
extends SubscriptionApiBase
implements SubscriptionBaseTimelineApi {
    private final RepairSubscriptionLifecycleDao repairDao;
    private final CatalogService catalogService;
    private final InternalCallContextFactory internalCallContextFactory;
    private final AddonUtils addonUtils;
    private final SubscriptionBaseApiService repairApiService;

    @Inject
    public DefaultSubscriptionBaseTimelineApi(CatalogService catalogService, SubscriptionBaseApiService apiService, @Named(value="repair") RepairSubscriptionLifecycleDao repairDao, SubscriptionDao dao, @Named(value="repair") SubscriptionBaseApiService repairApiService, InternalCallContextFactory internalCallContextFactory, Clock clock, AddonUtils addonUtils) {
        super(dao, apiService, clock, catalogService);
        this.catalogService = catalogService;
        this.repairDao = repairDao;
        this.internalCallContextFactory = internalCallContextFactory;
        this.repairApiService = repairApiService;
        this.addonUtils = addonUtils;
    }

    public BundleBaseTimeline getBundleTimeline(SubscriptionBaseBundle bundle, TenantContext context) throws SubscriptionBaseRepairException {
        return this.getBundleTimelineInternal(bundle, bundle.getExternalKey(), context);
    }

    public BundleBaseTimeline getBundleTimeline(UUID accountId, String bundleName, TenantContext context) throws SubscriptionBaseRepairException {
        SubscriptionBaseBundle bundle = this.dao.getSubscriptionBundleFromAccountAndKey(accountId, bundleName, this.internalCallContextFactory.createInternalTenantContext(context));
        return this.getBundleTimelineInternal(bundle, bundleName + " [accountId= " + accountId.toString() + "]", context);
    }

    public BundleBaseTimeline getBundleTimeline(UUID bundleId, TenantContext context) throws SubscriptionBaseRepairException {
        SubscriptionBaseBundle bundle = this.dao.getSubscriptionBundleFromId(bundleId, this.internalCallContextFactory.createInternalTenantContext(context));
        return this.getBundleTimelineInternal(bundle, bundleId.toString(), context);
    }

    private BundleBaseTimeline getBundleTimelineInternal(SubscriptionBaseBundle bundle, String descBundle, TenantContext context) throws SubscriptionBaseRepairException {
        try {
            if (bundle == null) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_UNKNOWN_BUNDLE, new Object[]{descBundle});
            }
            List<SubscriptionDataRepair> subscriptions = this.convertToSubscriptionsDataRepair(this.dao.getSubscriptions(bundle.getId(), this.internalCallContextFactory.createInternalTenantContext(context)));
            if (subscriptions.size() == 0) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_NO_ACTIVE_SUBSCRIPTIONS, new Object[]{bundle.getId()});
            }
            String viewId = this.getViewId(((DefaultSubscriptionBaseBundle)bundle).getLastSysUpdateDate(), subscriptions);
            List<SubscriptionBaseTimeline> repairs = this.createGetSubscriptionRepairList(subscriptions, Collections.<SubscriptionBaseTimeline>emptyList());
            return this.createGetBundleRepair(bundle.getId(), bundle.getExternalKey(), viewId, repairs);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseRepairException(e);
        }
    }

    private List<SubscriptionDataRepair> convertToSubscriptionsDataRepair(List<SubscriptionBase> input) {
        return new ArrayList<SubscriptionDataRepair>(Collections2.transform(input, (Function)new Function<SubscriptionBase, SubscriptionDataRepair>(){

            public SubscriptionDataRepair apply(@Nullable SubscriptionBase subscription) {
                return DefaultSubscriptionBaseTimelineApi.this.convertToSubscriptionDataRepair((DefaultSubscriptionBase)subscription);
            }
        }));
    }

    private SubscriptionDataRepair convertToSubscriptionDataRepair(DefaultSubscriptionBase input) {
        return new SubscriptionDataRepair(input, this.repairApiService, (SubscriptionDao)((Object)this.repairDao), this.clock, this.addonUtils, this.catalogService, this.internalCallContextFactory);
    }

    public BundleBaseTimeline repairBundle(BundleBaseTimeline input, boolean dryRun, CallContext context) throws SubscriptionBaseRepairException {
        InternalTenantContext tenantContext = this.internalCallContextFactory.createInternalTenantContext((TenantContext)context);
        try {
            SubscriptionBaseBundle bundle = this.dao.getSubscriptionBundleFromId(input.getId(), tenantContext);
            if (bundle == null) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_UNKNOWN_BUNDLE, new Object[]{input.getId()});
            }
            List<SubscriptionDataRepair> subscriptions = this.convertToSubscriptionsDataRepair(this.dao.getSubscriptions(input.getId(), tenantContext));
            if (subscriptions.size() == 0) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_NO_ACTIVE_SUBSCRIPTIONS, new Object[]{input.getId()});
            }
            String viewId = this.getViewId(((DefaultSubscriptionBaseBundle)bundle).getLastSysUpdateDate(), subscriptions);
            if (!viewId.equals(input.getViewId())) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_VIEW_CHANGED, new Object[]{input.getId(), input.getViewId(), viewId});
            }
            DateTime firstDeletedBPEventTime = null;
            DateTime lastRemainingBPEventTime = null;
            boolean isBasePlanRecreate = false;
            DateTime newBundleStartDate = null;
            SubscriptionDataRepair baseSubscriptionRepair = null;
            LinkedList<SubscriptionDataRepair> addOnSubscriptionInRepair = new LinkedList<SubscriptionDataRepair>();
            LinkedList<SubscriptionDataRepair> inRepair = new LinkedList<SubscriptionDataRepair>();
            for (SubscriptionDataRepair cur : subscriptions) {
                DateTime newSubscriptionStartDate;
                SubscriptionBaseTimeline curRepair = this.findAndCreateSubscriptionRepair(cur.getId(), input.getSubscriptions());
                if (curRepair == null) continue;
                SubscriptionDataRepair curInputRepair = cur;
                List<SubscriptionBaseEvent> remaining = this.getRemainingEventsAndValidateDeletedEvents(curInputRepair, firstDeletedBPEventTime, curRepair.getDeletedEvents());
                boolean isPlanRecreate = curRepair.getNewEvents().size() > 0 && (((SubscriptionBaseTimeline.NewEvent)curRepair.getNewEvents().get(0)).getSubscriptionTransitionType() == SubscriptionBaseTransitionType.CREATE || ((SubscriptionBaseTimeline.NewEvent)curRepair.getNewEvents().get(0)).getSubscriptionTransitionType() == SubscriptionBaseTransitionType.RE_CREATE);
                DateTime dateTime = newSubscriptionStartDate = isPlanRecreate ? ((SubscriptionBaseTimeline.NewEvent)curRepair.getNewEvents().get(0)).getRequestedDate() : null;
                if (isPlanRecreate && remaining.size() != 0) {
                    throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_SUB_RECREATE_NOT_EMPTY, new Object[]{cur.getId(), cur.getBundleId()});
                }
                if (!isPlanRecreate && remaining.size() == 0) {
                    throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_SUB_EMPTY, new Object[]{cur.getId(), cur.getBundleId()});
                }
                if (cur.getCategory() == ProductCategory.BASE) {
                    int bpTransitionSize = ((DefaultSubscriptionBase)cur).getAllTransitions().size();
                    lastRemainingBPEventTime = remaining.size() > 0 ? curInputRepair.getAllTransitions().get(remaining.size() - 1).getEffectiveTransitionTime() : null;
                    firstDeletedBPEventTime = remaining.size() < bpTransitionSize ? curInputRepair.getAllTransitions().get(remaining.size()).getEffectiveTransitionTime() : null;
                    isBasePlanRecreate = isPlanRecreate;
                    newBundleStartDate = newSubscriptionStartDate;
                }
                if (curRepair.getNewEvents().size() > 0) {
                    DateTime lastRemainingEventTime = remaining.size() == 0 ? null : curInputRepair.getAllTransitions().get(remaining.size() - 1).getEffectiveTransitionTime();
                    this.validateFirstNewEvent(curInputRepair, (SubscriptionBaseTimeline.NewEvent)curRepair.getNewEvents().get(0), lastRemainingBPEventTime, lastRemainingEventTime);
                }
                SubscriptionDataRepair curOutputRepair = this.createSubscriptionDataRepair(curInputRepair, newBundleStartDate, newSubscriptionStartDate, remaining);
                this.repairDao.initializeRepair(curInputRepair.getId(), remaining, tenantContext);
                inRepair.add(curOutputRepair);
                if (curOutputRepair.getCategory() == ProductCategory.ADD_ON) {
                    if (isPlanRecreate && subscriptions.get(0).getStartDate().isAfter((ReadableInstant)((SubscriptionBaseTimeline.NewEvent)curRepair.getNewEvents().get(0)).getRequestedDate())) {
                        throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_AO_CREATE_BEFORE_BP_START, new Object[]{cur.getId(), cur.getBundleId()});
                    }
                    addOnSubscriptionInRepair.add(curOutputRepair);
                    continue;
                }
                if (curOutputRepair.getCategory() != ProductCategory.BASE) continue;
                baseSubscriptionRepair = curOutputRepair;
            }
            RepairType repairType = this.getRepairType(subscriptions.get(0), baseSubscriptionRepair != null);
            switch (repairType) {
                case BASE_REPAIR: {
                    for (SubscriptionDataRepair cur : subscriptions) {
                        if (cur.getCategory() != ProductCategory.ADD_ON || inRepair.contains((Object)cur)) continue;
                        SubscriptionDataRepair curOutputRepair = this.createSubscriptionDataRepair(cur, newBundleStartDate, null, cur.getEvents());
                        this.repairDao.initializeRepair(curOutputRepair.getId(), cur.getEvents(), tenantContext);
                        inRepair.add(curOutputRepair);
                        addOnSubscriptionInRepair.add(curOutputRepair);
                    }
                    break;
                }
                case ADD_ON_REPAIR: {
                    SubscriptionDataRepair baseSubscription = subscriptions.get(0);
                    baseSubscriptionRepair = this.createSubscriptionDataRepair(baseSubscription, baseSubscription.getBundleStartDate(), baseSubscription.getAlignStartDate(), baseSubscription.getEvents());
                    break;
                }
            }
            this.validateBasePlanRecreate(isBasePlanRecreate, subscriptions, input.getSubscriptions());
            this.validateInputSubscriptionsKnown(subscriptions, input.getSubscriptions());
            Collection<SubscriptionBaseTimeline.NewEvent> newEvents = this.createOrderedNewEventInput(input.getSubscriptions());
            for (SubscriptionBaseTimeline.NewEvent newEvent : newEvents) {
                DefaultNewEvent cur = (DefaultNewEvent)newEvent;
                SubscriptionDataRepair curDataRepair = this.findSubscriptionDataRepair(cur.getSubscriptionId(), inRepair);
                if (curDataRepair == null) {
                    throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_UNKNOWN_SUBSCRIPTION, new Object[]{cur.getSubscriptionId()});
                }
                curDataRepair.addNewRepairEvent(cur, baseSubscriptionRepair, addOnSubscriptionInRepair, context);
            }
            if (dryRun) {
                baseSubscriptionRepair.addFutureAddonCancellation(addOnSubscriptionInRepair, context);
                List<SubscriptionBaseTimeline> repairs = this.createGetSubscriptionRepairList(subscriptions, this.convertDataRepair(inRepair));
                BundleBaseTimeline bundleBaseTimeline = this.createGetBundleRepair(input.getId(), bundle.getExternalKey(), input.getViewId(), repairs);
                return bundleBaseTimeline;
            }
            this.dao.repair(bundle.getAccountId(), input.getId(), inRepair, this.internalCallContextFactory.createInternalCallContext(bundle.getAccountId(), context));
            BundleBaseTimeline bundleBaseTimeline = this.getBundleTimeline(input.getId(), (TenantContext)context);
            return bundleBaseTimeline;
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseRepairException(e);
        }
        finally {
            this.repairDao.cleanup(tenantContext);
        }
    }

    private RepairType getRepairType(SubscriptionBase firstSubscription, boolean gotBaseSubscription) {
        if (firstSubscription.getCategory() == ProductCategory.BASE) {
            return gotBaseSubscription ? RepairType.BASE_REPAIR : RepairType.ADD_ON_REPAIR;
        }
        return RepairType.STANDALONE_REPAIR;
    }

    private void validateBasePlanRecreate(boolean isBasePlanRecreate, List<SubscriptionDataRepair> subscriptions, List<SubscriptionBaseTimeline> input) throws SubscriptionBaseRepairException {
        if (!isBasePlanRecreate) {
            return;
        }
        if (subscriptions.size() != input.size()) {
            throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_BP_RECREATE_MISSING_AO, new Object[]{subscriptions.get(0).getBundleId()});
        }
        for (SubscriptionBaseTimeline cur : input) {
            if (cur.getNewEvents().size() == 0 || ((SubscriptionBaseTimeline.NewEvent)cur.getNewEvents().get(0)).getSubscriptionTransitionType() == SubscriptionBaseTransitionType.CREATE || ((SubscriptionBaseTimeline.NewEvent)cur.getNewEvents().get(0)).getSubscriptionTransitionType() == SubscriptionBaseTransitionType.RE_CREATE) continue;
            throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_BP_RECREATE_MISSING_AO_CREATE, new Object[]{subscriptions.get(0).getBundleId()});
        }
    }

    private void validateInputSubscriptionsKnown(List<SubscriptionDataRepair> subscriptions, List<SubscriptionBaseTimeline> input) throws SubscriptionBaseRepairException {
        for (SubscriptionBaseTimeline cur : input) {
            boolean found = false;
            for (SubscriptionDataRepair s : subscriptions) {
                if (!s.getId().equals(cur.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_UNKNOWN_SUBSCRIPTION, new Object[]{cur.getId()});
        }
    }

    private void validateFirstNewEvent(DefaultSubscriptionBase data, SubscriptionBaseTimeline.NewEvent firstNewEvent, DateTime lastBPRemainingTime, DateTime lastRemainingTime) throws SubscriptionBaseRepairException {
        if (lastBPRemainingTime != null && firstNewEvent.getRequestedDate().isBefore((ReadableInstant)lastBPRemainingTime)) {
            throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_NEW_EVENT_BEFORE_LAST_BP_REMAINING, new Object[]{firstNewEvent.getSubscriptionTransitionType(), data.getId()});
        }
        if (lastRemainingTime != null && firstNewEvent.getRequestedDate().isBefore((ReadableInstant)lastRemainingTime)) {
            throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_NEW_EVENT_BEFORE_LAST_AO_REMAINING, new Object[]{firstNewEvent.getSubscriptionTransitionType(), data.getId()});
        }
    }

    private Collection<SubscriptionBaseTimeline.NewEvent> createOrderedNewEventInput(List<SubscriptionBaseTimeline> subscriptionsReapir) {
        TreeSet<SubscriptionBaseTimeline.NewEvent> newEventSet = new TreeSet<SubscriptionBaseTimeline.NewEvent>(new Comparator<SubscriptionBaseTimeline.NewEvent>(){

            @Override
            public int compare(SubscriptionBaseTimeline.NewEvent o1, SubscriptionBaseTimeline.NewEvent o2) {
                return o1.getRequestedDate().compareTo((ReadableInstant)o2.getRequestedDate());
            }
        });
        for (SubscriptionBaseTimeline cur : subscriptionsReapir) {
            for (SubscriptionBaseTimeline.NewEvent e : cur.getNewEvents()) {
                newEventSet.add(new DefaultNewEvent(cur.getId(), e.getPlanPhaseSpecifier(), e.getRequestedDate(), e.getSubscriptionTransitionType()));
            }
        }
        return newEventSet;
    }

    private List<SubscriptionBaseEvent> getRemainingEventsAndValidateDeletedEvents(SubscriptionDataRepair data, DateTime firstBPDeletedTime, List<SubscriptionBaseTimeline.DeletedEvent> deletedEvents) throws SubscriptionBaseRepairException {
        if (deletedEvents == null || deletedEvents.size() == 0) {
            return data.getEvents();
        }
        int nbDeleted = 0;
        LinkedList<SubscriptionBaseEvent> result = new LinkedList<SubscriptionBaseEvent>();
        for (SubscriptionBaseEvent cur : data.getEvents()) {
            boolean foundDeletedEvent = false;
            for (SubscriptionBaseTimeline.DeletedEvent d : deletedEvents) {
                if (!cur.getId().equals(d.getEventId())) continue;
                foundDeletedEvent = true;
                ++nbDeleted;
                break;
            }
            if (!foundDeletedEvent && nbDeleted > 0) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_INVALID_DELETE_SET, new Object[]{cur.getId(), data.getId()});
            }
            if (firstBPDeletedTime != null && !cur.getEffectiveDate().isBefore((ReadableInstant)firstBPDeletedTime) && !foundDeletedEvent) {
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_MISSING_AO_DELETE_EVENT, new Object[]{cur.getId(), data.getId()});
            }
            if (nbDeleted != 0) continue;
            result.add(cur);
        }
        if (nbDeleted != deletedEvents.size()) {
            for (SubscriptionBaseTimeline.DeletedEvent d : deletedEvents) {
                boolean found = false;
                for (SubscriptionBaseTransition cur : data.getAllTransitions()) {
                    if (!((SubscriptionBaseTransitionData)cur).getId().equals(d.getEventId())) continue;
                    found = true;
                }
                if (found) continue;
                throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_NON_EXISTENT_DELETE_EVENT, new Object[]{d.getEventId(), data.getId()});
            }
        }
        return result;
    }

    private String getViewId(DateTime lastUpdateBundleDate, List<SubscriptionDataRepair> subscriptions) {
        StringBuilder tmp = new StringBuilder();
        long lastOrderedId = -1L;
        for (SubscriptionDataRepair cur : subscriptions) {
            lastOrderedId = lastOrderedId < ((DefaultSubscriptionBase)cur).getLastEventOrderedId() ? ((DefaultSubscriptionBase)cur).getLastEventOrderedId() : lastOrderedId;
        }
        tmp.append(lastOrderedId);
        tmp.append("-");
        tmp.append(lastUpdateBundleDate.toDate().getTime());
        return tmp.toString();
    }

    private BundleBaseTimeline createGetBundleRepair(final UUID bundleId, final String externalKey, final String viewId, final List<SubscriptionBaseTimeline> repairList) {
        return new BundleBaseTimeline(){

            public String getViewId() {
                return viewId;
            }

            public List<SubscriptionBaseTimeline> getSubscriptions() {
                return repairList;
            }

            public UUID getId() {
                return bundleId;
            }

            public DateTime getCreatedDate() {
                throw new UnsupportedOperationException();
            }

            public DateTime getUpdatedDate() {
                throw new UnsupportedOperationException();
            }

            public String getExternalKey() {
                return externalKey;
            }
        };
    }

    private List<SubscriptionBaseTimeline> createGetSubscriptionRepairList(List<SubscriptionDataRepair> subscriptions, List<SubscriptionBaseTimeline> inRepair) throws CatalogApiException {
        LinkedList<SubscriptionBaseTimeline> result = new LinkedList<SubscriptionBaseTimeline>();
        TreeSet<UUID> repairIds = new TreeSet<UUID>();
        for (SubscriptionBaseTimeline subscriptionBaseTimeline : inRepair) {
            repairIds.add(subscriptionBaseTimeline.getId());
            result.add(subscriptionBaseTimeline);
        }
        for (SubscriptionDataRepair subscriptionDataRepair : subscriptions) {
            if (repairIds.contains(subscriptionDataRepair.getId())) continue;
            result.add(new DefaultSubscriptionBaseTimeline(subscriptionDataRepair, this.catalogService.getFullCatalog()));
        }
        return result;
    }

    private List<SubscriptionBaseTimeline> convertDataRepair(List<SubscriptionDataRepair> input) throws CatalogApiException {
        LinkedList<SubscriptionBaseTimeline> result = new LinkedList<SubscriptionBaseTimeline>();
        for (SubscriptionDataRepair cur : input) {
            result.add(new DefaultSubscriptionBaseTimeline(cur, this.catalogService.getFullCatalog()));
        }
        return result;
    }

    private SubscriptionDataRepair findSubscriptionDataRepair(UUID targetId, List<SubscriptionDataRepair> input) {
        for (SubscriptionDataRepair cur : input) {
            if (!cur.getId().equals(targetId)) continue;
            return cur;
        }
        return null;
    }

    private SubscriptionDataRepair createSubscriptionDataRepair(DefaultSubscriptionBase curData, DateTime newBundleStartDate, DateTime newSubscriptionStartDate, List<SubscriptionBaseEvent> initialEvents) {
        SubscriptionBuilder builder = new SubscriptionBuilder(curData);
        builder.setActiveVersion(curData.getActiveVersion() + 1L);
        if (newBundleStartDate != null) {
            builder.setBundleStartDate(newBundleStartDate);
        }
        if (newSubscriptionStartDate != null) {
            builder.setAlignStartDate(newSubscriptionStartDate);
        }
        if (initialEvents.size() > 0) {
            for (SubscriptionBaseEvent cur : initialEvents) {
                cur.setActiveVersion(builder.getActiveVersion());
            }
        }
        SubscriptionDataRepair subscriptiondataRepair = new SubscriptionDataRepair(builder, curData.getEvents(), this.repairApiService, (SubscriptionDao)((Object)this.repairDao), this.clock, this.addonUtils, this.catalogService, this.internalCallContextFactory);
        subscriptiondataRepair.rebuildTransitions(curData.getEvents(), this.catalogService.getFullCatalog());
        return subscriptiondataRepair;
    }

    private SubscriptionBaseTimeline findAndCreateSubscriptionRepair(UUID target, List<SubscriptionBaseTimeline> input) {
        for (SubscriptionBaseTimeline cur : input) {
            if (!target.equals(cur.getId())) continue;
            return new DefaultSubscriptionBaseTimeline(cur);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RepairType {
        BASE_REPAIR,
        ADD_ON_REPAIR,
        STANDALONE_REPAIR;

    }
}

