/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.ning.billing.catalog.api.BillingActionPolicy;
import com.ning.billing.catalog.api.BillingPeriod;
import com.ning.billing.catalog.api.Catalog;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.PriceList;
import com.ning.billing.catalog.api.Product;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.user.SubscriptionBaseApiException;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionDataIterator;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.user.ApiEvent;
import com.ning.billing.subscription.events.user.ApiEventType;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.entity.EntityBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionBase
extends EntityBase
implements SubscriptionBase {
    private static final Logger log = LoggerFactory.getLogger(DefaultSubscriptionBase.class);
    private final Clock clock;
    private final SubscriptionBaseApiService apiService;
    private final UUID bundleId;
    private final DateTime alignStartDate;
    private final DateTime bundleStartDate;
    private final ProductCategory category;
    private final long activeVersion;
    private final DateTime chargedThroughDate;
    private final DateTime paidThroughDate;
    private LinkedList<SubscriptionBaseTransition> transitions;
    protected List<SubscriptionBaseEvent> events;

    public List<SubscriptionBaseEvent> getEvents() {
        return this.events;
    }

    public DefaultSubscriptionBase(SubscriptionBuilder builder) {
        this(builder, null, null);
    }

    public DefaultSubscriptionBase(SubscriptionBuilder builder, @Nullable SubscriptionBaseApiService apiService, @Nullable Clock clock) {
        super(builder.getId(), builder.getCreatedDate(), builder.getUpdatedDate());
        this.apiService = apiService;
        this.clock = clock;
        this.bundleId = builder.getBundleId();
        this.alignStartDate = builder.getAlignStartDate();
        this.bundleStartDate = builder.getBundleStartDate();
        this.category = builder.getCategory();
        this.activeVersion = builder.getActiveVersion();
        this.chargedThroughDate = builder.getChargedThroughDate();
        this.paidThroughDate = builder.getPaidThroughDate();
    }

    public DefaultSubscriptionBase(DefaultSubscriptionBase internalSubscription, SubscriptionBaseApiService apiService, Clock clock) {
        super(internalSubscription.getId(), internalSubscription.getCreatedDate(), internalSubscription.getUpdatedDate());
        this.apiService = apiService;
        this.clock = clock;
        this.bundleId = internalSubscription.getBundleId();
        this.alignStartDate = internalSubscription.getAlignStartDate();
        this.bundleStartDate = internalSubscription.getBundleStartDate();
        this.category = internalSubscription.getCategory();
        this.activeVersion = internalSubscription.getActiveVersion();
        this.chargedThroughDate = internalSubscription.getChargedThroughDate();
        this.paidThroughDate = internalSubscription.getPaidThroughDate();
        this.transitions = new LinkedList<SubscriptionBaseTransition>(internalSubscription.getAllTransitions());
        this.events = internalSubscription.getEvents();
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public DateTime getStartDate() {
        return this.transitions.get(0).getEffectiveTransitionTime();
    }

    public Entitlement.EntitlementState getState() {
        return this.getPreviousTransition() == null ? null : this.getPreviousTransition().getNextState();
    }

    public Entitlement.EntitlementSourceType getSourceType() {
        if (this.transitions == null) {
            return null;
        }
        SubscriptionBaseTransitionData initialTransition = (SubscriptionBaseTransitionData)this.transitions.get(0);
        switch (initialTransition.getApiEventType()) {
            case MIGRATE_BILLING: 
            case MIGRATE_ENTITLEMENT: {
                return Entitlement.EntitlementSourceType.MIGRATED;
            }
            case TRANSFER: {
                return Entitlement.EntitlementSourceType.TRANSFERRED;
            }
        }
        return Entitlement.EntitlementSourceType.NATIVE;
    }

    public PlanPhase getCurrentPhase() {
        return this.getPreviousTransition() == null ? null : this.getPreviousTransition().getNextPhase();
    }

    public Plan getCurrentPlan() {
        return this.getPreviousTransition() == null ? null : this.getPreviousTransition().getNextPlan();
    }

    public PriceList getCurrentPriceList() {
        return this.getPreviousTransition() == null ? null : this.getPreviousTransition().getNextPriceList();
    }

    public DateTime getEndDate() {
        SubscriptionBaseTransition latestTransition = this.getPreviousTransition();
        if (latestTransition.getNextState() == Entitlement.EntitlementState.CANCELLED) {
            return latestTransition.getEffectiveTransitionTime();
        }
        return null;
    }

    public DateTime getFutureEndDate() {
        if (this.transitions == null) {
            return null;
        }
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.ASC_FROM_PAST, SubscriptionBaseTransitionDataIterator.Kind.SUBSCRIPTION, SubscriptionBaseTransitionDataIterator.Visibility.ALL, SubscriptionBaseTransitionDataIterator.TimeLimit.FUTURE_ONLY);
        while (it.hasNext()) {
            SubscriptionBaseTransition cur = it.next();
            if (cur.getTransitionType() != SubscriptionBaseTransitionType.CANCEL) continue;
            return cur.getEffectiveTransitionTime();
        }
        return null;
    }

    public boolean recreate(PlanPhaseSpecifier spec, DateTime requestedDate, CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.recreatePlan(this, spec, requestedDate, context);
    }

    public boolean cancel(CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.cancel(this, context);
    }

    public boolean cancelWithDate(DateTime requestedDate, CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.cancelWithRequestedDate(this, requestedDate, context);
    }

    public boolean cancelWithPolicy(BillingActionPolicy policy, CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.cancelWithPolicy(this, policy, context);
    }

    public boolean uncancel(CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.uncancel(this, context);
    }

    public boolean changePlan(String productName, BillingPeriod term, String priceList, CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.changePlan(this, productName, term, priceList, context);
    }

    public boolean changePlanWithDate(String productName, BillingPeriod term, String priceList, DateTime requestedDate, CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.changePlanWithRequestedDate(this, productName, term, priceList, requestedDate, context);
    }

    public boolean changePlanWithPolicy(String productName, BillingPeriod term, String priceList, BillingActionPolicy policy, CallContext context) throws SubscriptionBaseApiException {
        return this.apiService.changePlanWithPolicy(this, productName, term, priceList, policy, context);
    }

    public SubscriptionBaseTransition getPendingTransition() {
        if (this.transitions == null) {
            return null;
        }
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.ASC_FROM_PAST, SubscriptionBaseTransitionDataIterator.Kind.SUBSCRIPTION, SubscriptionBaseTransitionDataIterator.Visibility.ALL, SubscriptionBaseTransitionDataIterator.TimeLimit.FUTURE_ONLY);
        return it.hasNext() ? it.next() : null;
    }

    public Product getLastActiveProduct() {
        if (this.getState() == Entitlement.EntitlementState.CANCELLED) {
            SubscriptionBaseTransition data = this.getPreviousTransition();
            return data.getPreviousPlan().getProduct();
        }
        return this.getCurrentPlan().getProduct();
    }

    public PriceList getLastActivePriceList() {
        if (this.getState() == Entitlement.EntitlementState.CANCELLED) {
            SubscriptionBaseTransition data = this.getPreviousTransition();
            return data.getPreviousPriceList();
        }
        return this.getCurrentPriceList();
    }

    public ProductCategory getLastActiveCategory() {
        if (this.getState() == Entitlement.EntitlementState.CANCELLED) {
            SubscriptionBaseTransition data = this.getPreviousTransition();
            return data.getPreviousPlan().getProduct().getCategory();
        }
        return this.getCurrentPlan().getProduct().getCategory();
    }

    public Plan getLastActivePlan() {
        if (this.getState() == Entitlement.EntitlementState.CANCELLED) {
            SubscriptionBaseTransition data = this.getPreviousTransition();
            return data.getPreviousPlan();
        }
        return this.getCurrentPlan();
    }

    public PlanPhase getLastActivePhase() {
        if (this.getState() == Entitlement.EntitlementState.CANCELLED) {
            SubscriptionBaseTransition data = this.getPreviousTransition();
            return data.getPreviousPhase();
        }
        return this.getCurrentPhase();
    }

    public BillingPeriod getLastActiveBillingPeriod() {
        if (this.getState() == Entitlement.EntitlementState.CANCELLED) {
            SubscriptionBaseTransition data = this.getPreviousTransition();
            return data.getPreviousPlan().getBillingPeriod();
        }
        return this.getCurrentPlan().getBillingPeriod();
    }

    public SubscriptionBaseTransition getPreviousTransition() {
        if (this.transitions == null) {
            return null;
        }
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.DESC_FROM_FUTURE, SubscriptionBaseTransitionDataIterator.Kind.SUBSCRIPTION, SubscriptionBaseTransitionDataIterator.Visibility.FROM_DISK_ONLY, SubscriptionBaseTransitionDataIterator.TimeLimit.PAST_OR_PRESENT_ONLY);
        return it.hasNext() ? it.next() : null;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public DateTime getBundleStartDate() {
        return this.bundleStartDate;
    }

    public DateTime getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public DateTime getPaidThroughDate() {
        return this.paidThroughDate;
    }

    public List<SubscriptionBaseTransition> getAllTransitions() {
        if (this.transitions == null) {
            return Collections.emptyList();
        }
        ArrayList<SubscriptionBaseTransition> result = new ArrayList<SubscriptionBaseTransition>();
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.ASC_FROM_PAST, SubscriptionBaseTransitionDataIterator.Kind.ALL, SubscriptionBaseTransitionDataIterator.Visibility.ALL, SubscriptionBaseTransitionDataIterator.TimeLimit.ALL);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DefaultSubscriptionBase other = (DefaultSubscriptionBase)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public SubscriptionBaseTransitionData getTransitionFromEvent(SubscriptionBaseEvent event, int seqId) {
        if (this.transitions == null || event == null) {
            return null;
        }
        SubscriptionBaseTransitionData prev = null;
        for (SubscriptionBaseTransition cur : this.transitions) {
            SubscriptionBaseTransitionData curData = (SubscriptionBaseTransitionData)cur;
            if (curData.getId().equals(event.getId())) {
                SubscriptionBaseTransitionData withSeq = new SubscriptionBaseTransitionData(curData, seqId);
                return withSeq;
            }
            if (curData.getTotalOrdering() >= event.getTotalOrdering()) continue;
            prev = curData;
        }
        if (prev != null && event.getType() == SubscriptionBaseEvent.EventType.API_USER && ((ApiEvent)event).getEventType() == ApiEventType.UNCANCEL) {
            SubscriptionBaseTransitionData withSeq = new SubscriptionBaseTransitionData(prev, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.UNCANCEL, seqId);
            return withSeq;
        }
        return null;
    }

    public DateTime getAlignStartDate() {
        return this.alignStartDate;
    }

    public long getLastEventOrderedId() {
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.DESC_FROM_FUTURE, SubscriptionBaseTransitionDataIterator.Kind.SUBSCRIPTION, SubscriptionBaseTransitionDataIterator.Visibility.FROM_DISK_ONLY, SubscriptionBaseTransitionDataIterator.TimeLimit.ALL);
        return it.hasNext() ? ((SubscriptionBaseTransitionData)it.next()).getTotalOrdering() : -1L;
    }

    public long getActiveVersion() {
        return this.activeVersion;
    }

    public List<SubscriptionBaseTransition> getBillingTransitions() {
        if (this.transitions == null) {
            return Collections.emptyList();
        }
        ArrayList<SubscriptionBaseTransition> result = new ArrayList<SubscriptionBaseTransition>();
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.ASC_FROM_PAST, SubscriptionBaseTransitionDataIterator.Kind.BILLING, SubscriptionBaseTransitionDataIterator.Visibility.ALL, SubscriptionBaseTransitionDataIterator.TimeLimit.ALL);
        boolean foundInitialEvent = false;
        while (it.hasNext()) {
            SubscriptionBaseTransitionData curTransition = (SubscriptionBaseTransitionData)it.next();
            if (!foundInitialEvent) {
                boolean bl = foundInitialEvent = curTransition.getEventType() == SubscriptionBaseEvent.EventType.API_USER && (curTransition.getApiEventType() == ApiEventType.CREATE || curTransition.getApiEventType() == ApiEventType.MIGRATE_BILLING || curTransition.getApiEventType() == ApiEventType.TRANSFER);
            }
            if (!foundInitialEvent) continue;
            result.add(curTransition);
        }
        return result;
    }

    public SubscriptionBaseTransitionData getInitialTransitionForCurrentPlan() {
        if (this.transitions == null) {
            throw new SubscriptionBaseError(String.format("No transitions for subscription %s", this.getId()));
        }
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.DESC_FROM_FUTURE, SubscriptionBaseTransitionDataIterator.Kind.SUBSCRIPTION, SubscriptionBaseTransitionDataIterator.Visibility.ALL, SubscriptionBaseTransitionDataIterator.TimeLimit.PAST_OR_PRESENT_ONLY);
        while (it.hasNext()) {
            SubscriptionBaseTransitionData cur = (SubscriptionBaseTransitionData)it.next();
            if (cur.getTransitionType() != SubscriptionBaseTransitionType.CREATE && cur.getTransitionType() != SubscriptionBaseTransitionType.RE_CREATE && cur.getTransitionType() != SubscriptionBaseTransitionType.TRANSFER && cur.getTransitionType() != SubscriptionBaseTransitionType.CHANGE && cur.getTransitionType() != SubscriptionBaseTransitionType.MIGRATE_ENTITLEMENT) continue;
            return cur;
        }
        throw new SubscriptionBaseError(String.format("Failed to find InitialTransitionForCurrentPlan id = %s", this.getId()));
    }

    public boolean isSubscriptionFutureCancelled() {
        return this.getFutureEndDate() != null;
    }

    public DateTime getPlanChangeEffectiveDate(BillingActionPolicy policy) {
        switch (policy) {
            case IMMEDIATE: {
                return this.clock.getUTCNow();
            }
            case END_OF_TERM: {
                return this.chargedThroughDate != null ? this.chargedThroughDate : this.clock.getUTCNow();
            }
        }
        throw new SubscriptionBaseError(String.format("Unexpected policy type %s", policy.toString()));
    }

    public DateTime getCurrentPhaseStart() {
        if (this.transitions == null) {
            throw new SubscriptionBaseError(String.format("No transitions for subscription %s", this.getId()));
        }
        SubscriptionBaseTransitionDataIterator it = new SubscriptionBaseTransitionDataIterator(this.clock, this.transitions, SubscriptionBaseTransitionDataIterator.Order.DESC_FROM_FUTURE, SubscriptionBaseTransitionDataIterator.Kind.SUBSCRIPTION, SubscriptionBaseTransitionDataIterator.Visibility.ALL, SubscriptionBaseTransitionDataIterator.TimeLimit.PAST_OR_PRESENT_ONLY);
        while (it.hasNext()) {
            SubscriptionBaseTransitionData cur = (SubscriptionBaseTransitionData)it.next();
            if (cur.getTransitionType() != SubscriptionBaseTransitionType.PHASE && cur.getTransitionType() != SubscriptionBaseTransitionType.TRANSFER && cur.getTransitionType() != SubscriptionBaseTransitionType.CREATE && cur.getTransitionType() != SubscriptionBaseTransitionType.RE_CREATE && cur.getTransitionType() != SubscriptionBaseTransitionType.CHANGE && cur.getTransitionType() != SubscriptionBaseTransitionType.MIGRATE_ENTITLEMENT) continue;
            return cur.getEffectiveTransitionTime();
        }
        throw new SubscriptionBaseError(String.format("Failed to find CurrentPhaseStart id = %s", this.getId().toString()));
    }

    public void rebuildTransitions(List<SubscriptionBaseEvent> inputEvents, Catalog catalog) {
        if (inputEvents == null) {
            return;
        }
        this.events = inputEvents;
        UUID nextUserToken = null;
        UUID nextEventId = null;
        DateTime nextCreatedDate = null;
        Entitlement.EntitlementState nextState = null;
        String nextPlanName = null;
        String nextPhaseName = null;
        String nextPriceListName = null;
        UUID prevEventId = null;
        DateTime prevCreatedDate = null;
        Entitlement.EntitlementState previousState = null;
        PriceList previousPriceList = null;
        Plan previousPlan = null;
        PlanPhase previousPhase = null;
        this.transitions = new LinkedList();
        for (SubscriptionBaseEvent cur : inputEvents) {
            if (!cur.isActive() || cur.getActiveVersion() < this.activeVersion) continue;
            ApiEventType apiEventType = null;
            boolean isFromDisk = true;
            nextEventId = cur.getId();
            nextCreatedDate = cur.getCreatedDate();
            block1 : switch (cur.getType()) {
                case PHASE: {
                    PhaseEvent phaseEV = (PhaseEvent)cur;
                    nextPhaseName = phaseEV.getPhase();
                    break;
                }
                case API_USER: {
                    ApiEvent userEV = (ApiEvent)cur;
                    apiEventType = userEV.getEventType();
                    isFromDisk = userEV.isFromDisk();
                    switch (apiEventType) {
                        case MIGRATE_BILLING: 
                        case MIGRATE_ENTITLEMENT: 
                        case TRANSFER: 
                        case CREATE: 
                        case RE_CREATE: {
                            prevEventId = null;
                            prevCreatedDate = null;
                            previousState = null;
                            previousPlan = null;
                            previousPhase = null;
                            previousPriceList = null;
                            nextState = Entitlement.EntitlementState.ACTIVE;
                            nextPlanName = userEV.getEventPlan();
                            nextPhaseName = userEV.getEventPlanPhase();
                            nextPriceListName = userEV.getPriceList();
                            break block1;
                        }
                        case CHANGE: {
                            nextPlanName = userEV.getEventPlan();
                            nextPhaseName = userEV.getEventPlanPhase();
                            nextPriceListName = userEV.getPriceList();
                            break block1;
                        }
                        case CANCEL: {
                            nextState = Entitlement.EntitlementState.CANCELLED;
                            nextPlanName = null;
                            nextPhaseName = null;
                            break block1;
                        }
                    }
                    throw new SubscriptionBaseError(String.format("Unexpected UserEvent type = %s", userEV.getEventType().toString()));
                }
                default: {
                    throw new SubscriptionBaseError(String.format("Unexpected Event type = %s", new Object[]{cur.getType()}));
                }
            }
            Plan nextPlan = null;
            PlanPhase nextPhase = null;
            PriceList nextPriceList = null;
            try {
                nextPlan = nextPlanName != null ? catalog.findPlan(nextPlanName, cur.getRequestedDate(), this.getAlignStartDate()) : null;
                nextPhase = nextPhaseName != null ? catalog.findPhase(nextPhaseName, cur.getRequestedDate(), this.getAlignStartDate()) : null;
                nextPriceList = nextPriceListName != null ? catalog.findPriceList(nextPriceListName, cur.getRequestedDate()) : null;
            }
            catch (CatalogApiException e) {
                log.error(String.format("Failed to build transition for subscription %s", this.id), (Throwable)e);
            }
            SubscriptionBaseTransitionData transition = new SubscriptionBaseTransitionData(cur.getId(), this.id, this.bundleId, cur.getType(), apiEventType, cur.getRequestedDate(), cur.getEffectiveDate(), prevEventId, prevCreatedDate, previousState, previousPlan, previousPhase, previousPriceList, nextEventId, nextCreatedDate, nextState, nextPlan, nextPhase, nextPriceList, cur.getTotalOrdering(), cur.getCreatedDate(), nextUserToken, isFromDisk);
            this.transitions.add(transition);
            previousState = nextState;
            previousPlan = nextPlan;
            previousPhase = nextPhase;
            previousPriceList = nextPriceList;
            prevEventId = nextEventId;
            prevCreatedDate = nextCreatedDate;
        }
    }
}

