/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.util.events.BusEventBase;
import com.ning.billing.util.events.BusInternalEvent;
import com.ning.billing.util.events.SubscriptionInternalEvent;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class DefaultSubscriptionEvent
extends BusEventBase
implements SubscriptionInternalEvent {
    private final Long totalOrdering;
    private final UUID subscriptionId;
    private final UUID bundleId;
    private final UUID eventId;
    private final DateTime requestedTransitionTime;
    private final DateTime effectiveTransitionTime;
    private final Entitlement.EntitlementState previousState;
    private final String previousPriceList;
    private final String previousPlan;
    private final String previousPhase;
    private final Entitlement.EntitlementState nextState;
    private final String nextPriceList;
    private final String nextPlan;
    private final String nextPhase;
    private final Integer remainingEventsForUserOperation;
    private final SubscriptionBaseTransitionType transitionType;
    private final DateTime startDate;

    public DefaultSubscriptionEvent(SubscriptionBaseTransitionData in, DateTime startDate, Long searchKey1, Long searchKey2, UUID userToken) {
        this(in.getId(), in.getSubscriptionId(), in.getBundleId(), in.getRequestedTransitionTime(), in.getEffectiveTransitionTime(), in.getPreviousState(), in.getPreviousPlan() != null ? in.getPreviousPlan().getName() : null, in.getPreviousPhase() != null ? in.getPreviousPhase().getName() : null, in.getPreviousPriceList() != null ? in.getPreviousPriceList().getName() : null, in.getNextState(), in.getNextPlan() != null ? in.getNextPlan().getName() : null, in.getNextPhase() != null ? in.getNextPhase().getName() : null, in.getNextPriceList() != null ? in.getNextPriceList().getName() : null, in.getTotalOrdering(), in.getTransitionType(), in.getRemainingEventsForUserOperation(), startDate, searchKey1, searchKey2, userToken);
    }

    @JsonCreator
    public DefaultSubscriptionEvent(@JsonProperty(value="eventId") UUID eventId, @JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="bundleId") UUID bundleId, @JsonProperty(value="requestedTransitionTime") DateTime requestedTransitionTime, @JsonProperty(value="effectiveTransitionTime") DateTime effectiveTransitionTime, @JsonProperty(value="previousState") Entitlement.EntitlementState previousState, @JsonProperty(value="previousPlan") String previousPlan, @JsonProperty(value="previousPhase") String previousPhase, @JsonProperty(value="previousPriceList") String previousPriceList, @JsonProperty(value="nextState") Entitlement.EntitlementState nextState, @JsonProperty(value="nextPlan") String nextPlan, @JsonProperty(value="nextPhase") String nextPhase, @JsonProperty(value="nextPriceList") String nextPriceList, @JsonProperty(value="totalOrdering") Long totalOrdering, @JsonProperty(value="transitionType") SubscriptionBaseTransitionType transitionType, @JsonProperty(value="remainingEventsForUserOperation") Integer remainingEventsForUserOperation, @JsonProperty(value="startDate") DateTime startDate, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
        super(searchKey1, searchKey2, userToken);
        this.eventId = eventId;
        this.subscriptionId = subscriptionId;
        this.bundleId = bundleId;
        this.requestedTransitionTime = requestedTransitionTime;
        this.effectiveTransitionTime = effectiveTransitionTime;
        this.previousState = previousState;
        this.previousPriceList = previousPriceList;
        this.previousPlan = previousPlan;
        this.previousPhase = previousPhase;
        this.nextState = nextState;
        this.nextPlan = nextPlan;
        this.nextPriceList = nextPriceList;
        this.nextPhase = nextPhase;
        this.totalOrdering = totalOrdering;
        this.transitionType = transitionType;
        this.remainingEventsForUserOperation = remainingEventsForUserOperation;
        this.startDate = startDate;
    }

    @JsonIgnore
    public BusInternalEvent.BusInternalEventType getBusEventType() {
        return BusInternalEvent.BusInternalEventType.SUBSCRIPTION_TRANSITION;
    }

    @JsonProperty(value="eventId")
    public UUID getId() {
        return this.eventId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public Entitlement.EntitlementState getPreviousState() {
        return this.previousState;
    }

    public String getPreviousPlan() {
        return this.previousPlan;
    }

    public String getPreviousPhase() {
        return this.previousPhase;
    }

    public String getNextPlan() {
        return this.nextPlan;
    }

    public String getNextPhase() {
        return this.nextPhase;
    }

    public Entitlement.EntitlementState getNextState() {
        return this.nextState;
    }

    public String getPreviousPriceList() {
        return this.previousPriceList;
    }

    public String getNextPriceList() {
        return this.nextPriceList;
    }

    public Integer getRemainingEventsForUserOperation() {
        return this.remainingEventsForUserOperation;
    }

    public DateTime getRequestedTransitionTime() {
        return this.requestedTransitionTime;
    }

    public DateTime getEffectiveTransitionTime() {
        return this.effectiveTransitionTime;
    }

    public Long getTotalOrdering() {
        return this.totalOrdering;
    }

    public SubscriptionBaseTransitionType getTransitionType() {
        return this.transitionType;
    }

    @JsonProperty(value="startDate")
    public DateTime getSubscriptionStartDate() {
        return this.startDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("{bundleId=").append(this.bundleId);
        sb.append(", totalOrdering=").append(this.totalOrdering);
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", eventId=").append(this.eventId);
        sb.append(", requestedTransitionTime=").append(this.requestedTransitionTime);
        sb.append(", effectiveTransitionTime=").append(this.effectiveTransitionTime);
        sb.append(", previousState=").append(this.previousState);
        sb.append(", previousPriceList='").append(this.previousPriceList).append('\'');
        sb.append(", previousPlan='").append(this.previousPlan).append('\'');
        sb.append(", previousPhase='").append(this.previousPhase).append('\'');
        sb.append(", nextState=").append(this.nextState);
        sb.append(", nextPriceList='").append(this.nextPriceList).append('\'');
        sb.append(", nextPlan='").append(this.nextPlan).append('\'');
        sb.append(", nextPhase='").append(this.nextPhase).append('\'');
        sb.append(", remainingEventsForUserOperation=").append(this.remainingEventsForUserOperation);
        sb.append(", transitionType=").append(this.transitionType);
        sb.append(", startDate=").append(this.startDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultSubscriptionEvent that = (DefaultSubscriptionEvent)((Object)o);
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.effectiveTransitionTime != null ? this.effectiveTransitionTime.compareTo((ReadableInstant)that.effectiveTransitionTime) != 0 : that.effectiveTransitionTime != null) {
            return false;
        }
        if (this.eventId != null ? !this.eventId.equals(that.eventId) : that.eventId != null) {
            return false;
        }
        if (this.nextPhase != null ? !this.nextPhase.equals(that.nextPhase) : that.nextPhase != null) {
            return false;
        }
        if (this.nextPlan != null ? !this.nextPlan.equals(that.nextPlan) : that.nextPlan != null) {
            return false;
        }
        if (this.nextPriceList != null ? !this.nextPriceList.equals(that.nextPriceList) : that.nextPriceList != null) {
            return false;
        }
        if (this.nextState != that.nextState) {
            return false;
        }
        if (this.previousPhase != null ? !this.previousPhase.equals(that.previousPhase) : that.previousPhase != null) {
            return false;
        }
        if (this.previousPlan != null ? !this.previousPlan.equals(that.previousPlan) : that.previousPlan != null) {
            return false;
        }
        if (this.previousPriceList != null ? !this.previousPriceList.equals(that.previousPriceList) : that.previousPriceList != null) {
            return false;
        }
        if (this.previousState != that.previousState) {
            return false;
        }
        if (this.remainingEventsForUserOperation != null ? !this.remainingEventsForUserOperation.equals(that.remainingEventsForUserOperation) : that.remainingEventsForUserOperation != null) {
            return false;
        }
        if (this.requestedTransitionTime != null ? this.requestedTransitionTime.compareTo((ReadableInstant)that.requestedTransitionTime) != 0 : that.requestedTransitionTime != null) {
            return false;
        }
        if (this.startDate != null ? this.startDate.compareTo((ReadableInstant)that.startDate) != 0 : that.startDate != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.totalOrdering != null ? !this.totalOrdering.equals(that.totalOrdering) : that.totalOrdering != null) {
            return false;
        }
        return this.transitionType == that.transitionType;
    }

    public int hashCode() {
        int result = this.totalOrdering != null ? this.totalOrdering.hashCode() : 0;
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.eventId != null ? this.eventId.hashCode() : 0);
        result = 31 * result + (this.requestedTransitionTime != null ? this.requestedTransitionTime.hashCode() : 0);
        result = 31 * result + (this.effectiveTransitionTime != null ? this.effectiveTransitionTime.hashCode() : 0);
        result = 31 * result + (this.previousState != null ? this.previousState.hashCode() : 0);
        result = 31 * result + (this.previousPriceList != null ? this.previousPriceList.hashCode() : 0);
        result = 31 * result + (this.previousPlan != null ? this.previousPlan.hashCode() : 0);
        result = 31 * result + (this.previousPhase != null ? this.previousPhase.hashCode() : 0);
        result = 31 * result + (this.nextState != null ? this.nextState.hashCode() : 0);
        result = 31 * result + (this.nextPriceList != null ? this.nextPriceList.hashCode() : 0);
        result = 31 * result + (this.nextPlan != null ? this.nextPlan.hashCode() : 0);
        result = 31 * result + (this.nextPhase != null ? this.nextPhase.hashCode() : 0);
        result = 31 * result + (this.remainingEventsForUserOperation != null ? this.remainingEventsForUserOperation.hashCode() : 0);
        result = 31 * result + (this.transitionType != null ? this.transitionType.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        return result;
    }
}

