/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.dao.model;

import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.util.dao.TableName;
import com.ning.billing.util.entity.EntityBase;
import com.ning.billing.util.entity.dao.EntityModelDao;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionBundleModelDao
extends EntityBase
implements EntityModelDao<SubscriptionBaseBundle> {
    private String externalKey;
    private UUID accountId;
    private DateTime lastSysUpdateDate;

    public SubscriptionBundleModelDao() {
    }

    public SubscriptionBundleModelDao(UUID id, String key, UUID accountId, DateTime lastSysUpdateDate, DateTime createdDate, DateTime updateDate) {
        super(id, createdDate, updateDate);
        this.externalKey = key;
        this.accountId = accountId;
        this.lastSysUpdateDate = lastSysUpdateDate;
    }

    public SubscriptionBundleModelDao(DefaultSubscriptionBaseBundle input) {
        this(input.getId(), input.getExternalKey(), input.getAccountId(), input.getLastSysUpdateDate(), input.getCreatedDate(), input.getUpdatedDate());
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public DateTime getLastSysUpdateDate() {
        return this.lastSysUpdateDate;
    }

    public static SubscriptionBaseBundle toSubscriptionbundle(SubscriptionBundleModelDao src) {
        if (src == null) {
            return null;
        }
        return new DefaultSubscriptionBaseBundle(src.getId(), src.getExternalKey(), src.getAccountId(), src.getLastSysUpdateDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionBundleModelDao");
        sb.append("{externalKey='").append(this.externalKey).append('\'');
        sb.append(", accountId=").append(this.accountId);
        sb.append(", lastSysUpdateDate=").append(this.lastSysUpdateDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionBundleModelDao that = (SubscriptionBundleModelDao)((Object)o);
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        return !(this.lastSysUpdateDate != null ? !this.lastSysUpdateDate.equals((Object)that.lastSysUpdateDate) : that.lastSysUpdateDate != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.lastSysUpdateDate != null ? this.lastSysUpdateDate.hashCode() : 0);
        return result;
    }

    public TableName getTableName() {
        return TableName.BUNDLES;
    }

    public TableName getHistoryTableName() {
        return null;
    }
}

