/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.dao.model;

import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.util.dao.TableName;
import com.ning.billing.util.entity.EntityBase;
import com.ning.billing.util.entity.dao.EntityModelDao;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionModelDao
extends EntityBase
implements EntityModelDao<SubscriptionBase> {
    private UUID bundleId;
    private ProductCategory category;
    private DateTime startDate;
    private DateTime bundleStartDate;
    private long activeVersion;
    private DateTime chargedThroughDate;
    private DateTime paidThroughDate;

    public SubscriptionModelDao() {
    }

    public SubscriptionModelDao(UUID id, UUID bundleId, ProductCategory category, DateTime startDate, DateTime bundleStartDate, long activeVersion, DateTime chargedThroughDate, DateTime paidThroughDate, DateTime createdDate, DateTime updateDate) {
        super(id, createdDate, updateDate);
        this.bundleId = bundleId;
        this.category = category;
        this.startDate = startDate;
        this.bundleStartDate = bundleStartDate;
        this.activeVersion = activeVersion;
        this.chargedThroughDate = chargedThroughDate;
        this.paidThroughDate = paidThroughDate;
    }

    public SubscriptionModelDao(DefaultSubscriptionBase src) {
        this(src.getId(), src.getBundleId(), src.getCategory(), src.getAlignStartDate(), src.getBundleStartDate(), src.getActiveVersion(), src.getChargedThroughDate(), src.getPaidThroughDate(), src.getCreatedDate(), src.getUpdatedDate());
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getBundleStartDate() {
        return this.bundleStartDate;
    }

    public long getActiveVersion() {
        return this.activeVersion;
    }

    public DateTime getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public DateTime getPaidThroughDate() {
        return this.paidThroughDate;
    }

    public static SubscriptionBase toSubscription(SubscriptionModelDao src) {
        if (src == null) {
            return null;
        }
        return new DefaultSubscriptionBase(new SubscriptionBuilder().setId(src.getId()).setBundleId(src.getBundleId()).setCategory(src.getCategory()).setCreatedDate(src.getCreatedDate()).setUpdatedDate(src.getUpdatedDate()).setBundleStartDate(src.getBundleStartDate()).setAlignStartDate(src.getStartDate()).setActiveVersion(src.getActiveVersion()).setChargedThroughDate(src.getChargedThroughDate()).setPaidThroughDate(src.getPaidThroughDate()).setCreatedDate(src.getCreatedDate()).setUpdatedDate(src.getUpdatedDate()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionModelDao");
        sb.append("{bundleId=").append(this.bundleId);
        sb.append(", category=").append(this.category);
        sb.append(", startDate=").append(this.startDate);
        sb.append(", bundleStartDate=").append(this.bundleStartDate);
        sb.append(", activeVersion=").append(this.activeVersion);
        sb.append(", chargedThroughDate=").append(this.chargedThroughDate);
        sb.append(", paidThroughDate=").append(this.paidThroughDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionModelDao that = (SubscriptionModelDao)((Object)o);
        if (this.activeVersion != that.activeVersion) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.bundleStartDate != null ? !this.bundleStartDate.equals((Object)that.bundleStartDate) : that.bundleStartDate != null) {
            return false;
        }
        if (this.category != that.category) {
            return false;
        }
        if (this.chargedThroughDate != null ? !this.chargedThroughDate.equals((Object)that.chargedThroughDate) : that.chargedThroughDate != null) {
            return false;
        }
        if (this.paidThroughDate != null ? !this.paidThroughDate.equals((Object)that.paidThroughDate) : that.paidThroughDate != null) {
            return false;
        }
        return !(this.startDate != null ? !this.startDate.equals((Object)that.startDate) : that.startDate != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.bundleStartDate != null ? this.bundleStartDate.hashCode() : 0);
        result = 31 * result + (int)(this.activeVersion ^ this.activeVersion >>> 32);
        result = 31 * result + (this.chargedThroughDate != null ? this.chargedThroughDate.hashCode() : 0);
        result = 31 * result + (this.paidThroughDate != null ? this.paidThroughDate.hashCode() : 0);
        return result;
    }

    public TableName getTableName() {
        return TableName.SUBSCRIPTIONS;
    }

    public TableName getHistoryTableName() {
        return null;
    }
}

