/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.google.inject.Inject;
import com.ning.billing.ErrorCode;
import com.ning.billing.ObjectType;
import com.ning.billing.callcontext.InternalCallContext;
import com.ning.billing.callcontext.InternalTenantContext;
import com.ning.billing.catalog.api.BillingActionPolicy;
import com.ning.billing.catalog.api.BillingPeriod;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.PhaseType;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanChangeResult;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.PlanSpecifier;
import com.ning.billing.catalog.api.PriceList;
import com.ning.billing.catalog.api.Product;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.clock.DefaultClock;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.alignment.PlanAligner;
import com.ning.billing.subscription.alignment.TimedPhase;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBaseApiException;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEventData;
import com.ning.billing.subscription.events.user.ApiEventBase;
import com.ning.billing.subscription.events.user.ApiEventBuilder;
import com.ning.billing.subscription.events.user.ApiEventCancel;
import com.ning.billing.subscription.events.user.ApiEventChange;
import com.ning.billing.subscription.events.user.ApiEventCreate;
import com.ning.billing.subscription.events.user.ApiEventReCreate;
import com.ning.billing.subscription.events.user.ApiEventUncancel;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.InternalCallContextFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DefaultSubscriptionBaseApiService
implements SubscriptionBaseApiService {
    private final Clock clock;
    private final SubscriptionDao dao;
    private final CatalogService catalogService;
    private final PlanAligner planAligner;
    private final AddonUtils addonUtils;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public DefaultSubscriptionBaseApiService(Clock clock, SubscriptionDao dao, CatalogService catalogService, PlanAligner planAligner, AddonUtils addonUtils, InternalCallContextFactory internalCallContextFactory) {
        this.clock = clock;
        this.catalogService = catalogService;
        this.planAligner = planAligner;
        this.dao = dao;
        this.addonUtils = addonUtils;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public DefaultSubscriptionBase createPlan(SubscriptionBuilder builder, Plan plan, PhaseType initialPhase, String realPriceList, DateTime requestedDate, DateTime effectiveDate, DateTime processedDate, CallContext context) throws SubscriptionBaseApiException {
        DefaultSubscriptionBase subscription = new DefaultSubscriptionBase(builder, (SubscriptionBaseApiService)this, this.clock);
        this.createFromSubscription(subscription, plan, initialPhase, realPriceList, requestedDate, effectiveDate, processedDate, false, context);
        return subscription;
    }

    @Deprecated
    public boolean recreatePlan(DefaultSubscriptionBase subscription, PlanPhaseSpecifier spec, DateTime requestedDateWithMs, CallContext context) throws SubscriptionBaseApiException {
        Entitlement.EntitlementState currentState = subscription.getState();
        if (currentState != null && currentState != Entitlement.EntitlementState.CANCELLED) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_RECREATE_BAD_STATE, new Object[]{subscription.getId(), currentState});
        }
        DateTime now = this.clock.getUTCNow();
        DateTime requestedDate = requestedDateWithMs != null ? DefaultClock.truncateMs((DateTime)requestedDateWithMs) : now;
        this.validateRequestedDate(subscription, now, requestedDate);
        try {
            String realPriceList = spec.getPriceListName() == null ? "DEFAULT" : spec.getPriceListName();
            Plan plan = this.catalogService.getFullCatalog().findPlan(spec.getProductName(), spec.getBillingPeriod(), realPriceList, requestedDate);
            PlanPhase phase = plan.getAllPhases()[0];
            if (phase == null) {
                throw new SubscriptionBaseError(String.format("No initial PlanPhase for Product %s, term %s and set %s does not exist in the catalog", spec.getProductName(), spec.getBillingPeriod().toString(), realPriceList));
            }
            DateTime effectiveDate = requestedDate;
            DateTime processedDate = now;
            this.createFromSubscription(subscription, plan, spec.getPhaseType(), realPriceList, requestedDate, effectiveDate, processedDate, true, context);
            return true;
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    private void createFromSubscription(DefaultSubscriptionBase subscription, Plan plan, PhaseType initialPhase, String realPriceList, DateTime requestedDate, DateTime effectiveDate, DateTime processedDate, boolean reCreate, CallContext context) throws SubscriptionBaseApiException {
        InternalCallContext internalCallContext = this.createCallContextFromBundleId(subscription.getBundleId(), context);
        try {
            TimedPhase[] curAndNextPhases = this.planAligner.getCurrentAndNextTimedPhaseOnCreate(subscription, plan, initialPhase, realPriceList, requestedDate, effectiveDate);
            ApiEventBuilder createBuilder = ((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(subscription.getId())).setEventPlan(plan.getName()).setEventPlanPhase(curAndNextPhases[0].getPhase().getName()).setEventPriceList(realPriceList).setActiveVersion(subscription.getActiveVersion())).setProcessedDate(processedDate)).setEffectiveDate(effectiveDate)).setRequestedDate(requestedDate)).setFromDisk(true);
            ApiEventBase creationEvent = reCreate ? new ApiEventReCreate(createBuilder) : new ApiEventCreate(createBuilder);
            TimedPhase nextTimedPhase = curAndNextPhases[1];
            PhaseEvent nextPhaseEvent = nextTimedPhase != null ? PhaseEventData.createNextPhaseEvent(nextTimedPhase.getPhase().getName(), subscription, processedDate, nextTimedPhase.getStartPhase()) : null;
            ArrayList<SubscriptionBaseEvent> events = new ArrayList<SubscriptionBaseEvent>();
            events.add(creationEvent);
            if (nextPhaseEvent != null) {
                events.add(nextPhaseEvent);
            }
            if (reCreate) {
                this.dao.recreateSubscription(subscription, events, internalCallContext);
            } else {
                this.dao.createSubscription(subscription, events, internalCallContext);
            }
            subscription.rebuildTransitions(this.dao.getEventsForSubscription(subscription.getId(), (InternalTenantContext)internalCallContext), this.catalogService.getFullCatalog());
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    public boolean cancel(DefaultSubscriptionBase subscription, CallContext context) throws SubscriptionBaseApiException {
        DateTime now;
        Entitlement.EntitlementState currentState = subscription.getState();
        if (currentState != Entitlement.EntitlementState.ACTIVE) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CANCEL_BAD_STATE, new Object[]{subscription.getId(), currentState});
        }
        DateTime requestedDate = now = this.clock.getUTCNow();
        Plan currentPlan = subscription.getCurrentPlan();
        PlanPhaseSpecifier planPhase = new PlanPhaseSpecifier(currentPlan.getProduct().getName(), currentPlan.getProduct().getCategory(), subscription.getCurrentPlan().getBillingPeriod(), subscription.getCurrentPriceList().getName(), subscription.getCurrentPhase().getPhaseType());
        try {
            BillingActionPolicy policy = this.catalogService.getFullCatalog().planCancelPolicy(planPhase, requestedDate);
            DateTime effectiveDate = subscription.getPlanChangeEffectiveDate(policy);
            return this.doCancelPlan(subscription, now, requestedDate, effectiveDate, context);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    public boolean cancelWithRequestedDate(DefaultSubscriptionBase subscription, DateTime requestedDateWithMs, CallContext context) throws SubscriptionBaseApiException {
        Entitlement.EntitlementState currentState = subscription.getState();
        if (currentState != Entitlement.EntitlementState.ACTIVE) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CANCEL_BAD_STATE, new Object[]{subscription.getId(), currentState});
        }
        DateTime now = this.clock.getUTCNow();
        DateTime requestedDate = requestedDateWithMs != null ? DefaultClock.truncateMs((DateTime)requestedDateWithMs) : now;
        return this.doCancelPlan(subscription, now, requestedDate, requestedDate, context);
    }

    public boolean cancelWithPolicy(DefaultSubscriptionBase subscription, BillingActionPolicy policy, CallContext context) throws SubscriptionBaseApiException {
        Entitlement.EntitlementState currentState = subscription.getState();
        if (currentState != Entitlement.EntitlementState.ACTIVE) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CANCEL_BAD_STATE, new Object[]{subscription.getId(), currentState});
        }
        DateTime now = this.clock.getUTCNow();
        DateTime effectiveDate = subscription.getPlanChangeEffectiveDate(policy);
        return this.doCancelPlan(subscription, now, now, effectiveDate, context);
    }

    private boolean doCancelPlan(DefaultSubscriptionBase subscription, DateTime now, DateTime requestedDate, DateTime effectiveDate, CallContext context) throws SubscriptionBaseApiException {
        this.validateRequestedDate(subscription, now, requestedDate);
        ApiEventCancel cancelEvent = new ApiEventCancel(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(subscription.getId())).setActiveVersion(subscription.getActiveVersion())).setProcessedDate(now)).setEffectiveDate(effectiveDate)).setRequestedDate(requestedDate)).setFromDisk(true));
        InternalCallContext internalCallContext = this.createCallContextFromBundleId(subscription.getBundleId(), context);
        this.dao.cancelSubscription(subscription, cancelEvent, internalCallContext, 0);
        subscription.rebuildTransitions(this.dao.getEventsForSubscription(subscription.getId(), (InternalTenantContext)internalCallContext), this.catalogService.getFullCatalog());
        this.cancelAddOnsIfRequired(subscription, effectiveDate, internalCallContext);
        boolean isImmediate = subscription.getState() == Entitlement.EntitlementState.CANCELLED;
        return isImmediate;
    }

    public boolean uncancel(DefaultSubscriptionBase subscription, CallContext context) throws SubscriptionBaseApiException {
        PhaseEvent nextPhaseEvent;
        if (!subscription.isSubscriptionFutureCancelled()) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_UNCANCEL_BAD_STATE, new Object[]{subscription.getId().toString()});
        }
        DateTime now = this.clock.getUTCNow();
        ApiEventUncancel uncancelEvent = new ApiEventUncancel(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(subscription.getId())).setActiveVersion(subscription.getActiveVersion())).setProcessedDate(now)).setRequestedDate(now)).setEffectiveDate(now)).setFromDisk(true));
        ArrayList<SubscriptionBaseEvent> uncancelEvents = new ArrayList<SubscriptionBaseEvent>();
        uncancelEvents.add(uncancelEvent);
        TimedPhase nextTimedPhase = this.planAligner.getNextTimedPhase(subscription, now, now);
        PhaseEvent phaseEvent = nextPhaseEvent = nextTimedPhase != null ? PhaseEventData.createNextPhaseEvent(nextTimedPhase.getPhase().getName(), subscription, now, nextTimedPhase.getStartPhase()) : null;
        if (nextPhaseEvent != null) {
            uncancelEvents.add(nextPhaseEvent);
        }
        InternalCallContext internalCallContext = this.createCallContextFromBundleId(subscription.getBundleId(), context);
        this.dao.uncancelSubscription(subscription, uncancelEvents, internalCallContext);
        subscription.rebuildTransitions(this.dao.getEventsForSubscription(subscription.getId(), (InternalTenantContext)internalCallContext), this.catalogService.getFullCatalog());
        return true;
    }

    public boolean changePlan(DefaultSubscriptionBase subscription, String productName, BillingPeriod term, String priceList, CallContext context) throws SubscriptionBaseApiException {
        DateTime now;
        DateTime requestedDate = now = this.clock.getUTCNow();
        this.validateRequestedDate(subscription, now, requestedDate);
        this.validateEntitlementState(subscription);
        PlanChangeResult planChangeResult = this.getPlanChangeResult(subscription, productName, term, priceList, requestedDate);
        DateTime effectiveDate = subscription.getPlanChangeEffectiveDate(planChangeResult.getPolicy());
        try {
            return this.doChangePlan(subscription, productName, term, planChangeResult.getNewPriceList().getName(), now, requestedDate, effectiveDate, context);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    public boolean changePlanWithRequestedDate(DefaultSubscriptionBase subscription, String productName, BillingPeriod term, String priceList, DateTime requestedDateWithMs, CallContext context) throws SubscriptionBaseApiException {
        DateTime now = this.clock.getUTCNow();
        DateTime requestedDate = requestedDateWithMs != null ? DefaultClock.truncateMs((DateTime)requestedDateWithMs) : now;
        this.validateRequestedDate(subscription, now, requestedDate);
        this.validateEntitlementState(subscription);
        try {
            return this.doChangePlan(subscription, productName, term, priceList, now, requestedDate, requestedDate, context);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    public boolean changePlanWithPolicy(DefaultSubscriptionBase subscription, String productName, BillingPeriod term, String priceList, BillingActionPolicy policy, CallContext context) throws SubscriptionBaseApiException {
        DateTime now;
        DateTime requestedDate = now = this.clock.getUTCNow();
        this.validateEntitlementState(subscription);
        DateTime effectiveDate = subscription.getPlanChangeEffectiveDate(policy);
        try {
            return this.doChangePlan(subscription, productName, term, priceList, now, requestedDate, effectiveDate, context);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    private PlanChangeResult getPlanChangeResult(DefaultSubscriptionBase subscription, String productName, BillingPeriod term, String priceList, DateTime effectiveDate) throws SubscriptionBaseApiException {
        PlanChangeResult planChangeResult;
        try {
            Product destProduct = this.catalogService.getFullCatalog().findProduct(productName, effectiveDate);
            Plan currentPlan = subscription.getCurrentPlan();
            PriceList currentPriceList = subscription.getCurrentPriceList();
            PlanPhaseSpecifier fromPlanPhase = new PlanPhaseSpecifier(currentPlan.getProduct().getName(), currentPlan.getProduct().getCategory(), currentPlan.getBillingPeriod(), currentPriceList.getName(), subscription.getCurrentPhase().getPhaseType());
            PlanSpecifier toPlanPhase = new PlanSpecifier(productName, destProduct.getCategory(), term, priceList);
            planChangeResult = this.catalogService.getFullCatalog().planChange(fromPlanPhase, toPlanPhase, effectiveDate);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
        return planChangeResult;
    }

    private boolean doChangePlan(DefaultSubscriptionBase subscription, String newProductName, BillingPeriod newBillingPeriod, String newPriceList, DateTime now, DateTime requestedDate, DateTime effectiveDate, CallContext context) throws SubscriptionBaseApiException, CatalogApiException {
        Plan newPlan = this.catalogService.getFullCatalog().findPlan(newProductName, newBillingPeriod, newPriceList, effectiveDate, subscription.getStartDate());
        TimedPhase currentTimedPhase = this.planAligner.getCurrentTimedPhaseOnChange(subscription, newPlan, newPriceList, requestedDate, effectiveDate);
        ApiEventChange changeEvent = new ApiEventChange(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(subscription.getId())).setEventPlan(newPlan.getName()).setEventPlanPhase(currentTimedPhase.getPhase().getName()).setEventPriceList(newPriceList).setActiveVersion(subscription.getActiveVersion())).setProcessedDate(now)).setEffectiveDate(effectiveDate)).setRequestedDate(requestedDate)).setFromDisk(true));
        TimedPhase nextTimedPhase = this.planAligner.getNextTimedPhaseOnChange(subscription, newPlan, newPriceList, requestedDate, effectiveDate);
        PhaseEvent nextPhaseEvent = nextTimedPhase != null ? PhaseEventData.createNextPhaseEvent(nextTimedPhase.getPhase().getName(), subscription, now, nextTimedPhase.getStartPhase()) : null;
        ArrayList<SubscriptionBaseEvent> changeEvents = new ArrayList<SubscriptionBaseEvent>();
        if (nextPhaseEvent != null && !nextPhaseEvent.getEffectiveDate().equals((Object)changeEvent.getEffectiveDate())) {
            changeEvents.add(nextPhaseEvent);
        }
        changeEvents.add(changeEvent);
        InternalCallContext internalCallContext = this.createCallContextFromBundleId(subscription.getBundleId(), context);
        this.dao.changePlan(subscription, changeEvents, internalCallContext);
        subscription.rebuildTransitions(this.dao.getEventsForSubscription(subscription.getId(), (InternalTenantContext)internalCallContext), this.catalogService.getFullCatalog());
        this.cancelAddOnsIfRequired(subscription, effectiveDate, internalCallContext);
        boolean isChangeImmediate = subscription.getCurrentPlan().getProduct().getName().equals(newProductName) && subscription.getCurrentPlan().getBillingPeriod() == newBillingPeriod;
        return isChangeImmediate;
    }

    public int cancelAddOnsIfRequired(DefaultSubscriptionBase baseSubscription, DateTime effectiveDate, InternalCallContext context) {
        DateTime now = this.clock.getUTCNow();
        if (effectiveDate.compareTo((ReadableInstant)now) > 0) {
            return 0;
        }
        Product baseProduct = baseSubscription.getState() == Entitlement.EntitlementState.CANCELLED ? null : baseSubscription.getCurrentPlan().getProduct();
        List<SubscriptionBase> subscriptions = this.dao.getSubscriptions(baseSubscription.getBundleId(), (InternalTenantContext)context);
        LinkedList<DefaultSubscriptionBase> subscriptionsToBeCancelled = new LinkedList<DefaultSubscriptionBase>();
        LinkedList<SubscriptionBaseEvent> cancelEvents = new LinkedList<SubscriptionBaseEvent>();
        for (SubscriptionBase subscription : subscriptions) {
            DefaultSubscriptionBase cur = (DefaultSubscriptionBase)subscription;
            if (cur.getState() == Entitlement.EntitlementState.CANCELLED || cur.getCategory() != ProductCategory.ADD_ON) continue;
            Plan addonCurrentPlan = cur.getCurrentPlan();
            if (baseProduct != null && !this.addonUtils.isAddonIncluded(baseProduct, addonCurrentPlan) && this.addonUtils.isAddonAvailable(baseProduct, addonCurrentPlan)) continue;
            ApiEventCancel cancelEvent = new ApiEventCancel(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(cur.getId())).setActiveVersion(cur.getActiveVersion())).setProcessedDate(now)).setEffectiveDate(effectiveDate)).setRequestedDate(now)).setFromDisk(true));
            subscriptionsToBeCancelled.add(cur);
            cancelEvents.add(cancelEvent);
        }
        this.dao.cancelSubscriptions(subscriptionsToBeCancelled, cancelEvents, context);
        return subscriptionsToBeCancelled.size();
    }

    private void validateRequestedDate(DefaultSubscriptionBase subscription, DateTime now, DateTime requestedDate) throws SubscriptionBaseApiException {
        SubscriptionBaseTransition previousTransition = subscription.getPreviousTransition();
        if (previousTransition != null && previousTransition.getEffectiveTransitionTime().isAfter((ReadableInstant)requestedDate)) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_INVALID_REQUESTED_DATE, new Object[]{requestedDate.toString(), previousTransition.getEffectiveTransitionTime()});
        }
    }

    private void validateEntitlementState(DefaultSubscriptionBase subscription) throws SubscriptionBaseApiException {
        Entitlement.EntitlementState currentState = subscription.getState();
        if (currentState != Entitlement.EntitlementState.ACTIVE) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CHANGE_NON_ACTIVE, new Object[]{subscription.getId(), currentState});
        }
        if (subscription.isSubscriptionFutureCancelled()) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CHANGE_FUTURE_CANCELLED, new Object[]{subscription.getId()});
        }
    }

    private InternalCallContext createCallContextFromBundleId(UUID bundleId, CallContext context) {
        return this.internalCallContextFactory.createInternalCallContext(bundleId, ObjectType.BUNDLE, context);
    }
}

