/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionEvents {
    public static final long INITIAL_VERSION = 1L;
    private final List<SubscriptionBaseEvent> events = new LinkedList<SubscriptionBaseEvent>();
    private long activeVersion = 1L;

    public void addEvent(SubscriptionBaseEvent ev) {
        this.events.add(ev);
    }

    public List<SubscriptionBaseEvent> getCurrentView() {
        return this.getViewForVersion(this.activeVersion);
    }

    public List<SubscriptionBaseEvent> getViewForVersion(long version) {
        LinkedList<SubscriptionBaseEvent> result = new LinkedList<SubscriptionBaseEvent>();
        for (SubscriptionBaseEvent cur : this.events) {
            if (cur.getActiveVersion() != version) continue;
            result.add(cur);
        }
        return result;
    }

    public long getActiveVersion() {
        return this.activeVersion;
    }

    public void setActiveVersion(long activeVersion) {
        this.activeVersion = activeVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionEvents");
        sb.append("{activeVersion=").append(this.activeVersion);
        sb.append(", events=").append(this.events);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionEvents that = (SubscriptionEvents)o;
        if (this.activeVersion != that.activeVersion) {
            return false;
        }
        return !(this.events != null ? !this.events.equals(that.events) : that.events != null);
    }

    public int hashCode() {
        int result = this.events != null ? this.events.hashCode() : 0;
        result = 31 * result + (int)(this.activeVersion ^ this.activeVersion >>> 32);
        return result;
    }
}

