/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.alignment;

import com.ning.billing.ErrorCode;
import com.ning.billing.catalog.api.Catalog;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.Duration;
import com.ning.billing.catalog.api.PhaseType;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanAlignmentChange;
import com.ning.billing.catalog.api.PlanAlignmentCreate;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.PlanSpecifier;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.subscription.alignment.BaseAligner;
import com.ning.billing.subscription.alignment.TimedPhase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBaseApiException;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanAligner
extends BaseAligner {
    private final CatalogService catalogService;

    @Inject
    public PlanAligner(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public TimedPhase[] getCurrentAndNextTimedPhaseOnCreate(DefaultSubscriptionBase subscription, Plan plan, PhaseType initialPhase, String priceList, DateTime requestedDate, DateTime effectiveDate) throws CatalogApiException, SubscriptionBaseApiException {
        List<TimedPhase> timedPhases = this.getTimedPhaseOnCreate(subscription.getAlignStartDate(), subscription.getBundleStartDate(), plan, initialPhase, priceList, requestedDate);
        TimedPhase[] result = new TimedPhase[]{this.getTimedPhase(timedPhases, effectiveDate, WhichPhase.CURRENT), this.getTimedPhase(timedPhases, effectiveDate, WhichPhase.NEXT)};
        return result;
    }

    public TimedPhase getCurrentTimedPhaseOnChange(DefaultSubscriptionBase subscription, Plan plan, String priceList, DateTime requestedDate, DateTime effectiveDate) throws CatalogApiException, SubscriptionBaseApiException {
        return this.getTimedPhaseOnChange(subscription, plan, priceList, requestedDate, effectiveDate, WhichPhase.CURRENT);
    }

    public TimedPhase getNextTimedPhaseOnChange(DefaultSubscriptionBase subscription, Plan plan, String priceList, DateTime requestedDate, DateTime effectiveDate) throws CatalogApiException, SubscriptionBaseApiException {
        return this.getTimedPhaseOnChange(subscription, plan, priceList, requestedDate, effectiveDate, WhichPhase.NEXT);
    }

    public TimedPhase getNextTimedPhase(DefaultSubscriptionBase subscription, DateTime requestedDate, DateTime effectiveDate) {
        try {
            SubscriptionBaseTransitionData lastPlanTransition = subscription.getInitialTransitionForCurrentPlan();
            if (effectiveDate.isBefore((ReadableInstant)lastPlanTransition.getEffectiveTransitionTime())) {
                throw new SubscriptionBaseError(String.format("Cannot specify an effectiveDate prior to last Plan Change, subscription = %s, effectiveDate = %s", subscription.getId(), effectiveDate));
            }
            switch (lastPlanTransition.getTransitionType()) {
                case MIGRATE_ENTITLEMENT: 
                case CREATE: 
                case RE_CREATE: 
                case TRANSFER: {
                    List<TimedPhase> timedPhases = this.getTimedPhaseOnCreate(subscription.getAlignStartDate(), subscription.getBundleStartDate(), lastPlanTransition.getNextPlan(), lastPlanTransition.getNextPhase().getPhaseType(), lastPlanTransition.getNextPriceList().getName(), requestedDate);
                    return this.getTimedPhase(timedPhases, effectiveDate, WhichPhase.NEXT);
                }
                case CHANGE: {
                    return this.getTimedPhaseOnChange(subscription.getAlignStartDate(), subscription.getBundleStartDate(), lastPlanTransition.getPreviousPhase(), lastPlanTransition.getPreviousPlan(), lastPlanTransition.getPreviousPriceList().getName(), lastPlanTransition.getNextPlan(), lastPlanTransition.getNextPriceList().getName(), requestedDate, effectiveDate, WhichPhase.NEXT);
                }
            }
            throw new SubscriptionBaseError(String.format("Unexpected initial transition %s for current plan %s on subscription %s", lastPlanTransition.getTransitionType(), subscription.getCurrentPlan(), subscription.getId()));
        }
        catch (Exception e) {
            throw new SubscriptionBaseError(String.format("Could not compute next phase change for subscription %s", subscription.getId()), e);
        }
    }

    private List<TimedPhase> getTimedPhaseOnCreate(DateTime subscriptionStartDate, DateTime bundleStartDate, Plan plan, PhaseType initialPhase, String priceList, DateTime requestedDate) throws CatalogApiException, SubscriptionBaseApiException {
        DateTime planStartDate;
        Catalog catalog = this.catalogService.getFullCatalog();
        PlanSpecifier planSpecifier = new PlanSpecifier(plan.getProduct().getName(), plan.getProduct().getCategory(), plan.getBillingPeriod(), priceList);
        PlanAlignmentCreate alignment = catalog.planCreateAlignment(planSpecifier, requestedDate);
        switch (alignment) {
            case START_OF_SUBSCRIPTION: {
                planStartDate = subscriptionStartDate;
                break;
            }
            case START_OF_BUNDLE: {
                planStartDate = bundleStartDate;
                break;
            }
            default: {
                throw new SubscriptionBaseError(String.format("Unknown PlanAlignmentCreate %s", alignment));
            }
        }
        return this.getPhaseAlignments(plan, initialPhase, planStartDate);
    }

    private TimedPhase getTimedPhaseOnChange(DefaultSubscriptionBase subscription, Plan nextPlan, String nextPriceList, DateTime requestedDate, DateTime effectiveDate, WhichPhase which) throws CatalogApiException, SubscriptionBaseApiException {
        return this.getTimedPhaseOnChange(subscription.getAlignStartDate(), subscription.getBundleStartDate(), subscription.getCurrentPhase(), subscription.getCurrentPlan(), subscription.getCurrentPriceList().getName(), nextPlan, nextPriceList, requestedDate, effectiveDate, which);
    }

    private TimedPhase getTimedPhaseOnChange(DateTime subscriptionStartDate, DateTime bundleStartDate, PlanPhase currentPhase, Plan currentPlan, String currentPriceList, Plan nextPlan, String priceList, DateTime requestedDate, DateTime effectiveDate, WhichPhase which) throws CatalogApiException, SubscriptionBaseApiException {
        DateTime planStartDate;
        Catalog catalog = this.catalogService.getFullCatalog();
        ProductCategory currentCategory = currentPlan.getProduct().getCategory();
        PlanPhaseSpecifier fromPlanPhaseSpecifier = new PlanPhaseSpecifier(currentPlan.getProduct().getName(), currentCategory, currentPlan.getBillingPeriod(), currentPriceList, currentPhase.getPhaseType());
        PlanSpecifier toPlanSpecifier = new PlanSpecifier(nextPlan.getProduct().getName(), nextPlan.getProduct().getCategory(), nextPlan.getBillingPeriod(), priceList);
        PlanAlignmentChange alignment = catalog.planChangeAlignment(fromPlanPhaseSpecifier, toPlanSpecifier, requestedDate);
        switch (alignment) {
            case START_OF_SUBSCRIPTION: {
                planStartDate = subscriptionStartDate;
                break;
            }
            case START_OF_BUNDLE: {
                planStartDate = bundleStartDate;
                break;
            }
            case CHANGE_OF_PLAN: {
                planStartDate = effectiveDate;
                break;
            }
            case CHANGE_OF_PRICELIST: {
                throw new SubscriptionBaseError(String.format("Not implemented yet %s", alignment));
            }
            default: {
                throw new SubscriptionBaseError(String.format("Unknown PlanAlignmentChange %s", alignment));
            }
        }
        List<TimedPhase> timedPhases = this.getPhaseAlignments(nextPlan, null, planStartDate);
        return this.getTimedPhase(timedPhases, effectiveDate, which);
    }

    private List<TimedPhase> getPhaseAlignments(Plan plan, @Nullable PhaseType initialPhase, DateTime initialPhaseStartDate) throws SubscriptionBaseApiException {
        if (plan == null) {
            return Collections.emptyList();
        }
        LinkedList<TimedPhase> result = new LinkedList<TimedPhase>();
        DateTime curPhaseStart = initialPhase == null ? initialPhaseStartDate : null;
        for (PlanPhase cur : plan.getAllPhases()) {
            if (curPhaseStart == null) {
                if (initialPhase != cur.getPhaseType()) continue;
                curPhaseStart = initialPhaseStartDate;
            }
            result.add(new TimedPhase(cur, curPhaseStart));
            if (cur.getPhaseType() == PhaseType.EVERGREEN) continue;
            Duration curPhaseDuration = cur.getDuration();
            DateTime nextPhaseStart = this.addDuration(curPhaseStart, curPhaseDuration);
            if (nextPhaseStart == null) {
                throw new SubscriptionBaseError(String.format("Unexpected non ending UNLIMITED phase for plan %s", plan.getName()));
            }
            curPhaseStart = nextPhaseStart;
        }
        if (initialPhase != null && curPhaseStart == null) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_BAD_PHASE, new Object[]{initialPhase});
        }
        return result;
    }

    private TimedPhase getTimedPhase(List<TimedPhase> timedPhases, DateTime effectiveDate, WhichPhase which) {
        TimedPhase cur = null;
        TimedPhase next = null;
        for (TimedPhase phase : timedPhases) {
            if (phase.getStartPhase().isAfter((ReadableInstant)effectiveDate)) {
                next = phase;
                break;
            }
            cur = phase;
        }
        switch (which) {
            case CURRENT: {
                return cur;
            }
            case NEXT: {
                return next;
            }
        }
        throw new SubscriptionBaseError(String.format("Unexpected %s TimedPhase", new Object[]{which}));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WhichPhase {
        CURRENT,
        NEXT;

    }
}

