/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.transfer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.ning.billing.ErrorCode;
import com.ning.billing.callcontext.InternalCallContext;
import com.ning.billing.callcontext.InternalTenantContext;
import com.ning.billing.catalog.api.Catalog;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.api.SubscriptionApiBase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.migration.AccountMigrationData;
import com.ning.billing.subscription.api.svcs.DefaultSubscriptionInternalApi;
import com.ning.billing.subscription.api.timeline.BundleBaseTimeline;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseRepairException;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseTimeline;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseTimelineApi;
import com.ning.billing.subscription.api.transfer.SubscriptionBaseTransferApi;
import com.ning.billing.subscription.api.transfer.SubscriptionBaseTransferApiException;
import com.ning.billing.subscription.api.transfer.TransferCancelData;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEventData;
import com.ning.billing.subscription.events.user.ApiEventBuilder;
import com.ning.billing.subscription.events.user.ApiEventCancel;
import com.ning.billing.subscription.events.user.ApiEventChange;
import com.ning.billing.subscription.events.user.ApiEventTransfer;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.InternalCallContextFactory;
import com.ning.billing.util.callcontext.TenantContext;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionBaseTransferApi
extends SubscriptionApiBase
implements SubscriptionBaseTransferApi {
    private final CatalogService catalogService;
    private final SubscriptionBaseTimelineApi timelineApi;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public DefaultSubscriptionBaseTransferApi(Clock clock, SubscriptionDao dao, SubscriptionBaseTimelineApi timelineApi, CatalogService catalogService, SubscriptionBaseApiService apiService, InternalCallContextFactory internalCallContextFactory) {
        super(dao, apiService, clock, catalogService);
        this.catalogService = catalogService;
        this.timelineApi = timelineApi;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    private SubscriptionBaseEvent createEvent(boolean firstEvent, SubscriptionBaseTimeline.ExistingEvent existingEvent, DefaultSubscriptionBase subscription, DateTime transferDate, CallContext context) throws CatalogApiException {
        PlanPhase currentPhase;
        ApiEventTransfer newEvent = null;
        Catalog catalog = this.catalogService.getFullCatalog();
        DateTime effectiveDate = existingEvent.getEffectiveDate().isBefore((ReadableInstant)transferDate) ? transferDate : existingEvent.getEffectiveDate();
        PlanPhaseSpecifier spec = existingEvent.getPlanPhaseSpecifier();
        PlanPhase planPhase = currentPhase = existingEvent.getPlanPhaseName() != null ? catalog.findPhase(existingEvent.getPlanPhaseName(), effectiveDate, subscription.getAlignStartDate()) : null;
        if (spec == null || currentPhase == null) {
            return null;
        }
        ApiEventBuilder apiBuilder = ((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(subscription.getId())).setEventPlan(currentPhase.getPlan().getName()).setEventPlanPhase(currentPhase.getName()).setEventPriceList(spec.getPriceListName()).setActiveVersion(subscription.getActiveVersion())).setProcessedDate(this.clock.getUTCNow())).setEffectiveDate(effectiveDate)).setRequestedDate(effectiveDate)).setFromDisk(true);
        switch (existingEvent.getSubscriptionTransitionType()) {
            case TRANSFER: 
            case MIGRATE_ENTITLEMENT: 
            case RE_CREATE: 
            case CREATE: {
                newEvent = new ApiEventTransfer(apiBuilder);
                break;
            }
            case CHANGE: {
                newEvent = firstEvent ? new ApiEventTransfer(apiBuilder) : new ApiEventChange(apiBuilder);
                break;
            }
            case PHASE: {
                newEvent = firstEvent ? new ApiEventTransfer(apiBuilder) : PhaseEventData.createNextPhaseEvent(currentPhase.getName(), subscription, this.clock.getUTCNow(), effectiveDate);
                break;
            }
            case MIGRATE_BILLING: {
                if (!firstEvent) break;
                newEvent = new ApiEventTransfer(apiBuilder);
                break;
            }
            case CANCEL: {
                break;
            }
            default: {
                throw new SubscriptionBaseError(String.format("Unexpected transitionType %s", existingEvent.getSubscriptionTransitionType()));
            }
        }
        return newEvent;
    }

    @VisibleForTesting
    List<SubscriptionBaseEvent> toEvents(List<SubscriptionBaseTimeline.ExistingEvent> existingEvents, DefaultSubscriptionBase subscription, DateTime transferDate, CallContext context) throws SubscriptionBaseTransferApiException {
        try {
            LinkedList<SubscriptionBaseEvent> result = new LinkedList<SubscriptionBaseEvent>();
            SubscriptionBaseEvent event = null;
            SubscriptionBaseTimeline.ExistingEvent prevEvent = null;
            boolean firstEvent = true;
            for (SubscriptionBaseTimeline.ExistingEvent cur : existingEvents) {
                if (cur.getEffectiveDate().isBefore((ReadableInstant)transferDate)) {
                    prevEvent = cur;
                    continue;
                }
                if (prevEvent != null) {
                    event = this.createEvent(firstEvent, prevEvent, subscription, transferDate, context);
                    if (event != null) {
                        result.add(event);
                        firstEvent = false;
                    }
                    prevEvent = null;
                }
                if ((event = this.createEvent(firstEvent, cur, subscription, transferDate, context)) == null) continue;
                result.add(event);
                firstEvent = false;
            }
            if (prevEvent != null) {
                event = this.createEvent(firstEvent, prevEvent, subscription, transferDate, context);
                if (event != null) {
                    result.add(event);
                }
                prevEvent = null;
            }
            return result;
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseTransferApiException(e);
        }
    }

    public SubscriptionBaseBundle transferBundle(UUID sourceAccountId, UUID destAccountId, String bundleKey, DateTime transferDate, boolean transferAddOn, boolean cancelImmediately, CallContext context) throws SubscriptionBaseTransferApiException {
        InternalCallContext fromInternalCallContext = this.internalCallContextFactory.createInternalCallContext(sourceAccountId, context);
        InternalCallContext toInternalCallContext = this.internalCallContextFactory.createInternalCallContext(destAccountId, context);
        try {
            DateTime effectiveTransferDate;
            DateTime dateTime = effectiveTransferDate = transferDate == null ? this.clock.getUTCNow() : transferDate;
            if (effectiveTransferDate.isAfter((ReadableInstant)this.clock.getUTCNow())) {
                throw new SubscriptionBaseTransferApiException(ErrorCode.SUB_TRANSFER_INVALID_EFF_DATE, new Object[]{effectiveTransferDate});
            }
            List<SubscriptionBaseBundle> bundlesForAccountAndKey = this.dao.getSubscriptionBundlesForAccountAndKey(sourceAccountId, bundleKey, (InternalTenantContext)fromInternalCallContext);
            SubscriptionBaseBundle bundle = DefaultSubscriptionInternalApi.getActiveBundleForKeyNotException(bundlesForAccountAndKey, this.dao, this.clock, (InternalTenantContext)fromInternalCallContext);
            if (bundle == null) {
                throw new SubscriptionBaseTransferApiException(ErrorCode.SUB_CREATE_NO_BUNDLE, new Object[]{bundleKey});
            }
            BundleBaseTimeline bundleBaseTimeline = this.timelineApi.getBundleTimeline(bundle, (TenantContext)context);
            DefaultSubscriptionBaseBundle subscriptionBundleData = new DefaultSubscriptionBaseBundle(bundleKey, destAccountId, effectiveTransferDate, bundle.getOriginalCreatedDate(), this.clock.getUTCNow(), this.clock.getUTCNow());
            LinkedList<AccountMigrationData.SubscriptionMigrationData> subscriptionMigrationDataList = new LinkedList<AccountMigrationData.SubscriptionMigrationData>();
            LinkedList<TransferCancelData> transferCancelDataList = new LinkedList<TransferCancelData>();
            DateTime bundleStartdate = null;
            for (SubscriptionBaseTimeline cur : bundleBaseTimeline.getSubscriptions()) {
                DefaultSubscriptionBase oldSubscription = (DefaultSubscriptionBase)this.dao.getSubscriptionFromId(cur.getId(), (InternalTenantContext)fromInternalCallContext);
                if (oldSubscription.getState() == Entitlement.EntitlementState.CANCELLED) continue;
                List existingEvents = cur.getExistingEvents();
                ProductCategory productCategory = ((SubscriptionBaseTimeline.ExistingEvent)existingEvents.get(0)).getPlanPhaseSpecifier().getProductCategory();
                if (productCategory == ProductCategory.ADD_ON) {
                    if (!transferAddOn) {
                        continue;
                    }
                } else {
                    DateTime effectiveCancelDate = !cancelImmediately && oldSubscription.getChargedThroughDate() != null && effectiveTransferDate.isBefore((ReadableInstant)oldSubscription.getChargedThroughDate()) ? oldSubscription.getChargedThroughDate() : effectiveTransferDate;
                    ApiEventCancel cancelEvent = new ApiEventCancel(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(cur.getId())).setActiveVersion(cur.getActiveVersion())).setProcessedDate(this.clock.getUTCNow())).setEffectiveDate(effectiveCancelDate)).setRequestedDate(effectiveTransferDate)).setFromDisk(true));
                    TransferCancelData cancelData = new TransferCancelData(oldSubscription, cancelEvent);
                    transferCancelDataList.add(cancelData);
                }
                DateTime subscriptionAlignStartDate = oldSubscription.getAlignStartDate();
                if (bundleStartdate == null) {
                    bundleStartdate = oldSubscription.getStartDate();
                }
                DefaultSubscriptionBase defaultSubscriptionBase = this.createSubscriptionForApiUse(new SubscriptionBuilder().setId(UUID.randomUUID()).setBundleId(subscriptionBundleData.getId()).setCategory(productCategory).setBundleStartDate(effectiveTransferDate).setAlignStartDate(subscriptionAlignStartDate), (List<SubscriptionBaseEvent>)ImmutableList.of());
                List<SubscriptionBaseEvent> events = this.toEvents(existingEvents, defaultSubscriptionBase, effectiveTransferDate, context);
                AccountMigrationData.SubscriptionMigrationData curData = new AccountMigrationData.SubscriptionMigrationData(defaultSubscriptionBase, events, null);
                subscriptionMigrationDataList.add(curData);
            }
            AccountMigrationData.BundleMigrationData bundleMigrationData = new AccountMigrationData.BundleMigrationData(subscriptionBundleData, subscriptionMigrationDataList);
            this.dao.transfer(sourceAccountId, destAccountId, bundleMigrationData, transferCancelDataList, fromInternalCallContext, toInternalCallContext);
            return bundleMigrationData.getData();
        }
        catch (SubscriptionBaseRepairException e) {
            throw new SubscriptionBaseTransferApiException(e);
        }
    }
}

