/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PriceList;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.user.ApiEventType;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SubscriptionBaseTransitionData
implements SubscriptionBaseTransition {
    private final Long totalOrdering;
    private final UUID subscriptionId;
    private final UUID bundleId;
    private final UUID eventId;
    private final SubscriptionBaseEvent.EventType eventType;
    private final ApiEventType apiEventType;
    private final DateTime requestedTransitionTime;
    private final DateTime effectiveTransitionTime;
    private final Entitlement.EntitlementState previousState;
    private final PriceList previousPriceList;
    private final UUID previousEventId;
    private final DateTime previousEventCreatedDate;
    private final Plan previousPlan;
    private final PlanPhase previousPhase;
    private final UUID nextEventId;
    private final DateTime nextEventCreatedDate;
    private final Entitlement.EntitlementState nextState;
    private final PriceList nextPriceList;
    private final Plan nextPlan;
    private final PlanPhase nextPhase;
    private final Boolean isFromDisk;
    private final Integer remainingEventsForUserOperation;
    private final UUID userToken;
    private final DateTime createdDate;

    public SubscriptionBaseTransitionData(UUID eventId, UUID subscriptionId, UUID bundleId, SubscriptionBaseEvent.EventType eventType, ApiEventType apiEventType, DateTime requestedTransitionTime, DateTime effectiveTransitionTime, UUID previousEventId, DateTime previousEventCreatedDate, Entitlement.EntitlementState previousState, Plan previousPlan, PlanPhase previousPhase, PriceList previousPriceList, UUID nextEventId, DateTime nextEventCreatedDate, Entitlement.EntitlementState nextState, Plan nextPlan, PlanPhase nextPhase, PriceList nextPriceList, Long totalOrdering, DateTime createdDate, UUID userToken, Boolean isFromDisk) {
        this.eventId = eventId;
        this.subscriptionId = subscriptionId;
        this.bundleId = bundleId;
        this.eventType = eventType;
        this.apiEventType = apiEventType;
        this.requestedTransitionTime = requestedTransitionTime;
        this.effectiveTransitionTime = effectiveTransitionTime;
        this.previousState = previousState;
        this.previousPriceList = previousPriceList;
        this.previousPlan = previousPlan;
        this.previousPhase = previousPhase;
        this.nextState = nextState;
        this.nextPlan = nextPlan;
        this.nextPriceList = nextPriceList;
        this.nextPhase = nextPhase;
        this.totalOrdering = totalOrdering;
        this.previousEventId = previousEventId;
        this.previousEventCreatedDate = previousEventCreatedDate;
        this.nextEventId = nextEventId;
        this.nextEventCreatedDate = nextEventCreatedDate;
        this.isFromDisk = isFromDisk;
        this.userToken = userToken;
        this.createdDate = createdDate;
        this.remainingEventsForUserOperation = 0;
    }

    public SubscriptionBaseTransitionData(SubscriptionBaseTransitionData input, int remainingEventsForUserOperation) {
        this(input, input.getEventType(), input.getApiEventType(), remainingEventsForUserOperation);
    }

    public SubscriptionBaseTransitionData(SubscriptionBaseTransitionData input, SubscriptionBaseEvent.EventType eventType, ApiEventType apiEventType, int remainingEventsForUserOperation) {
        this.eventId = input.getId();
        this.subscriptionId = input.getSubscriptionId();
        this.bundleId = input.getBundleId();
        this.eventType = eventType;
        this.apiEventType = apiEventType;
        this.requestedTransitionTime = input.getRequestedTransitionTime();
        this.effectiveTransitionTime = input.getEffectiveTransitionTime();
        this.previousEventId = input.getPreviousEventId();
        this.previousEventCreatedDate = input.getPreviousEventCreatedDate();
        this.previousState = input.getPreviousState();
        this.previousPriceList = input.getPreviousPriceList();
        this.previousPlan = input.getPreviousPlan();
        this.previousPhase = input.getPreviousPhase();
        this.nextEventId = input.getNextEventId();
        this.nextEventCreatedDate = input.getNextEventCreatedDate();
        this.nextState = input.getNextState();
        this.nextPlan = input.getNextPlan();
        this.nextPriceList = input.getNextPriceList();
        this.nextPhase = input.getNextPhase();
        this.totalOrdering = input.getTotalOrdering();
        this.isFromDisk = input.isFromDisk();
        this.userToken = input.getUserToken();
        this.remainingEventsForUserOperation = remainingEventsForUserOperation;
        this.createdDate = input.getCreatedDate();
    }

    public UUID getId() {
        return this.eventId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public Entitlement.EntitlementState getPreviousState() {
        return this.previousState;
    }

    public Plan getPreviousPlan() {
        return this.previousPlan;
    }

    public PlanPhase getPreviousPhase() {
        return this.previousPhase;
    }

    public UUID getNextEventId() {
        return this.nextEventId;
    }

    public DateTime getNextEventCreatedDate() {
        return this.nextEventCreatedDate;
    }

    public Plan getNextPlan() {
        return this.nextPlan;
    }

    public PlanPhase getNextPhase() {
        return this.nextPhase;
    }

    public Entitlement.EntitlementState getNextState() {
        return this.nextState;
    }

    public UUID getPreviousEventId() {
        return this.previousEventId;
    }

    public DateTime getPreviousEventCreatedDate() {
        return this.previousEventCreatedDate;
    }

    public PriceList getPreviousPriceList() {
        return this.previousPriceList;
    }

    public PriceList getNextPriceList() {
        return this.nextPriceList;
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public Integer getRemainingEventsForUserOperation() {
        return this.remainingEventsForUserOperation;
    }

    public SubscriptionBaseTransitionType getTransitionType() {
        return SubscriptionBaseTransitionData.toSubscriptionTransitionType(this.eventType, this.apiEventType);
    }

    public static SubscriptionBaseTransitionType toSubscriptionTransitionType(SubscriptionBaseEvent.EventType eventType, ApiEventType apiEventType) {
        switch (eventType) {
            case API_USER: {
                return apiEventType.getSubscriptionTransitionType();
            }
            case PHASE: {
                return SubscriptionBaseTransitionType.PHASE;
            }
        }
        throw new SubscriptionBaseError("Unexpected event type " + (Object)((Object)eventType));
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getRequestedTransitionTime() {
        return this.requestedTransitionTime;
    }

    public DateTime getEffectiveTransitionTime() {
        return this.effectiveTransitionTime;
    }

    public Long getTotalOrdering() {
        return this.totalOrdering;
    }

    public Boolean isFromDisk() {
        return this.isFromDisk;
    }

    public ApiEventType getApiEventType() {
        return this.apiEventType;
    }

    public SubscriptionBaseEvent.EventType getEventType() {
        return this.eventType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionBaseTransitionData");
        sb.append("{apiEventType=").append((Object)this.apiEventType);
        sb.append(", totalOrdering=").append(this.totalOrdering);
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", bundleId=").append(this.bundleId);
        sb.append(", eventId=").append(this.eventId);
        sb.append(", eventType=").append((Object)this.eventType);
        sb.append(", requestedTransitionTime=").append(this.requestedTransitionTime);
        sb.append(", effectiveTransitionTime=").append(this.effectiveTransitionTime);
        sb.append(", previousState=").append(this.previousState);
        sb.append(", previousPriceList=").append(this.previousPriceList);
        sb.append(", previousPlan=").append(this.previousPlan);
        sb.append(", previousPhase=").append(this.previousPhase);
        sb.append(", nextState=").append(this.nextState);
        sb.append(", nextPriceList=").append(this.nextPriceList);
        sb.append(", nextPlan=").append(this.nextPlan);
        sb.append(", nextPhase=").append(this.nextPhase);
        sb.append(", isFromDisk=").append(this.isFromDisk);
        sb.append(", remainingEventsForUserOperation=").append(this.remainingEventsForUserOperation);
        sb.append(", userToken=").append(this.userToken);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionBaseTransitionData that = (SubscriptionBaseTransitionData)o;
        if (this.apiEventType != that.apiEventType) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.effectiveTransitionTime != null ? this.effectiveTransitionTime.compareTo((ReadableInstant)that.effectiveTransitionTime) != 0 : that.effectiveTransitionTime != null) {
            return false;
        }
        if (this.eventId != null ? !this.eventId.equals(that.eventId) : that.eventId != null) {
            return false;
        }
        if (this.eventType != that.eventType) {
            return false;
        }
        if (this.isFromDisk != null ? !this.isFromDisk.equals(that.isFromDisk) : that.isFromDisk != null) {
            return false;
        }
        if (this.nextPhase != null ? !this.nextPhase.equals(that.nextPhase) : that.nextPhase != null) {
            return false;
        }
        if (this.nextPlan != null ? !this.nextPlan.equals(that.nextPlan) : that.nextPlan != null) {
            return false;
        }
        if (this.nextPriceList != null ? !this.nextPriceList.equals(that.nextPriceList) : that.nextPriceList != null) {
            return false;
        }
        if (this.nextState != that.nextState) {
            return false;
        }
        if (this.previousPhase != null ? !this.previousPhase.equals(that.previousPhase) : that.previousPhase != null) {
            return false;
        }
        if (this.previousPlan != null ? !this.previousPlan.equals(that.previousPlan) : that.previousPlan != null) {
            return false;
        }
        if (this.previousPriceList != null ? !this.previousPriceList.equals(that.previousPriceList) : that.previousPriceList != null) {
            return false;
        }
        if (this.previousState != that.previousState) {
            return false;
        }
        if (this.remainingEventsForUserOperation != null ? !this.remainingEventsForUserOperation.equals(that.remainingEventsForUserOperation) : that.remainingEventsForUserOperation != null) {
            return false;
        }
        if (this.requestedTransitionTime != null ? this.requestedTransitionTime.compareTo((ReadableInstant)that.requestedTransitionTime) != 0 : that.requestedTransitionTime != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.totalOrdering != null ? !this.totalOrdering.equals(that.totalOrdering) : that.totalOrdering != null) {
            return false;
        }
        return !(this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null);
    }

    public int hashCode() {
        int result = this.totalOrdering != null ? this.totalOrdering.hashCode() : 0;
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.eventId != null ? this.eventId.hashCode() : 0);
        result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
        result = 31 * result + (this.apiEventType != null ? this.apiEventType.hashCode() : 0);
        result = 31 * result + (this.requestedTransitionTime != null ? this.requestedTransitionTime.hashCode() : 0);
        result = 31 * result + (this.effectiveTransitionTime != null ? this.effectiveTransitionTime.hashCode() : 0);
        result = 31 * result + (this.previousState != null ? this.previousState.hashCode() : 0);
        result = 31 * result + (this.previousPriceList != null ? this.previousPriceList.hashCode() : 0);
        result = 31 * result + (this.previousPlan != null ? this.previousPlan.hashCode() : 0);
        result = 31 * result + (this.previousPhase != null ? this.previousPhase.hashCode() : 0);
        result = 31 * result + (this.nextState != null ? this.nextState.hashCode() : 0);
        result = 31 * result + (this.nextPriceList != null ? this.nextPriceList.hashCode() : 0);
        result = 31 * result + (this.nextPlan != null ? this.nextPlan.hashCode() : 0);
        result = 31 * result + (this.nextPhase != null ? this.nextPhase.hashCode() : 0);
        result = 31 * result + (this.isFromDisk != null ? this.isFromDisk.hashCode() : 0);
        result = 31 * result + (this.remainingEventsForUserOperation != null ? this.remainingEventsForUserOperation.hashCode() : 0);
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        return result;
    }
}

