/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.dao.model;

import com.ning.billing.entity.EntityBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.util.dao.TableName;
import com.ning.billing.util.entity.dao.EntityModelDao;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionBundleModelDao
extends EntityBase
implements EntityModelDao<SubscriptionBaseBundle> {
    private String externalKey;
    private UUID accountId;
    private DateTime lastSysUpdateDate;
    private DateTime originalCreatedDate;

    public SubscriptionBundleModelDao() {
    }

    public SubscriptionBundleModelDao(UUID id, String key, UUID accountId, DateTime lastSysUpdateDate, DateTime createdDate, DateTime originalCreatedDate, DateTime updateDate) {
        super(id, createdDate, updateDate);
        this.externalKey = key;
        this.accountId = accountId;
        this.lastSysUpdateDate = lastSysUpdateDate;
        this.originalCreatedDate = originalCreatedDate;
    }

    public SubscriptionBundleModelDao(DefaultSubscriptionBaseBundle input) {
        this(input.getId(), input.getExternalKey(), input.getAccountId(), input.getLastSysUpdateDate(), input.getCreatedDate(), input.getOriginalCreatedDate(), input.getUpdatedDate());
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public DateTime getLastSysUpdateDate() {
        return this.lastSysUpdateDate;
    }

    public DateTime getOriginalCreatedDate() {
        return this.originalCreatedDate;
    }

    public static SubscriptionBaseBundle toSubscriptionbundle(SubscriptionBundleModelDao src) {
        if (src == null) {
            return null;
        }
        return new DefaultSubscriptionBaseBundle(src.getId(), src.getExternalKey(), src.getAccountId(), src.getLastSysUpdateDate(), src.getOriginalCreatedDate(), src.getCreatedDate(), src.getUpdatedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionBundleModelDao");
        sb.append("{externalKey='").append(this.externalKey).append('\'');
        sb.append(", accountId=").append(this.accountId);
        sb.append(", lastSysUpdateDate=").append(this.lastSysUpdateDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionBundleModelDao that = (SubscriptionBundleModelDao)((Object)o);
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.lastSysUpdateDate != null ? this.lastSysUpdateDate.compareTo((ReadableInstant)that.lastSysUpdateDate) != 0 : that.lastSysUpdateDate != null) {
            return false;
        }
        return !(this.originalCreatedDate != null ? this.originalCreatedDate.compareTo((ReadableInstant)that.originalCreatedDate) != 0 : that.originalCreatedDate != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.lastSysUpdateDate != null ? this.lastSysUpdateDate.hashCode() : 0);
        result = 31 * result + (this.originalCreatedDate != null ? this.originalCreatedDate.hashCode() : 0);
        return result;
    }

    public TableName getTableName() {
        return TableName.BUNDLES;
    }

    public TableName getHistoryTableName() {
        return null;
    }
}

