/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.clock.Clock;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionApiBase {
    protected final SubscriptionDao dao;
    protected final SubscriptionBaseApiService apiService;
    protected final Clock clock;
    protected final CatalogService catalogService;

    public SubscriptionApiBase(SubscriptionDao dao, SubscriptionBaseApiService apiService, Clock clock, CatalogService catalogService) {
        this.dao = dao;
        this.apiService = apiService;
        this.clock = clock;
        this.catalogService = catalogService;
    }

    protected List<SubscriptionBase> createSubscriptionsForApiUse(List<SubscriptionBase> internalSubscriptions) {
        return new ArrayList<SubscriptionBase>(Collections2.transform(internalSubscriptions, (Function)new Function<SubscriptionBase, SubscriptionBase>(){

            public SubscriptionBase apply(SubscriptionBase subscription) {
                return SubscriptionApiBase.this.createSubscriptionForApiUse((DefaultSubscriptionBase)subscription);
            }
        }));
    }

    protected DefaultSubscriptionBase createSubscriptionForApiUse(SubscriptionBase internalSubscription) {
        return new DefaultSubscriptionBase((DefaultSubscriptionBase)internalSubscription, this.apiService, this.clock);
    }

    protected DefaultSubscriptionBase createSubscriptionForApiUse(SubscriptionBuilder builder, List<SubscriptionBaseEvent> events) {
        DefaultSubscriptionBase subscription = new DefaultSubscriptionBase(builder, this.apiService, this.clock);
        if (events.size() > 0) {
            subscription.rebuildTransitions(events, this.catalogService.getFullCatalog());
        }
        return subscription;
    }
}

